/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.CustomThreadFactory;

public final class DefaultScheduler {
    private static final long HOUR_MILLIS = 3600000L;
    private static final long DAY_MILLIS = 86400000L;
    public static final ScheduledExecutorService INSTANCE = new ScheduledThreadPoolExecutor((int)Integer.getInteger("spf4j.executors.defaultScheduler.coreThreads", 2), new CustomThreadFactory("DefaultScheduler", Boolean.getBoolean("spf4j.executors.defaultScheduler.daemon"), Integer.getInteger("spf4j.executors.defaultScheduler.priority", 5)));
    public static final ListeningScheduledExecutorService LISTENABLE_INSTANCE = MoreExecutors.listeningDecorator((ScheduledExecutorService)INSTANCE);

    private DefaultScheduler() {
    }

    public static ScheduledFuture<?> scheduleAllignedAtFixedRateMillis(Runnable command, long millisInterval) {
        long nextScheduleTime;
        long currentTime = System.currentTimeMillis();
        if (millisInterval < 3600000L) {
            long millisPastHour = currentTime % 3600000L;
            nextScheduleTime = (millisPastHour / millisInterval + 1L) * millisInterval + currentTime - millisPastHour;
        } else {
            long millisPastDay = currentTime % 86400000L;
            nextScheduleTime = (millisPastDay / millisInterval + 1L) * millisInterval + currentTime - millisPastDay;
        }
        return INSTANCE.scheduleAtFixedRate(command, nextScheduleTime - currentTime, millisInterval, TimeUnit.MILLISECONDS);
    }

    static {
        Runtime.queueHookAtEnd(new AbstractRunnable(true){

            @Override
            public void doRun() throws InterruptedException {
                INSTANCE.shutdown();
                INSTANCE.awaitTermination(Runtime.WAIT_FOR_SHUTDOWN_MILLIS, TimeUnit.MILLISECONDS);
                List<Runnable> remaining = INSTANCE.shutdownNow();
                if (remaining.size() > 0) {
                    System.err.println("Remaining tasks: " + remaining);
                }
            }
        });
    }
}

