/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.base.Charsets;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.WillClose;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.LockRuntimeException;

public final class FileBasedLock
implements Lock,
Closeable {
    private static final Cache<String, FileBasedLock> FILE_LOCKS = CacheBuilder.newBuilder().weakValues().build();
    public static final FileAttribute<?>[] NO_FILE_ATTRS = new FileAttribute[0];
    private final RandomAccessFile file;
    private final ReentrantLock jvmLock;
    private FileLock fileLock;

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"})
    private static int next(int maxVal) {
        return ThreadLocalRandom.current().nextInt(maxVal);
    }

    private FileBasedLock(File lockFile, FileAttribute<?> ... fileAttributes) throws IOException {
        Set<PosixFilePermission> actualPermissions;
        Path toPath = lockFile.toPath();
        Set<PosixFilePermission> requestedPermissions = FileBasedLock.extractPosixPermissions(fileAttributes);
        boolean isWindows = Runtime.isWindows();
        try {
            if (isWindows && !requestedPermissions.isEmpty()) {
                Files.createFile(toPath, new FileAttribute[0]);
            } else {
                Files.createFile(toPath, fileAttributes);
            }
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        if (!(isWindows || requestedPermissions.isEmpty() || requestedPermissions.equals(actualPermissions = Files.getPosixFilePermissions(toPath, new LinkOption[0])))) {
            Files.setPosixFilePermissions(toPath, requestedPermissions);
        }
        this.file = new RandomAccessFile(lockFile, "rws");
        this.jvmLock = new ReentrantLock();
        this.fileLock = null;
    }

    public static Set<PosixFilePermission> extractPosixPermissions(FileAttribute<?>[] fileAttributes) {
        EnumSet<PosixFilePermission> permissions = null;
        for (FileAttribute<?> attr : fileAttributes) {
            Object value = attr.value();
            if (!(value instanceof Set)) continue;
            Set set = (Set)value;
            for (Object obj : set) {
                if (!(obj instanceof PosixFilePermission)) continue;
                if (permissions == null) {
                    permissions = EnumSet.of((PosixFilePermission)((Object)obj));
                    continue;
                }
                permissions.add((PosixFilePermission)((Object)obj));
            }
        }
        return permissions == null ? Collections.EMPTY_SET : permissions;
    }

    public static FileBasedLock getLock(File lockFile, FileAttribute<?> ... fileAttributes) throws IOException {
        String filePath = lockFile.getCanonicalPath();
        try {
            return (FileBasedLock)FILE_LOCKS.get((Object)filePath, () -> new FileBasedLock(lockFile, fileAttributes));
        }
        catch (ExecutionException ex) {
            throw new IOException(ex);
        }
    }

    public static FileBasedLock getLock(File lockFile) throws IOException {
        return FileBasedLock.getLock(lockFile, NO_FILE_ATTRS);
    }

    @Override
    @SuppressFBWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT"})
    public void lock() {
        this.jvmLock.lock();
        if (this.jvmLock.getHoldCount() > 1) {
            return;
        }
        try {
            this.fileLock = this.file.getChannel().lock();
            this.writeHolderInfo();
        }
        catch (IOException ex) {
            throw new LockRuntimeException(ex);
        }
        finally {
            this.jvmLock.unlock();
        }
    }

    @Override
    @SuppressFBWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT", "EXS_EXCEPTION_SOFTENING_HAS_CHECKED", "MDM_THREAD_YIELD"})
    public void lockInterruptibly() throws InterruptedException {
        this.jvmLock.lockInterruptibly();
        if (this.jvmLock.getHoldCount() > 1) {
            return;
        }
        try {
            FileChannel channel = this.file.getChannel();
            boolean interrupted = false;
            while ((this.fileLock = channel.tryLock()) == null && !(interrupted = Thread.interrupted())) {
                Thread.sleep(FileBasedLock.next(1000));
            }
            if (interrupted) {
                throw new InterruptedException();
            }
            this.writeHolderInfo();
        }
        catch (InterruptedException | RuntimeException ex) {
            this.jvmLock.unlock();
            throw ex;
        }
        catch (IOException ex) {
            this.jvmLock.unlock();
            throw new LockRuntimeException(ex);
        }
    }

    @Override
    @SuppressFBWarnings(value={"MDM_THREAD_FAIRNESS"})
    public boolean tryLock() {
        if (this.jvmLock.tryLock()) {
            if (this.jvmLock.getHoldCount() > 1) {
                return true;
            }
            try {
                this.fileLock = this.file.getChannel().tryLock();
                if (this.fileLock != null) {
                    this.writeHolderInfo();
                    return true;
                }
                this.jvmLock.unlock();
                return false;
            }
            catch (IOException ex) {
                this.jvmLock.unlock();
                throw new LockRuntimeException(ex);
            }
            catch (RuntimeException ex) {
                this.jvmLock.unlock();
                throw ex;
            }
        }
        return false;
    }

    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_HAS_CHECKED", "MDM_THREAD_YIELD"})
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        if (this.jvmLock.tryLock(time, unit)) {
            if (this.jvmLock.getHoldCount() > 1) {
                return true;
            }
            try {
                long maxWaitTime = unit.toMillis(time);
                boolean interrupted = false;
                for (long waitTime = 0L; waitTime < maxWaitTime && (this.fileLock = this.file.getChannel().tryLock()) == null && !(interrupted = Thread.interrupted()); ++waitTime) {
                    Thread.sleep(FileBasedLock.next(1000));
                }
                if (interrupted) {
                    throw new InterruptedException();
                }
                if (this.fileLock != null) {
                    this.writeHolderInfo();
                    return true;
                }
                this.jvmLock.unlock();
                return false;
            }
            catch (InterruptedException | RuntimeException ex) {
                this.jvmLock.unlock();
                throw ex;
            }
            catch (IOException ex) {
                this.jvmLock.unlock();
                throw new LockRuntimeException(ex);
            }
        }
        return false;
    }

    @Override
    public void unlock() {
        try {
            if (this.jvmLock.getHoldCount() == 1) {
                this.fileLock.release();
            }
        }
        catch (IOException ex) {
            throw new LockRuntimeException(ex);
        }
        finally {
            this.jvmLock.unlock();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    @WillClose
    public void close() {
        if (this.jvmLock.getHoldCount() > 0) {
            this.unlock();
        }
    }

    protected void finalize() throws Throwable {
        try (RandomAccessFile f = this.file;){
            super.finalize();
        }
    }

    private void writeHolderInfo() throws IOException {
        this.file.seek(0L);
        byte[] data = FileBasedLock.getContextInfo().getBytes(Charsets.UTF_8);
        this.file.write(data);
        this.file.setLength(data.length);
        this.file.getChannel().force(true);
    }

    public static String getContextInfo() {
        return Runtime.PROCESS_ID + ':' + Thread.currentThread().getName();
    }

    public String toString() {
        return "FileBasedLock{file=" + this.file + '}';
    }

    public int getLocalHoldCount() {
        return this.jvmLock.getHoldCount();
    }

    @SuppressFBWarnings(value={"MDM_LOCK_ISLOCKED"})
    public boolean isHeldByCurrentThread() {
        return this.jvmLock.isHeldByCurrentThread();
    }
}

