/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.spf4j.base.Pair;
import org.spf4j.base.Throwables;

public final class Futures {
    private Futures() {
    }

    @CheckReturnValue
    public static RuntimeException cancelAll(boolean mayInterrupt, Future ... futures) {
        RuntimeException ex = null;
        for (Future future : futures) {
            try {
                future.cancel(mayInterrupt);
            }
            catch (RuntimeException e) {
                ex = ex == null ? e : Throwables.suppress(ex, e);
            }
        }
        return ex;
    }

    @CheckReturnValue
    public static RuntimeException cancelAll(boolean mayInterrupt, Iterator<Future> iterator) {
        RuntimeException ex = null;
        while (iterator.hasNext()) {
            Future future = iterator.next();
            try {
                future.cancel(mayInterrupt);
            }
            catch (RuntimeException e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex = Throwables.suppress(ex, e);
            }
        }
        return ex;
    }

    @CheckReturnValue
    @Nonnull
    public static Pair<Map<Future, Object>, Exception> getAll(long timeoutMillis, Future ... futures) {
        long deadlineNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
        return Futures.getAllWithDeadlineNanos(deadlineNanos, futures);
    }

    @CheckReturnValue
    @Nonnull
    public static Pair<Map<Future, Object>, Exception> getAllWithDeadlineNanos(long deadlineNanos, Future ... futures) {
        Exception exception = null;
        HashMap results = new HashMap(futures.length);
        for (int i = 0; i < futures.length; ++i) {
            Future future = futures[i];
            try {
                long toNanos = deadlineNanos - System.nanoTime();
                if (toNanos <= 0L) {
                    throw new TimeoutException("Timed out when about to run " + future);
                }
                results.put(future, future.get(toNanos, TimeUnit.NANOSECONDS));
                continue;
            }
            catch (InterruptedException | TimeoutException ex) {
                RuntimeException cex;
                exception = exception == null ? ex : Throwables.suppress(ex, exception);
                int next = i + 1;
                if (next >= futures.length || (cex = Futures.cancelAll(true, Arrays.copyOfRange(futures, next, futures.length))) == null) break;
                exception = Throwables.suppress(exception, cex);
                break;
            }
            catch (RuntimeException | ExecutionException ex) {
                exception = exception == null ? ex : Throwables.suppress(exception, ex);
            }
        }
        return Pair.of(results, exception);
    }

    @CheckReturnValue
    @Nonnull
    public static Pair<Map<Future, Object>, Exception> getAll(long timeoutMillis, Iterable<Future> futures) {
        long deadlineNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
        return Futures.getAllWithDeadlineNanos(deadlineNanos, futures);
    }

    @CheckReturnValue
    @Nonnull
    public static Pair<Map<Future, Object>, Exception> getAllWithDeadlineNanos(long deadlineNanos, Iterable<Future> futures) {
        Exception exception = null;
        HashMap results = futures instanceof Collection ? new HashMap(((Collection)futures).size()) : new HashMap();
        Iterator<Future> iterator = futures.iterator();
        while (iterator.hasNext()) {
            Future future = iterator.next();
            try {
                long toNanos = deadlineNanos - System.nanoTime();
                if (toNanos > 0L) {
                    results.put(future, future.get(toNanos, TimeUnit.NANOSECONDS));
                    continue;
                }
                throw new TimeoutException("Timed out when about to run " + future);
            }
            catch (InterruptedException | TimeoutException ex) {
                exception = exception == null ? ex : Throwables.suppress(ex, exception);
                RuntimeException cex = Futures.cancelAll(true, iterator);
                if (cex == null) break;
                exception = Throwables.suppress(exception, cex);
                break;
            }
            catch (RuntimeException | ExecutionException ex) {
                if (exception == null) {
                    exception = ex;
                    continue;
                }
                exception = Throwables.suppress(exception, ex);
            }
        }
        return Pair.of(results, exception);
    }
}

