/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.concurrent.LifoThreadPoolExecutorSQP;
import org.spf4j.concurrent.MutableLifoThreadPool;
import org.spf4j.concurrent.RejectedExecutionHandler;
import org.spf4j.concurrent.UnitQueuePU;
import org.spf4j.ds.ZArrayDequeue;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.stackmonitor.StackTrace;
import sun.misc.Contended;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"MDM_THREAD_PRIORITIES", "MDM_WAIT_WITHOUT_TIMEOUT"})
@Beta
public final class MutableLifoThreadPoolExecutorSQP
extends AbstractExecutorService
implements MutableLifoThreadPool {
    @GuardedBy(value="stateLock")
    private final Queue<Runnable> taskQueue;
    @GuardedBy(value="stateLock")
    private final ZArrayDequeue<QueuedThread> threadQueue;
    @Contended(value="mutgr")
    @GuardedBy(value="stateLock")
    private int maxThreadCount;
    @GuardedBy(value="stateLock")
    private final PoolState state;
    private final ReentrantLock stateLock;
    private final Condition stateCondition;
    @Contended(value="mutgr")
    @GuardedBy(value="stateLock")
    private int queueSizeLimit;
    @Contended(value="mutgr")
    @GuardedBy(value="stateLock")
    private boolean daemonThreads;
    @Contended(value="mutgr")
    @GuardedBy(value="stateLock")
    private int threadPriority;
    private final String poolName;
    private final RejectedExecutionHandler rejectionHandler;

    public MutableLifoThreadPoolExecutorSQP(String poolName, int coreSize, int maxSize, int maxIdleTimeMillis, int queueSize) {
        this(poolName, coreSize, maxSize, maxIdleTimeMillis, queueSize, 1024);
    }

    public MutableLifoThreadPoolExecutorSQP(String poolName, int coreSize, int maxSize, int maxIdleTimeMillis, int queueSizeLimit, int spinLockCount) {
        this(poolName, coreSize, maxSize, maxIdleTimeMillis, new ArrayDeque<Runnable>(Math.min(queueSizeLimit, LifoThreadPoolExecutorSQP.LL_THRESHOLD)), queueSizeLimit, false, spinLockCount, RejectedExecutionHandler.REJECT_EXCEPTION_EXEC_HANDLER);
    }

    public MutableLifoThreadPoolExecutorSQP(String poolName, int coreSize, int maxSize, int maxIdleTimeMillis, Queue<Runnable> taskQueue, int queueSizeLimit, boolean daemonThreads, int spinLockCount, RejectedExecutionHandler rejectionHandler) {
        this(poolName, coreSize, maxSize, maxIdleTimeMillis, taskQueue, queueSizeLimit, daemonThreads, spinLockCount, rejectionHandler, 5);
    }

    public MutableLifoThreadPoolExecutorSQP(String poolName, int coreSize, int maxSize, int maxIdleTimeMillis, Queue<Runnable> taskQueue, int queueSizeLimit, boolean daemonThreads, int spinLockCount, RejectedExecutionHandler rejectionHandler, int threadPriority) {
        if (coreSize > maxSize) {
            throw new IllegalArgumentException("Core size must be smaller than max size " + coreSize + " < " + maxSize);
        }
        if (coreSize < 0 || maxSize < 0 || spinLockCount < 0 || maxIdleTimeMillis < 0 || queueSizeLimit < 0) {
            throw new IllegalArgumentException("All numberic TP configs must be positive values: " + coreSize + ", " + maxSize + ", " + maxIdleTimeMillis + ", " + spinLockCount + ", " + queueSizeLimit);
        }
        this.rejectionHandler = rejectionHandler;
        this.poolName = poolName;
        this.taskQueue = taskQueue;
        this.queueSizeLimit = queueSizeLimit;
        this.threadQueue = new ZArrayDequeue(Math.min(1024, maxSize));
        this.daemonThreads = daemonThreads;
        this.state = new PoolState(coreSize, spinLockCount, (Set<QueuedThread>)new THashSet(Math.min(maxSize, 2048)), maxIdleTimeMillis);
        this.stateLock = new ReentrantLock(false);
        this.stateCondition = this.stateLock.newCondition();
        this.threadPriority = threadPriority;
        for (int i = 0; i < coreSize; ++i) {
            QueuedThread qt = new QueuedThread(poolName, this.threadQueue, taskQueue, null, this.state, this.stateLock, this.stateCondition);
            this.state.addThread(qt);
            qt.setDaemon(daemonThreads);
            qt.setPriority(threadPriority);
            qt.start();
        }
        this.maxThreadCount = maxSize;
    }

    @Override
    public void exportJmx() {
        Registry.export(MutableLifoThreadPoolExecutorSQP.class.getName(), this.poolName, this);
    }

    @Override
    @SuppressFBWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT", "MDM_LOCK_ISLOCKED", "UL_UNRELEASED_LOCK_EXCEPTION_PATH"}, justification="no blocking is done while holding the lock, lock is released on all paths, findbugs just cannot figure it out...")
    public void execute(Runnable command) {
        this.stateLock.lock();
        if (this.state.isShutdown()) {
            this.stateLock.unlock();
            this.rejectionHandler.rejectedExecution(command, this);
            return;
        }
        try {
            QueuedThread nqt;
            while ((nqt = this.threadQueue.pollLast()) != null) {
                this.stateLock.unlock();
                if (nqt.runNext(command)) {
                    return;
                }
                this.stateLock.lock();
            }
            int tc = this.state.getThreadCount();
            if (tc < this.maxThreadCount) {
                QueuedThread qt = new QueuedThread(this.poolName, this.threadQueue, this.taskQueue, command, this.state, this.stateLock, this.stateCondition);
                qt.setDaemon(this.daemonThreads);
                qt.setPriority(this.threadPriority);
                this.state.addThread(qt);
                this.stateLock.unlock();
                qt.start();
                return;
            }
            if (this.taskQueue.size() >= this.queueSizeLimit) {
                this.stateLock.unlock();
                this.rejectionHandler.rejectedExecution(command, this);
            } else if (!this.taskQueue.offer(command)) {
                this.stateLock.unlock();
                this.rejectionHandler.rejectedExecution(command, this);
            } else {
                this.stateLock.unlock();
            }
        }
        catch (Throwable t) {
            if (this.stateLock.isHeldByCurrentThread()) {
                this.stateLock.unlock();
            }
            throw t;
        }
    }

    @Override
    @JmxExport
    @SuppressFBWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT"})
    public void shutdown() {
        this.stateLock.lock();
        try {
            if (!this.state.isShutdown()) {
                QueuedThread th;
                this.state.setShutdown(true);
                while ((th = this.threadQueue.pollLast()) != null) {
                    th.signal();
                }
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @JmxExport
    @SuppressFBWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT"})
    public void start() {
        this.stateLock.lock();
        try {
            this.state.setShutdown(false);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public void unregisterJmx() {
        Registry.unregister(MutableLifoThreadPoolExecutorSQP.class.getName(), this.poolName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        int threadCount;
        long deadlinenanos = System.nanoTime() + TimeUnit.NANOSECONDS.convert(time, unit);
        this.stateLock.lock();
        try {
            if (!this.state.isShutdown()) {
                throw new IllegalStateException("Threadpool is not is shutdown mode " + this);
            }
            threadCount = this.state.getThreadCount();
            long timeoutNs = deadlinenanos - System.nanoTime();
            while (threadCount > 0 && timeoutNs > 0L) {
                timeoutNs = this.stateCondition.awaitNanos(timeoutNs);
                threadCount = this.state.getThreadCount();
            }
        }
        finally {
            this.stateLock.unlock();
        }
        return threadCount == 0;
    }

    @Override
    @JmxExport
    public List<Runnable> shutdownNow() {
        this.shutdown();
        this.stateLock.lock();
        try {
            this.state.interruptAll();
            ArrayList<Runnable> arrayList = new ArrayList<Runnable>(this.taskQueue);
            return arrayList;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public boolean isShutdown() {
        this.stateLock.lock();
        try {
            boolean bl = this.state.isShutdown();
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public boolean isTerminated() {
        this.stateLock.lock();
        try {
            boolean bl = this.state.isShutdown() && this.state.getThreadCount() == 0;
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public int getThreadCount() {
        this.stateLock.lock();
        try {
            int n = this.state.getThreadCount();
            return n;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public int getMaxThreadCount() {
        this.stateLock.lock();
        try {
            int n = this.maxThreadCount;
            return n;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public void setMaxThreadCount(int maxThreadCount) {
        this.stateLock.lock();
        try {
            this.maxThreadCount = maxThreadCount;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public boolean isDaemonThreads() {
        this.stateLock.lock();
        try {
            boolean bl = this.daemonThreads;
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public void setDaemonThreads(boolean daemonThreads) {
        this.stateLock.lock();
        try {
            this.daemonThreads = daemonThreads;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public ReentrantLock getStateLock() {
        return this.stateLock;
    }

    @Override
    @JmxExport
    @SuppressFBWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT"}, justification="Holders of this lock will not block")
    public int getNrQueuedTasks() {
        this.stateLock.lock();
        try {
            int n = this.taskQueue.size();
            return n;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public int getQueueSizeLimit() {
        this.stateLock.lock();
        try {
            int n = this.queueSizeLimit;
            return n;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public void setQueueSizeLimit(int queueSizeLimit) {
        this.stateLock.lock();
        try {
            this.queueSizeLimit = queueSizeLimit;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public int getThreadPriority() {
        this.stateLock.lock();
        try {
            int n = this.threadPriority;
            return n;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public void setThreadPriority(int threadPriority) {
        this.stateLock.lock();
        try {
            this.threadPriority = threadPriority;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public String toString() {
        return "LifoThreadPoolExecutorSQP{threadQueue=" + this.threadQueue + ", maxThreadCount=" + this.maxThreadCount + ", state=" + this.state + ", submitMonitor=" + this.stateLock + ", queueCapacity=" + this.queueSizeLimit + ", poolName=" + this.poolName + '}';
    }

    @Override
    public Queue<Runnable> getTaskQueue() {
        return this.taskQueue;
    }

    @Override
    @JmxExport
    public int getMaxIdleTimeMillis() {
        this.stateLock.lock();
        try {
            int n = this.state.getMaxIdleTimeMillis();
            return n;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public void setMaxIdleTimeMillis(int maxIdleTimeMillis) {
        this.stateLock.lock();
        try {
            this.state.setMaxIdleTimeMillis(maxIdleTimeMillis);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    private static final class PoolState {
        @Contended(value="mutgr")
        private int maxIdleTimeMillis;
        @Contended(value="mutgr")
        private long maxIdleTimeNanos;
        @Contended(value="mutgr")
        private boolean shutdown = false;
        private final int spinlockCount;
        private final int coreThreads;
        private final Set<QueuedThread> allThreads;

        PoolState(int thnr, int spinlockCount, Set<QueuedThread> allThreads, int maxIdleTimeMillis) {
            this.coreThreads = thnr;
            this.spinlockCount = spinlockCount;
            this.allThreads = allThreads;
            this.maxIdleTimeMillis = maxIdleTimeMillis;
            this.maxIdleTimeNanos = TimeUnit.NANOSECONDS.convert(maxIdleTimeMillis, TimeUnit.MILLISECONDS);
        }

        public int getMaxIdleTimeMillis() {
            return this.maxIdleTimeMillis;
        }

        public long getMaxIdleTimeNanos() {
            return this.maxIdleTimeNanos;
        }

        public void setMaxIdleTimeMillis(int maxIdleTimeMillis) {
            this.maxIdleTimeMillis = maxIdleTimeMillis;
            this.maxIdleTimeNanos = TimeUnit.NANOSECONDS.convert(maxIdleTimeMillis, TimeUnit.MILLISECONDS);
        }

        public void addThread(QueuedThread thread) {
            if (!this.allThreads.add(thread)) {
                throw new IllegalStateException("Attempting to add a thread twice: " + thread);
            }
        }

        public void removeThread(QueuedThread thread) {
            if (!this.allThreads.remove(thread)) {
                throw new IllegalStateException("Removing thread failed: " + thread);
            }
        }

        public void interruptAll() {
            for (Thread thread : this.allThreads) {
                thread.interrupt();
            }
        }

        public int getCoreThreads() {
            return this.coreThreads;
        }

        public int getSpinlockCount() {
            return this.spinlockCount;
        }

        public boolean isShutdown() {
            return this.shutdown;
        }

        public void setShutdown(boolean shutdown) {
            this.shutdown = shutdown;
        }

        public int getThreadCount() {
            return this.allThreads.size();
        }

        public String toString() {
            return "ExecState{shutdown=" + this.shutdown + ", threadCount=" + this.allThreads.size() + ", spinlockCount=" + this.spinlockCount + '}';
        }
    }

    @SuppressFBWarnings(value={"NO_NOTIFY_NOT_NOTIFYALL"})
    private static final class QueuedThread
    extends Thread {
        private static final AtomicInteger COUNT = new AtomicInteger();
        private final ZArrayDequeue<QueuedThread> threadQueue;
        private final Queue<Runnable> taskQueue;
        private Runnable runFirst;
        private final UnitQueuePU<Runnable> toRun;
        private final PoolState state;
        private volatile boolean running;
        private long lastRunNanos;
        private final Object sync;
        private final ReentrantLock submitMonitor;
        private final Condition submitCondition;

        QueuedThread(String nameBase, ZArrayDequeue<QueuedThread> threadQueue, Queue<Runnable> taskQueue, @Nullable Runnable runFirst, PoolState state, ReentrantLock submitMonitor, Condition submitCondition) {
            super(nameBase + COUNT.getAndIncrement());
            this.threadQueue = threadQueue;
            this.taskQueue = taskQueue;
            this.runFirst = runFirst;
            this.state = state;
            this.running = false;
            this.sync = new Object();
            this.lastRunNanos = System.nanoTime();
            this.submitMonitor = submitMonitor;
            this.submitCondition = submitCondition;
            this.toRun = new UnitQueuePU(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckReturnValue
        public boolean runNext(Runnable runnable) {
            Object object = this.sync;
            synchronized (object) {
                if (!this.running) {
                    return false;
                }
                return this.toRun.offer(runnable);
            }
        }

        @SuppressFBWarnings
        public void signal() {
            this.toRun.offer(AbstractRunnable.NOP);
        }

        public boolean isRunning() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean shouldRun = true;
            long minWaitNanos = 0L;
            do {
                try {
                    this.doRun(minWaitNanos);
                }
                catch (Throwable e) {
                    Thread.UncaughtExceptionHandler uexh = this.getUncaughtExceptionHandler();
                    try {
                        uexh.uncaughtException(this, e);
                    }
                    catch (RuntimeException ex) {
                        ex.addSuppressed(e);
                        throw new UncheckedExecutionException("Uncaught exception handler blew up: " + uexh, (Throwable)ex);
                    }
                }
                this.submitMonitor.lock();
                try {
                    int tc = this.state.getThreadCount();
                    if (this.state.isShutdown() || tc - 1 >= this.state.getCoreThreads()) {
                        this.state.removeThread(this);
                        shouldRun = false;
                        this.submitCondition.signalAll();
                        break;
                    }
                    this.lastRunNanos = System.nanoTime();
                    minWaitNanos = Math.max(LifoThreadPoolExecutorSQP.CORE_MINWAIT_NANOS, this.state.getMaxIdleTimeNanos());
                }
                finally {
                    this.submitMonitor.unlock();
                }
            } while (shouldRun && !this.state.isShutdown());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressFBWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT", "MDM_LOCK_ISLOCKED", "UL_UNRELEASED_LOCK_EXCEPTION_PATH"})
        public void doRun(long minWaitNanos) {
            Object poll;
            this.running = true;
            try {
                if (this.runFirst != null) {
                    try {
                        this.run(this.runFirst);
                    }
                    finally {
                        this.runFirst = null;
                    }
                }
                block16: while (this.running) {
                    this.submitMonitor.lock();
                    poll = this.taskQueue.poll();
                    if (poll == null) {
                        Runnable runnable;
                        if (this.state.isShutdown()) {
                            this.submitMonitor.unlock();
                            this.running = false;
                            break;
                        }
                        int ptr = this.threadQueue.addLastAndGetPtr(this);
                        this.submitMonitor.unlock();
                        do {
                            try {
                                long wTime = Math.max(minWaitNanos, this.state.getMaxIdleTimeNanos()) - (System.nanoTime() - this.lastRunNanos);
                                if (wTime > 0L) {
                                    runnable = this.toRun.poll(wTime, this.state.spinlockCount);
                                    continue;
                                }
                                this.running = false;
                                this.removeThreadFromQueue(ptr);
                            }
                            catch (InterruptedException ex) {
                                this.interrupt();
                                this.running = false;
                                this.removeThreadFromQueue(ptr);
                            }
                            continue block16;
                        } while (runnable == null);
                        this.run(runnable);
                        continue;
                    }
                    this.submitMonitor.unlock();
                    this.run((Runnable)poll);
                }
            }
            catch (Throwable t) {
                this.running = false;
                if (this.submitMonitor.isHeldByCurrentThread()) {
                    this.submitMonitor.unlock();
                }
                throw t;
            }
            finally {
                if (!QueuedThread.interrupted()) {
                    poll = this.sync;
                    synchronized (poll) {
                        Runnable runnable = this.toRun.poll();
                        if (runnable != null) {
                            this.run(runnable);
                        }
                    }
                }
            }
        }

        @SuppressFBWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT"})
        public void removeThreadFromQueue(int ptr) {
            this.submitMonitor.lock();
            try {
                this.threadQueue.delete(ptr, this);
            }
            finally {
                this.submitMonitor.unlock();
            }
        }

        public void run(Runnable runnable) {
            try {
                runnable.run();
            }
            finally {
                this.lastRunNanos = System.nanoTime();
            }
        }

        @Override
        public String toString() {
            Object[] stackTrace;
            try {
                stackTrace = this.getStackTrace();
            }
            catch (RuntimeException ex) {
                stackTrace = StackTrace.EMPTY_STACK_TRACE;
            }
            return "QueuedThread{name = " + this.getName() + ", running=" + this.running + ", lastRunNanos=" + this.lastRunNanos + ", stack =" + Arrays.toString(stackTrace) + ", toRun = " + this.toRun + '}';
        }
    }
}

