/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Callables;
import org.spf4j.base.ParameterizedSupplier;
import org.spf4j.base.Throwables;
import org.spf4j.base.TimeoutRunnable;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.concurrent.FutureBean;

public class RetryExecutor {
    public static final ParameterizedSupplier<Callables.RetryPredicate<Object, Object>, Callable<Object>> NO_RETRY_SUPPLIER = new ParameterizedSupplier<Callables.RetryPredicate<Object, Object>, Callable<Object>>(){

        @Override
        public Callables.RetryPredicate<Object, Object> get(Callable<Object> parameter) {
            return Callables.RetryPredicate.NORETRY_DELAY_PREDICATE;
        }
    };
    private final ExecutorService executionService;
    private final DelayQueue<FailedExecutionResult> executionEvents = new DelayQueue();
    private final ParameterizedSupplier<Callables.RetryPredicate<Object, Object>, Callable<?>> resultRetryPredicateSupplier;
    private final ParameterizedSupplier<Callables.RetryPredicate<Exception, Object>, Callable<?>> exceptionRetryPredicateSupplier;
    private volatile RetryManager retryManager;
    private Future<?> retryManagerFuture;
    private final BlockingQueue<Future<?>> completionQueue;
    private final Object sync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRetryManager() {
        if (this.retryManager == null) {
            Object object = this.sync;
            synchronized (object) {
                if (this.retryManager == null) {
                    this.retryManager = new RetryManager();
                    this.retryManagerFuture = DefaultExecutor.INSTANCE.submit(this.retryManager);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownRetryManager() {
        Object object = this.sync;
        synchronized (object) {
            if (this.retryManager != null) {
                this.retryManager.shutdown();
                this.retryManager = null;
            }
        }
    }

    public RetryExecutor(ExecutorService exec, ParameterizedSupplier<Callables.RetryPredicate<Exception, Object>, Callable<Object>> exceptionRetryPredicateSupplier, @Nullable BlockingQueue<Future<?>> completionQueue) {
        this(exec, NO_RETRY_SUPPLIER, exceptionRetryPredicateSupplier, completionQueue);
    }

    public RetryExecutor(ExecutorService exec, ParameterizedSupplier<Callables.RetryPredicate<Object, Object>, Callable<?>> resultRetryPredicateSupplier, ParameterizedSupplier<Callables.RetryPredicate<Exception, Object>, Callable<?>> exceptionRetryPredicateSupplier, @Nullable BlockingQueue<Future<?>> completionQueue) {
        this.executionService = exec;
        this.resultRetryPredicateSupplier = resultRetryPredicateSupplier;
        this.exceptionRetryPredicateSupplier = exceptionRetryPredicateSupplier;
        this.completionQueue = completionQueue;
    }

    public final void shutdown() {
        this.shutdownRetryManager();
        this.executionService.shutdown();
    }

    public final List<Runnable> shutdownNow() {
        this.shutdownRetryManager();
        return this.executionService.shutdownNow();
    }

    public final boolean isShutdown() {
        return this.executionService.isShutdown();
    }

    public final boolean isTerminated() {
        return this.executionService.isTerminated();
    }

    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.retryManagerFuture.get();
        }
        catch (ExecutionException ex) {
            throw new UncheckedExecutionException((Throwable)ex);
        }
        return this.executionService.awaitTermination(timeout, unit);
    }

    private FutureBean<?> createFutureBean() {
        if (this.completionQueue == null) {
            return new FutureBean();
        }
        return new FutureBean<Object>(){

            @Override
            public void done() {
                RetryExecutor.this.completionQueue.add(this);
            }
        };
    }

    public final <A, E extends Exception> Future<A> submit(Callables.TimeoutCallable<A, E> task) {
        FutureBean<?> result = this.createFutureBean();
        this.executionService.execute(new RetryableCallable<Object>(task, result, null, this.resultRetryPredicateSupplier.get(task), this.exceptionRetryPredicateSupplier.get(task)));
        return result;
    }

    public final <A> Future<A> submit(Callable<A> task) {
        FutureBean<?> result = this.createFutureBean();
        this.executionService.execute(new RetryableCallable<Object>(task, result, null, this.resultRetryPredicateSupplier.get(task), this.exceptionRetryPredicateSupplier.get(task)));
        return result;
    }

    public final <A, E extends Exception> Future<A> submit(TimeoutRunnable<E> task, A result) {
        FutureBean<?> resultFuture = this.createFutureBean();
        this.executionService.execute(new RetryableCallable<Object>(task, result, resultFuture, null, this.resultRetryPredicateSupplier.get(task), this.exceptionRetryPredicateSupplier.get(task)));
        return resultFuture;
    }

    public final <E extends Exception> Future<?> submit(TimeoutRunnable<E> task) {
        FutureBean<?> resultFuture = this.createFutureBean();
        this.executionService.execute(new RetryableCallable<Object>(task, null, resultFuture, null, this.resultRetryPredicateSupplier.get(task), this.exceptionRetryPredicateSupplier.get(task)));
        return resultFuture;
    }

    public final <E extends Exception> void execute(TimeoutRunnable<E> command) {
        this.executionService.execute(new RetryableCallable<Object>(command, null, null, null, this.resultRetryPredicateSupplier.get(command), this.exceptionRetryPredicateSupplier.get(command)));
    }

    public final String toString() {
        return "RetryExecutor{executionService=" + this.executionService + ", executionEvents=" + this.executionEvents + ", resultRetryPredicateSupplier=" + this.resultRetryPredicateSupplier + ", exceptionRetryPredicateSupplier=" + this.exceptionRetryPredicateSupplier + ", retryManager=" + this.retryManager + ", retryManagerFuture=" + this.retryManagerFuture + ", completionQueue=" + this.completionQueue + ", sync=" + this.sync + '}';
    }

    private class RetryManager
    extends AbstractRunnable {
        private volatile boolean isRunning;

        RetryManager() {
            super("RetryManager");
            this.isRunning = true;
        }

        public void shutdown() {
            this.isRunning = false;
        }

        @Override
        public void doRun() {
            while (this.isRunning) {
                try {
                    FailedExecutionResult event = (FailedExecutionResult)RetryExecutor.this.executionEvents.poll(1000L, TimeUnit.SECONDS);
                    if (event == null) continue;
                    RetryableCallable<Object> callable = event.getCallable();
                    callable.setPreviousResult(event);
                    RetryExecutor.this.executionService.execute(callable);
                }
                catch (InterruptedException ex) {
                    this.isRunning = false;
                    break;
                }
            }
        }
    }

    private class RetryableCallable<T>
    implements Callable<T>,
    Runnable {
        private volatile Callable<T> callable;
        @Nullable
        private final FutureBean<T> future;
        private volatile FailedExecutionResult previousResult;
        private final Callables.RetryPredicate<Object, T> resultRetryPredicate;
        private final Callables.RetryPredicate<Exception, T> exceptionRetryPredicate;

        RetryableCallable(@Nullable Callable<T> callable, FutureBean<T> future, FailedExecutionResult previousResult, Callables.RetryPredicate<?, T> resultRetryPredicate, Callables.RetryPredicate<Exception, T> exceptionRetryPredicate) {
            this.callable = callable;
            this.future = future;
            this.previousResult = previousResult;
            this.resultRetryPredicate = resultRetryPredicate;
            this.exceptionRetryPredicate = exceptionRetryPredicate;
        }

        RetryableCallable(final Runnable task, final @Nullable Object result, @Nullable FutureBean<T> future, FailedExecutionResult previousResult, Callables.RetryPredicate<?, T> resultRetryPredicate, Callables.RetryPredicate<Exception, T> exceptionRetryPredicate) {
            this(new Callable(){

                public Object call() {
                    task.run();
                    return result;
                }
            }, future, previousResult, resultRetryPredicate, exceptionRetryPredicate);
        }

        @Override
        @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
        public T call() {
            try {
                T result = this.callable.call();
                Callables.RetryDecision<T> decision = this.resultRetryPredicate.getDecision(RetryExecutor.this.sync, this.callable);
                Callables.RetryDecision.Type decisionType = decision.getDecisionType();
                switch (decisionType) {
                    case Retry: {
                        long delay = decision.getDelayMillis();
                        RetryExecutor.this.startRetryManager();
                        this.callable = decision.getNewCallable();
                        RetryExecutor.this.executionEvents.add(new FailedExecutionResult(null, this, delay));
                        break;
                    }
                    case Abort: {
                        if (this.future == null) break;
                        this.future.setResult(result);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid decision type" + (Object)((Object)decisionType));
                    }
                }
                return null;
            }
            catch (Exception e) {
                Callables.RetryDecision<T> decision = this.exceptionRetryPredicate.getDecision(e, this.callable);
                Callables.RetryDecision.Type decisionType = decision.getDecisionType();
                switch (decisionType) {
                    case Retry: {
                        ExecutionException exception;
                        long delay = decision.getDelayMillis();
                        RetryExecutor.this.startRetryManager();
                        this.callable = decision.getNewCallable();
                        RetryExecutor.this.startRetryManager();
                        if (this.previousResult != null && (exception = this.previousResult.getException()) != null) {
                            e = Throwables.suppress(e, exception);
                        }
                        RetryExecutor.this.executionEvents.add(new FailedExecutionResult(new ExecutionException(e), this, delay));
                        break;
                    }
                    case Abort: {
                        if (this.future == null) break;
                        this.future.setExceptionResult(new ExecutionException(e));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid decision type" + (Object)((Object)decisionType), e);
                    }
                }
                return null;
            }
        }

        @Override
        public void run() {
            this.call();
        }

        public FailedExecutionResult getPreviousResult() {
            return this.previousResult;
        }

        public void setPreviousResult(FailedExecutionResult previousResult) {
            this.previousResult = previousResult;
        }
    }

    private static class FailedExecutionResult
    implements Delayed {
        private final ExecutionException exception;
        private final RetryableCallable<Object> callable;
        private final long deadline;

        FailedExecutionResult(@Nullable ExecutionException exception, RetryableCallable callable, long delay) {
            this.exception = exception;
            this.callable = callable;
            this.deadline = delay + System.currentTimeMillis();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            long oDelay;
            long tDelay = this.getDelay(TimeUnit.MILLISECONDS);
            if (tDelay > (oDelay = o.getDelay(TimeUnit.MILLISECONDS))) {
                return 1;
            }
            if (tDelay < oDelay) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof FailedExecutionResult) {
                return this.compareTo((FailedExecutionResult)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            return 53 * hash + (this.callable != null ? this.callable.hashCode() : 0);
        }

        @Nullable
        public ExecutionException getException() {
            return this.exception;
        }

        public RetryableCallable<Object> getCallable() {
            return this.callable;
        }
    }
}

