/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface Semaphore {
    default public void acquire(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.acquire(1, timeout, unit);
    }

    default public void acquire(int nrPermits, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.tryAcquire(nrPermits, timeout, unit)) {
            throw new TimeoutException("Cannot acquire timeout after " + timeout + " " + (Object)((Object)unit));
        }
    }

    @CheckReturnValue
    default public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1, timeout, unit);
    }

    @CheckReturnValue
    public boolean tryAcquire(int var1, long var2, TimeUnit var4) throws InterruptedException;

    default public void release() {
        this.release(1);
    }

    public void release(int var1);
}

