/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.io.BaseEncoding;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Runtime;
import org.spf4j.base.Strings;
import org.spf4j.concurrent.Sequence;

@ParametersAreNonnullByDefault
public final class UIDGenerator
implements Supplier<CharSequence> {
    private static final Logger LOG = LoggerFactory.getLogger(UIDGenerator.class);
    private final Sequence sequence;
    private final StringBuilder base;
    private final int maxSize;

    public UIDGenerator(Sequence sequence) {
        this(sequence, 0L);
    }

    public UIDGenerator(Sequence sequence, String prefix) {
        this(sequence, BaseEncoding.base64Url(), 0L, '.', prefix);
    }

    public UIDGenerator(Sequence sequence, long customEpoch) {
        this(sequence, BaseEncoding.base64Url(), customEpoch, '.', "");
    }

    public UIDGenerator(Sequence sequence, String prefix, long customEpoch) {
        this(sequence, BaseEncoding.base64Url(), customEpoch, '.', prefix);
    }

    @SuppressFBWarnings(value={"STT_TOSTRING_STORED_IN_FIELD"})
    public UIDGenerator(Sequence sequence, BaseEncoding baseEncoding, long customEpoch, char separator, String prefix) {
        StringBuilder sb;
        this.sequence = sequence;
        this.base = sb = UIDGenerator.generateIdBase(prefix, baseEncoding, separator, customEpoch);
        this.maxSize = this.base.length() + 16;
    }

    public static StringBuilder generateIdBase(String prefix, char separator) {
        return UIDGenerator.generateIdBase(prefix, BaseEncoding.base64Url(), separator, 1509741164184L);
    }

    public static StringBuilder generateIdBase(String prefix, char separator, long customEpoch) {
        return UIDGenerator.generateIdBase(prefix, BaseEncoding.base64Url(), separator, customEpoch);
    }

    public static StringBuilder generateIdBase(String prefix, BaseEncoding baseEncoding, char separator, long customEpoch) {
        byte[] intfMac;
        StringBuilder sb = new StringBuilder(16 + prefix.length());
        sb.append(prefix);
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            if (networkInterfaces != null && networkInterfaces.hasMoreElements()) {
                while (((intfMac = networkInterfaces.nextElement().getHardwareAddress()) == null || intfMac.length == 0) && networkInterfaces.hasMoreElements()) {
                }
                if (intfMac == null) {
                    LOG.info("Unable to get interface MAC address for ID generation");
                    intfMac = new byte[]{0};
                }
            } else {
                LOG.info("Unable to get interface MAC address for ID generation");
                intfMac = new byte[]{0};
            }
        }
        catch (SocketException ex) {
            LOG.info("Unable to get interface MAC address for ID generation", (Throwable)ex);
            intfMac = new byte[]{0};
        }
        sb.append(baseEncoding.encode(intfMac)).append(separator);
        Strings.appendUnsignedString(sb, Runtime.PID, 5);
        sb.append(separator);
        Strings.appendUnsignedString(sb, (System.currentTimeMillis() - customEpoch) / 1000L, 5);
        sb.append(separator);
        return sb;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public CharSequence next() {
        StringBuilder result = new StringBuilder(this.maxSize);
        result.append((CharSequence)this.base);
        Strings.appendUnsignedString(result, this.sequence.next(), 5);
        return result;
    }

    public String toString() {
        return "UIDGenerator{sequence=" + this.sequence + ", base=" + this.base + ", maxSize=" + this.maxSize + '}';
    }

    @Override
    public CharSequence get() {
        return this.next();
    }
}

