/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent.jdbc;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.jdbc.DbType;
import org.spf4j.jdbc.JdbcTemplate;

@ParametersAreNonnullByDefault
public final class HeartBeatTableDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final HeartBeatTableDesc DEFAULT = new HeartBeatTableDesc(System.getProperty("spf4j.jdbc.heartBeats.sql.tableName", "HEARTBEATS"), System.getProperty("spf4j.jdbc.heartBeats.sql.ownerColumn", "OWNER"), System.getProperty("spf4j.jdbc.heartBeats.sql.intervalMillisColumn", "INTERVAL_MILLIS"), System.getProperty("spf4j.jdbc.heartBeats.sql.lastHeartBeatMillisColumn", "LAST_HEARTBEAT_INSTANT_MILLIS"), DbType.valueOf(System.getProperty("spf4j.jdbc.heartBeats.sql.dbType", "H2")));
    private final String tableName;
    private final String ownerColumn;
    private final String intervalColumn;
    private final String lastHeartbeatColumn;
    private final DbType dbType;

    public HeartBeatTableDesc(String tableName, String ownerColun, String intervalColumn, String lastHeartbeatColumn, DbType dbType) {
        JdbcTemplate.checkJdbcObjectName(tableName);
        JdbcTemplate.checkJdbcObjectName(ownerColun);
        JdbcTemplate.checkJdbcObjectName(intervalColumn);
        JdbcTemplate.checkJdbcObjectName(lastHeartbeatColumn);
        this.tableName = tableName;
        this.ownerColumn = ownerColun;
        this.intervalColumn = intervalColumn;
        this.lastHeartbeatColumn = lastHeartbeatColumn;
        this.dbType = dbType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getOwnerColumn() {
        return this.ownerColumn;
    }

    public String getIntervalColumn() {
        return this.intervalColumn;
    }

    public String getLastHeartbeatColumn() {
        return this.lastHeartbeatColumn;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public HeartBeatTableDesc withDbType(DbType pdbType) {
        return new HeartBeatTableDesc(this.tableName, this.ownerColumn, this.intervalColumn, this.lastHeartbeatColumn, pdbType);
    }

    public int hashCode() {
        return this.tableName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeartBeatTableDesc other = (HeartBeatTableDesc)obj;
        if (!Objects.equals(this.tableName, other.tableName)) {
            return false;
        }
        if (!Objects.equals(this.ownerColumn, other.ownerColumn)) {
            return false;
        }
        if (!Objects.equals(this.intervalColumn, other.intervalColumn)) {
            return false;
        }
        if (!Objects.equals(this.lastHeartbeatColumn, other.lastHeartbeatColumn)) {
            return false;
        }
        return this.dbType == other.dbType;
    }

    public String toString() {
        return "HeartbeatTableDesc{tableName=" + this.tableName + ", ownerColun=" + this.ownerColumn + ", intervalColumn=" + this.intervalColumn + ", lastHeartbeatColumn=" + this.lastHeartbeatColumn + '}';
    }
}

