/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent.jdbc;

import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.sql.DataSource;
import org.spf4j.concurrent.LockRuntimeException;
import org.spf4j.concurrent.jdbc.JdbcSemaphore;
import org.spf4j.concurrent.jdbc.SemaphoreTablesDesc;

public final class JdbcLock
implements Lock,
AutoCloseable {
    private final JdbcSemaphore semaphore;
    private final int jdbcTimeoutSeconds;

    public JdbcLock(DataSource dataSource, SemaphoreTablesDesc semTableDesc, String lockName, int jdbcTimeoutSeconds) throws InterruptedException, SQLException {
        this.semaphore = new JdbcSemaphore(dataSource, semTableDesc, lockName, 1, jdbcTimeoutSeconds, true);
        this.jdbcTimeoutSeconds = jdbcTimeoutSeconds;
        this.semaphore.registerJmx();
    }

    @Override
    public void lock() {
        try {
            this.semaphore.acquire(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException ex) {
            throw new LockRuntimeException(ex);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        try {
            this.semaphore.acquire(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            throw new LockRuntimeException(ex);
        }
    }

    @Override
    public boolean tryLock() {
        try {
            return this.semaphore.tryAcquire((long)this.jdbcTimeoutSeconds * 2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new LockRuntimeException(ex);
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.semaphore.tryAcquire(time, unit);
    }

    @Override
    public void unlock() {
        this.semaphore.release();
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.semaphore.close();
    }

    public String toString() {
        return "JdbcLock{semaphore=" + this.semaphore + ", jdbcTimeoutSeconds=" + this.jdbcTimeoutSeconds + '}';
    }
}

