/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent.jdbc;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckReturnValue;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.HandlerNano;
import org.spf4j.base.MutableHolder;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.concurrent.LockRuntimeException;
import org.spf4j.concurrent.Semaphore;
import org.spf4j.concurrent.jdbc.HeartBeatTableDesc;
import org.spf4j.concurrent.jdbc.JdbcHeartBeat;
import org.spf4j.concurrent.jdbc.OwnerPermits;
import org.spf4j.concurrent.jdbc.SemaphoreTablesDesc;
import org.spf4j.jdbc.JdbcTemplate;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;

@SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE", "SQL_INJECTION_JDBC", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING", "PREDICTABLE_RANDOM"}, justification="Sql injection is not really possible since the parameterized values are  validated to be java ids")
@Beta
public final class JdbcSemaphore
implements AutoCloseable,
Semaphore {
    private static final int CLEANUP_TIMEOUT_SECONDS = Integer.getInteger("spf4j.jdbc.semaphore.cleanupTimeoutSeconds", 0);
    private static final Logger LOG = LoggerFactory.getLogger(JdbcSemaphore.class);
    private static final ConcurrentMap<String, Object> SYNC_OBJS = new ConcurrentHashMap<String, Object>();
    private final JdbcTemplate jdbc;
    private final String permitsSql;
    private final String ownedPermitsSql;
    private final String totalPermitsSql;
    private final String reducePermitsSql;
    private final String increasePermitsSql;
    private final String updatePermitsSql;
    private final String acquireSql;
    private final String acquireByOwnerSql;
    private final String releaseSql;
    private final String releaseByOwnerSql;
    private final String deleteDeadOwnerRecordsSql;
    private final String getDeadOwnerPermitsSql;
    private final String deleteDeadOwerRecordSql;
    private final String insertLockRowSql;
    private final String insertPermitsByOwnerSql;
    private final int jdbcTimeoutSeconds;
    private final String semName;
    private final Object syncObj;
    private final JdbcHeartBeat heartBeat;
    private volatile boolean isHealthy;
    private Error heartBeatFailure;
    private final int acquirePollMillis;
    private final JdbcHeartBeat.LifecycleHook failureHook;
    private int ownedReservations;

    public JdbcSemaphore(DataSource dataSource, String semaphoreName, int nrPermits) throws InterruptedException, SQLException {
        this(dataSource, semaphoreName, nrPermits, false);
    }

    public JdbcSemaphore(DataSource dataSource, String semaphoreName, int nrPermits, boolean strict) throws InterruptedException, SQLException {
        this(dataSource, SemaphoreTablesDesc.DEFAULT, semaphoreName, nrPermits, Integer.getInteger("spf4j.jdbc.semaphore.jdbcTimeoutSeconds", 10), strict);
    }

    public JdbcSemaphore(DataSource dataSource, SemaphoreTablesDesc semTableDesc, String semaphoreName, int nrPermits, int jdbcTimeoutSeconds, boolean strictReservations) throws InterruptedException, SQLException {
        this(dataSource, semTableDesc, semaphoreName, nrPermits, jdbcTimeoutSeconds, strictReservations, Integer.getInteger("spf4j.jdbc.semaphore.defaultMaxPollIntervalMillis", 1000));
    }

    @SuppressFBWarnings(value={"CBX_CUSTOM_BUILT_XML", "STT_TOSTRING_STORED_IN_FIELD"})
    public JdbcSemaphore(DataSource dataSource, SemaphoreTablesDesc semTableDesc, String semaphoreName, int nrPermits, int jdbcTimeoutSeconds, boolean strictReservations, int acquirePollMillis) throws InterruptedException, SQLException {
        if (nrPermits < 0) {
            throw new IllegalArgumentException("Permits must be positive and not " + nrPermits);
        }
        this.acquirePollMillis = acquirePollMillis;
        this.semName = semaphoreName;
        this.syncObj = SYNC_OBJS.computeIfAbsent(semaphoreName, key -> new Object());
        this.jdbcTimeoutSeconds = jdbcTimeoutSeconds;
        this.jdbc = new JdbcTemplate(dataSource);
        this.isHealthy = true;
        this.ownedReservations = 0;
        this.failureHook = new JdbcHeartBeat.LifecycleHook(){

            @Override
            public void onError(Error error) {
                JdbcSemaphore.this.heartBeatFailure = error;
                JdbcSemaphore.this.isHealthy = false;
            }

            @Override
            public void onClose() {
                JdbcSemaphore.this.close();
            }
        };
        this.heartBeat = JdbcHeartBeat.getHeartBeatAndSubscribe(dataSource, semTableDesc.getHeartBeatTableDesc(), this.failureHook);
        String semaphoreTableName = semTableDesc.getSemaphoreTableName();
        String availablePermitsColumn = semTableDesc.getAvailablePermitsColumn();
        String lastModifiedByColumn = semTableDesc.getLastModifiedByColumn();
        String lastModifiedAtColumn = semTableDesc.getLastModifiedAtColumn();
        String ownerColumn = semTableDesc.getOwnerColumn();
        String semaphoreNameColumn = semTableDesc.getSemNameColumn();
        String totalPermitsColumn = semTableDesc.getTotalPermitsColumn();
        String ownerPermitsColumn = semTableDesc.getOwnerPermitsColumn();
        String permitsByOwnerTableName = semTableDesc.getPermitsByOwnerTableName();
        HeartBeatTableDesc hbTableDesc = this.heartBeat.getHbTableDesc();
        String heartBeatTableName = hbTableDesc.getTableName();
        String heartBeatOwnerColumn = hbTableDesc.getOwnerColumn();
        String currentTimeMillisFunc = hbTableDesc.getDbType().getCurrTSSqlFn();
        this.reducePermitsSql = "UPDATE " + semaphoreTableName + " SET " + totalPermitsColumn + " = " + totalPermitsColumn + " - ?, " + availablePermitsColumn + " = " + availablePermitsColumn + " - ? , " + lastModifiedByColumn + " = ?, " + lastModifiedAtColumn + " = " + currentTimeMillisFunc + " WHERE " + semaphoreNameColumn + " = ? AND " + totalPermitsColumn + " >= ?";
        this.increasePermitsSql = "UPDATE " + semaphoreTableName + " SET " + totalPermitsColumn + " = " + totalPermitsColumn + " + ?, " + availablePermitsColumn + " = " + availablePermitsColumn + " + ?, " + lastModifiedByColumn + " = ?, " + lastModifiedAtColumn + " = " + currentTimeMillisFunc + " WHERE " + semaphoreNameColumn + " = ? ";
        this.updatePermitsSql = "UPDATE " + semaphoreTableName + " SET " + totalPermitsColumn + " =  ?, " + availablePermitsColumn + " =  " + availablePermitsColumn + " + ? - " + totalPermitsColumn + ',' + lastModifiedByColumn + " = ?, " + lastModifiedAtColumn + " = " + currentTimeMillisFunc + " WHERE " + semaphoreNameColumn + " = ?";
        this.acquireSql = "UPDATE " + semaphoreTableName + " SET " + availablePermitsColumn + " = " + availablePermitsColumn + " - ?, " + lastModifiedByColumn + " = ?, " + lastModifiedAtColumn + " = " + currentTimeMillisFunc + " WHERE " + semaphoreNameColumn + " = ? AND " + availablePermitsColumn + " >= ?";
        this.acquireByOwnerSql = "UPDATE " + permitsByOwnerTableName + " SET " + ownerPermitsColumn + " = " + ownerPermitsColumn + " + ?, " + lastModifiedAtColumn + " = " + currentTimeMillisFunc + " WHERE " + ownerColumn + " = ? AND " + semaphoreNameColumn + " = ?";
        this.releaseSql = "UPDATE " + semaphoreTableName + " SET " + availablePermitsColumn + " = CASE WHEN " + availablePermitsColumn + " + ? > " + totalPermitsColumn + " THEN " + totalPermitsColumn + " ELSE " + availablePermitsColumn + " + ? END, " + lastModifiedByColumn + " = ?, " + lastModifiedAtColumn + " = " + currentTimeMillisFunc + " WHERE " + semaphoreNameColumn + " = ?";
        this.releaseByOwnerSql = "UPDATE " + permitsByOwnerTableName + " SET " + ownerPermitsColumn + " = " + ownerPermitsColumn + " - ?, " + lastModifiedAtColumn + " = " + currentTimeMillisFunc + " WHERE " + ownerColumn + " = ? AND " + semaphoreNameColumn + " = ? and " + ownerPermitsColumn + " >= ?";
        this.permitsSql = "SELECT " + availablePermitsColumn + ',' + totalPermitsColumn + " FROM " + semaphoreTableName + " WHERE " + semaphoreNameColumn + " = ?";
        this.totalPermitsSql = "SELECT " + totalPermitsColumn + " FROM " + semaphoreTableName + " WHERE " + semTableDesc.getSemNameColumn() + " = ?";
        this.ownedPermitsSql = "SELECT " + ownerPermitsColumn + " FROM " + permitsByOwnerTableName + " WHERE " + ownerColumn + " = ? AND " + semaphoreNameColumn + " = ?";
        this.deleteDeadOwnerRecordsSql = "DELETE FROM " + permitsByOwnerTableName + " RO WHERE RO." + semaphoreNameColumn + " = ? AND " + ownerPermitsColumn + " = 0 AND NOT EXISTS (select H." + heartBeatOwnerColumn + " from " + heartBeatTableName + " H where H." + heartBeatOwnerColumn + " = RO." + ownerColumn + ')';
        this.getDeadOwnerPermitsSql = "SELECT " + ownerColumn + ", " + ownerPermitsColumn + " FROM " + permitsByOwnerTableName + " RO WHERE RO." + semaphoreNameColumn + " = ? AND  " + ownerPermitsColumn + " > 0 AND NOT EXISTS (select H." + heartBeatOwnerColumn + " from " + heartBeatTableName + " H where H." + heartBeatOwnerColumn + " = RO." + ownerColumn + ") ORDER BY " + ownerColumn + ',' + ownerPermitsColumn;
        this.deleteDeadOwerRecordSql = "DELETE FROM " + permitsByOwnerTableName + " WHERE " + ownerColumn + " = ? AND " + semaphoreNameColumn + " = ? AND " + ownerPermitsColumn + " = ?";
        this.insertLockRowSql = "insert into " + semaphoreTableName + " (" + semaphoreNameColumn + ',' + availablePermitsColumn + ',' + totalPermitsColumn + ',' + lastModifiedByColumn + ',' + lastModifiedAtColumn + ") VALUES (?, ?, ?, ?, " + currentTimeMillisFunc + ')';
        this.insertPermitsByOwnerSql = "insert into " + permitsByOwnerTableName + " (" + semaphoreNameColumn + ',' + ownerColumn + ',' + ownerPermitsColumn + ',' + lastModifiedAtColumn + ") VALUES (?, ?, ?, " + currentTimeMillisFunc + ")";
        try {
            this.createLockRowIfNotPresent(strictReservations, nrPermits);
        }
        catch (SQLIntegrityConstraintViolationException ex) {
            try {
                this.createLockRowIfNotPresent(strictReservations, nrPermits);
            }
            catch (SQLException ex1) {
                ex1.addSuppressed(ex);
                throw ex1;
            }
        }
        this.createOwnerRow();
    }

    public void registerJmx() {
        Registry.export(JdbcSemaphore.class.getName(), this.semName, this);
    }

    public void unregisterJmx() {
        Registry.unregister(JdbcSemaphore.class.getName(), this.semName);
    }

    private void validate() {
        if (!this.isHealthy) {
            throw new IllegalStateException("Heartbeats failed! semaphore broken " + this, this.heartBeatFailure);
        }
    }

    private void createLockRowIfNotPresent(boolean strictReservations, int nrPermits) throws SQLException, InterruptedException {
        this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
            block42: {
                try (PreparedStatement stmt = conn.prepareStatement(this.permitsSql);){
                    stmt.setNString(1, this.semName);
                    stmt.setQueryTimeout(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos));
                    try (ResultSet rs = stmt.executeQuery();){
                        if (!rs.next()) {
                            try (PreparedStatement insert = conn.prepareStatement(this.insertLockRowSql);){
                                insert.setNString(1, this.semName);
                                insert.setInt(2, nrPermits);
                                insert.setInt(3, nrPermits);
                                insert.setNString(4, Runtime.PROCESS_ID);
                                insert.setQueryTimeout(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos));
                                insert.executeUpdate();
                                break block42;
                            }
                        }
                        if (strictReservations) {
                            int existingMaxReservations = rs.getInt(2);
                            if (existingMaxReservations != nrPermits) {
                                throw new IllegalArgumentException("Semaphore " + this.semName + " max reservations count different " + existingMaxReservations + " != " + nrPermits + " use different semaphore");
                            }
                            if (rs.next()) {
                                throw new IllegalStateException("Cannot have mutiple semaphores with the same name " + this.semName);
                            }
                        } else if (rs.next()) {
                            throw new IllegalStateException("Cannot have mutiple semaphores with the same name " + this.semName);
                        }
                    }
                }
            }
            return null;
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    private void createOwnerRow() throws SQLException, InterruptedException {
        this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
            try (PreparedStatement insert = conn.prepareStatement(this.insertPermitsByOwnerSql);){
                insert.setNString(1, this.semName);
                insert.setNString(2, Runtime.PROCESS_ID);
                insert.setInt(3, 0);
                insert.setQueryTimeout(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos));
                insert.executeUpdate();
            }
            return null;
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckReturnValue
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"})
    public boolean tryAcquire(final int nrPermits, long timeout, TimeUnit unit) throws InterruptedException {
        if (nrPermits < 1) {
            throw new IllegalArgumentException("You should try to acquire something! not " + nrPermits);
        }
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Illegal timeout, please reasonable values, and not: " + timeout);
        }
        Object object = this.syncObj;
        synchronized (object) {
            long deadlineNanos;
            long toNanos = unit.toNanos(timeout);
            if (toNanos < 0L) {
                deadlineNanos = Long.MAX_VALUE;
            } else {
                deadlineNanos = System.nanoTime() + toNanos;
                if (deadlineNanos < 0L) {
                    deadlineNanos = Long.MAX_VALUE;
                }
            }
            boolean acquired = false;
            final MutableHolder<Boolean> beat = MutableHolder.of(Boolean.FALSE);
            do {
                block21: {
                    this.validate();
                    try {
                        acquired = this.jdbc.transactOnConnection(new HandlerNano<Connection, Boolean, SQLException>(){

                            @Override
                            public Boolean handle(Connection conn, long deadlineNanos) throws SQLException {
                                try (PreparedStatement stmt = conn.prepareStatement(JdbcSemaphore.this.acquireSql);){
                                    Boolean acquired;
                                    stmt.setQueryTimeout(Math.min(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos), JdbcSemaphore.this.jdbcTimeoutSeconds));
                                    stmt.setInt(1, nrPermits);
                                    stmt.setNString(2, Runtime.PROCESS_ID);
                                    stmt.setNString(3, JdbcSemaphore.this.semName);
                                    stmt.setInt(4, nrPermits);
                                    int rowsUpdated = stmt.executeUpdate();
                                    if (rowsUpdated == 1) {
                                        try (PreparedStatement ostmt = conn.prepareStatement(JdbcSemaphore.this.acquireByOwnerSql);){
                                            ostmt.setInt(1, nrPermits);
                                            ostmt.setNString(2, Runtime.PROCESS_ID);
                                            ostmt.setNString(3, JdbcSemaphore.this.semName);
                                            ostmt.setQueryTimeout(Math.min(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos), JdbcSemaphore.this.jdbcTimeoutSeconds));
                                            int nrUpdated = ostmt.executeUpdate();
                                            if (nrUpdated != 1) {
                                                throw new IllegalStateException("Updated " + nrUpdated + " is incorrect for " + ostmt);
                                            }
                                        }
                                        acquired = Boolean.TRUE;
                                    } else {
                                        if (rowsUpdated > 1) {
                                            throw new IllegalStateException("Too many rows updated! when trying to acquire " + nrPermits);
                                        }
                                        acquired = Boolean.FALSE;
                                    }
                                    if (deadlineNanos - System.nanoTime() > JdbcSemaphore.this.heartBeat.getBeatDurationNanos()) {
                                        beat.setValue(JdbcSemaphore.this.heartBeat.tryBeat(conn, deadlineNanos));
                                    }
                                    Boolean bl = acquired;
                                    return bl;
                                }
                            }
                        }, timeout, unit);
                    }
                    catch (SQLException ex) {
                        throw new LockRuntimeException(ex);
                    }
                    if (beat.getValue().booleanValue()) {
                        this.heartBeat.updateLastRun(System.currentTimeMillis());
                    }
                    if (acquired) continue;
                    long secondsLeft = JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos);
                    if (secondsLeft < (long)CLEANUP_TIMEOUT_SECONDS) {
                        Future<Integer> fut = DefaultExecutor.INSTANCE.submit(new Callable<Integer>(){

                            @Override
                            public Integer call() throws Exception {
                                return JdbcSemaphore.this.removeDeadHeartBeatAndNotOwnerRows(CLEANUP_TIMEOUT_SECONDS);
                            }
                        });
                        try {
                            fut.get(secondsLeft, TimeUnit.SECONDS);
                            break block21;
                        }
                        catch (TimeoutException ex) {
                            break;
                        }
                        catch (ExecutionException ex) {
                            throw new LockRuntimeException(ex);
                        }
                    }
                    try {
                        this.removeDeadHeartBeatAndNotOwnerRows(secondsLeft);
                    }
                    catch (SQLException ex) {
                        throw new LockRuntimeException(ex);
                    }
                }
                try {
                    if (this.releaseDeadOwnerPermits(nrPermits) > 0) continue;
                    long wtimeMilis = Math.min(TimeUnit.NANOSECONDS.toMillis(deadlineNanos - System.nanoTime()), ThreadLocalRandom.current().nextLong(this.acquirePollMillis));
                    if (wtimeMilis <= 0L) break;
                    this.syncObj.wait(wtimeMilis);
                }
                catch (SQLException ex) {
                    throw new LockRuntimeException(ex);
                }
            } while (!acquired && deadlineNanos > System.nanoTime());
            if (acquired) {
                this.ownedReservations += nrPermits;
            }
            return acquired;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
    public void release(final int nrReservations) {
        Object object = this.syncObj;
        synchronized (object) {
            try {
                this.jdbc.transactOnConnectionNonInterrupt(new HandlerNano<Connection, Void, SQLException>(){

                    @Override
                    public Void handle(Connection conn, long deadlineNanos) throws SQLException {
                        JdbcSemaphore.this.releaseReservations(conn, deadlineNanos, nrReservations);
                        try (PreparedStatement ostmt = conn.prepareStatement(JdbcSemaphore.this.releaseByOwnerSql);){
                            ostmt.setInt(1, nrReservations);
                            ostmt.setNString(2, Runtime.PROCESS_ID);
                            ostmt.setNString(3, JdbcSemaphore.this.semName);
                            ostmt.setInt(4, nrReservations);
                            ostmt.setQueryTimeout(Math.min(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos), JdbcSemaphore.this.jdbcTimeoutSeconds));
                            int nrUpdated = ostmt.executeUpdate();
                            if (nrUpdated != 1) {
                                throw new IllegalStateException("Trying to release more than you own! " + ostmt);
                            }
                        }
                        return null;
                    }
                }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
            }
            catch (SQLException ex) {
                throw new LockRuntimeException(ex);
            }
            this.ownedReservations -= nrReservations;
            if (this.ownedReservations < 0) {
                throw new IllegalStateException("Should not be trying to release more than you acquired!" + nrReservations);
            }
            this.syncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        Object object = this.syncObj;
        synchronized (object) {
            this.release(this.ownedReservations);
        }
    }

    private void releaseReservations(Connection conn, long deadlineNanos, int nrReservations) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(this.releaseSql);){
            stmt.setQueryTimeout(Math.min(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos), this.jdbcTimeoutSeconds));
            stmt.setInt(1, nrReservations);
            stmt.setInt(2, nrReservations);
            stmt.setNString(3, Runtime.PROCESS_ID);
            stmt.setNString(4, this.semName);
            stmt.executeUpdate();
        }
    }

    @JmxExport(description="Get the available semaphore permits")
    public int availablePermits() throws SQLException, InterruptedException {
        return this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    @JmxExport(description="get the number of permits owned by this process")
    public int permitsOwned() throws SQLException, InterruptedException {
        return this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    @JmxExport(description="Get the total permits this semaphore can hand out")
    public int totalPermits() throws SQLException, InterruptedException {
        return this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    @JmxExport(description="get a list of all dead owners which hold permits")
    public List<OwnerPermits> getDeadOwnerPermits(int wishPermits) throws SQLException, InterruptedException {
        return this.jdbc.transactOnConnection((conn, deadlineNanos) -> this.getDeadOwnerPermits((Connection)conn, deadlineNanos, wishPermits), this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    List<OwnerPermits> getDeadOwnerPermits(Connection conn, long deadlineNanos, int wishPermits) throws SQLException {
        ArrayList<OwnerPermits> result = new ArrayList<OwnerPermits>();
        try (PreparedStatement stmt = conn.prepareStatement(this.getDeadOwnerPermitsSql);){
            stmt.setNString(1, this.semName);
            stmt.setQueryTimeout(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos));
            try (ResultSet rs = stmt.executeQuery();){
                int nrPermits = 0;
                while (rs.next()) {
                    OwnerPermits ownerPermit = new OwnerPermits(rs.getNString(1), rs.getInt(2));
                    result.add(ownerPermit);
                    if ((nrPermits += ownerPermit.getNrPermits()) < wishPermits) continue;
                    break;
                }
            }
        }
        return result;
    }

    @JmxExport(description="release dead owner permits")
    @CheckReturnValue
    public int releaseDeadOwnerPermits(@JmxExport(value="wishPermits", description="how many we whish to release") int wishPermits) throws InterruptedException, SQLException {
        return this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
            List<OwnerPermits> deadOwnerPermits = this.getDeadOwnerPermits((Connection)conn, deadlineNanos, wishPermits);
            int released = 0;
            for (OwnerPermits permit : deadOwnerPermits) {
                PreparedStatement stmt = conn.prepareStatement(this.deleteDeadOwerRecordSql);
                Throwable throwable = null;
                try {
                    String owner = permit.getOwner();
                    stmt.setNString(1, owner);
                    stmt.setNString(2, this.semName);
                    int nrPermits = permit.getNrPermits();
                    stmt.setInt(3, nrPermits);
                    stmt.setQueryTimeout(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos));
                    if (stmt.executeUpdate() != 1) continue;
                    released += nrPermits;
                    this.releaseReservations((Connection)conn, deadlineNanos, nrPermits);
                    LOG.warn("Released {} reservations from dead owner {}", (Object)nrPermits, (Object)owner);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stmt == null) continue;
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stmt.close();
                }
            }
            return released;
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    @JmxExport(description="Change the total available permits to the provided number")
    public void updatePermits(final int nrPermits) throws SQLException, InterruptedException {
        if (nrPermits < 0) {
            throw new IllegalArgumentException("Permits must be positive and not " + nrPermits);
        }
        this.jdbc.transactOnConnection(new HandlerNano<Connection, Void, SQLException>(){

            @Override
            public Void handle(Connection conn, long deadlineNanos) throws SQLException {
                try (PreparedStatement stmt = conn.prepareStatement(JdbcSemaphore.this.updatePermitsSql);){
                    stmt.setQueryTimeout(Math.min(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos), JdbcSemaphore.this.jdbcTimeoutSeconds));
                    stmt.setInt(1, nrPermits);
                    stmt.setInt(2, nrPermits);
                    stmt.setNString(3, Runtime.PROCESS_ID);
                    stmt.setNString(4, JdbcSemaphore.this.semName);
                    int rowsUpdated = stmt.executeUpdate();
                    if (rowsUpdated != 1) {
                        throw new IllegalArgumentException("Cannot reduce nr total permits by " + nrPermits);
                    }
                }
                return null;
            }
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    @JmxExport(description="Reduce the total available permits by the provided number")
    public void reducePermits(final int nrPermits) throws SQLException, InterruptedException {
        this.jdbc.transactOnConnection(new HandlerNano<Connection, Void, SQLException>(){

            @Override
            public Void handle(Connection conn, long deadlineNanos) throws SQLException {
                try (PreparedStatement stmt = conn.prepareStatement(JdbcSemaphore.this.reducePermitsSql);){
                    stmt.setQueryTimeout(Math.min(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos), JdbcSemaphore.this.jdbcTimeoutSeconds));
                    stmt.setInt(1, nrPermits);
                    stmt.setInt(2, nrPermits);
                    stmt.setNString(3, Runtime.PROCESS_ID);
                    stmt.setNString(4, JdbcSemaphore.this.semName);
                    stmt.setInt(5, nrPermits);
                    int rowsUpdated = stmt.executeUpdate();
                    if (rowsUpdated != 1) {
                        throw new IllegalArgumentException("Cannot reduce nr total permits by " + nrPermits);
                    }
                }
                return null;
            }
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    @JmxExport(description="Increase the total available permits by the provided number")
    public void increasePermits(final int nrPermits) throws SQLException, InterruptedException {
        this.jdbc.transactOnConnection(new HandlerNano<Connection, Void, SQLException>(){

            @Override
            public Void handle(Connection conn, long deadlineNanos) throws SQLException {
                try (PreparedStatement stmt = conn.prepareStatement(JdbcSemaphore.this.increasePermitsSql);){
                    stmt.setQueryTimeout(Math.min(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos), JdbcSemaphore.this.jdbcTimeoutSeconds));
                    stmt.setInt(1, nrPermits);
                    stmt.setInt(2, nrPermits);
                    stmt.setNString(3, Runtime.PROCESS_ID);
                    stmt.setNString(4, JdbcSemaphore.this.semName);
                    int rowsUpdated = stmt.executeUpdate();
                    if (rowsUpdated != 1) {
                        throw new IllegalArgumentException("Cannot reduce nr total permits by " + nrPermits);
                    }
                }
                return null;
            }
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    public int removeDeadHeartBeatAndNotOwnerRows(long timeoutSeconds) throws SQLException, InterruptedException {
        return this.jdbc.transactOnConnection(new HandlerNano<Connection, Integer, SQLException>(){

            @Override
            public Integer handle(Connection conn, long deadlineNanos) throws SQLException {
                return JdbcSemaphore.this.removeDeadHeartBeatAndNotOwnerRows(conn, deadlineNanos);
            }
        }, timeoutSeconds, TimeUnit.SECONDS);
    }

    private int removeDeadHeartBeatAndNotOwnerRows(Connection conn, long deadlineNanos) throws SQLException {
        int removedDeadHeartBeatRows = this.heartBeat.removeDeadHeartBeatRows(conn, deadlineNanos);
        if (removedDeadHeartBeatRows > 0) {
            return this.removeDeadNotOwnedRowsOnly(conn, deadlineNanos);
        }
        return 0;
    }

    private int removeDeadNotOwnedRowsOnly(Connection conn, long deadlineNanos) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(this.deleteDeadOwnerRecordsSql);){
            stmt.setNString(1, this.semName);
            stmt.setQueryTimeout(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos));
            int n = stmt.executeUpdate();
            return n;
        }
    }

    public String toString() {
        return "JdbcSemaphore{jdbc=" + this.jdbc + ", jdbcTimeoutSeconds=" + this.jdbcTimeoutSeconds + ", semName=" + this.semName + '}';
    }

    @Override
    public void close() {
        this.releaseAll();
        this.unregisterJmx();
        this.heartBeat.removeLifecycleHook(this.failureHook);
        this.isHealthy = false;
    }

    @JmxExport
    public int getJdbcTimeoutSeconds() {
        return this.jdbcTimeoutSeconds;
    }

    @JmxExport
    public boolean isIsHealthy() {
        return this.isHealthy;
    }
}

