/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent.jdbc;

import java.util.concurrent.TimeUnit;
import org.spf4j.concurrent.Semaphore;
import org.spf4j.concurrent.jdbc.JdbcSemaphore;

public final class ProcessLimitedJdbcSemaphore
implements Semaphore {
    private final JdbcSemaphore jdbcSemaphore;
    private final java.util.concurrent.Semaphore semaphore;

    public ProcessLimitedJdbcSemaphore(JdbcSemaphore jdbcSemaphore, int maxProcessPermits) {
        this.jdbcSemaphore = jdbcSemaphore;
        this.semaphore = new java.util.concurrent.Semaphore(maxProcessPermits);
    }

    @Override
    public void release(int nrReservations) {
        this.jdbcSemaphore.release(nrReservations);
        this.semaphore.release(nrReservations);
    }

    @Override
    public boolean tryAcquire(int nrPermits, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.semaphore.tryAcquire(nrPermits, timeout, unit)) {
            try {
                return this.jdbcSemaphore.tryAcquire(nrPermits, timeout, unit);
            }
            catch (InterruptedException | RuntimeException e) {
                this.semaphore.release();
                throw e;
            }
        }
        return false;
    }

    public String toString() {
        return "ProcessLimitedJdbcSemaphore{jdbcSemaphore=" + this.jdbcSemaphore + ", semaphore=" + this.semaphore + '}';
    }
}

