/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent.jdbc;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.concurrent.jdbc.HeartBeatTableDesc;
import org.spf4j.jdbc.DbType;
import org.spf4j.jdbc.JdbcTemplate;

@ParametersAreNonnullByDefault
public final class SemaphoreTablesDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final SemaphoreTablesDesc DEFAULT = new SemaphoreTablesDesc(System.getProperty("spf4j.jdbc.semaphore.sql.tableName", "SEMAPHORES"), System.getProperty("spf4j.jdbc.semaphore.sql.semaphoreNameColumn", "SEMAPHORE_NAME"), System.getProperty("spf4j.jdbc.semaphore.sql.availablePermitsColumn", "AVAILABLE_PERMITS"), System.getProperty("spf4j.jdbc.semaphore.sql.totalPermitsColumn", "TOTAL_PERMITS"), System.getProperty("spf4j.jdbc.semaphore.sql.lastUpdatedByColumn", "LAST_UPDATED_BY"), System.getProperty("spf4j.jdbc.semaphore.sql.lastUpdatedAtColumn", "LAST_UPDATED_AT"), System.getProperty("spf4j.jdbc.semaphore.sql.permitsByOwnerColumn", "PERMITS_BY_OWNER"), HeartBeatTableDesc.DEFAULT.getOwnerColumn(), System.getProperty("spf4j.jdbc.semaphore.sql.permitsColumn", "PERMITS"), HeartBeatTableDesc.DEFAULT);
    @Nonnull
    private final String semaphoreTableName;
    private final String semNameColumn;
    private final String availablePermitsColumn;
    private final String totalPermitsColumn;
    private final String lastModifiedByColumn;
    private final String lastModifiedAtColumn;
    private final String permitsByOwnerTableName;
    private final String ownerColumn;
    private final String ownerPermitsColumn;
    private final HeartBeatTableDesc heartBeatTableDesc;

    public SemaphoreTablesDesc(String semaphoreTableName, String semNameColumn, String availablePermitsColumn, String totalPermitsColumn, String lastModifiedByColumn, String lastModifiedAtColumn, String permitsByOwnerTableName, String ownerColumn, String ownerPermitsColumn, HeartBeatTableDesc heartBeatTableDesc) {
        JdbcTemplate.checkJdbcObjectName(semaphoreTableName);
        JdbcTemplate.checkJdbcObjectName(semNameColumn);
        JdbcTemplate.checkJdbcObjectName(availablePermitsColumn);
        JdbcTemplate.checkJdbcObjectName(totalPermitsColumn);
        JdbcTemplate.checkJdbcObjectName(lastModifiedByColumn);
        JdbcTemplate.checkJdbcObjectName(lastModifiedAtColumn);
        JdbcTemplate.checkJdbcObjectName(permitsByOwnerTableName);
        JdbcTemplate.checkJdbcObjectName(ownerColumn);
        JdbcTemplate.checkJdbcObjectName(ownerPermitsColumn);
        this.semaphoreTableName = semaphoreTableName;
        this.semNameColumn = semNameColumn;
        this.availablePermitsColumn = availablePermitsColumn;
        this.totalPermitsColumn = totalPermitsColumn;
        this.lastModifiedByColumn = lastModifiedByColumn;
        this.lastModifiedAtColumn = lastModifiedAtColumn;
        this.permitsByOwnerTableName = permitsByOwnerTableName;
        this.ownerColumn = ownerColumn;
        this.ownerPermitsColumn = ownerPermitsColumn;
        this.heartBeatTableDesc = heartBeatTableDesc;
    }

    public String getSemaphoreTableName() {
        return this.semaphoreTableName;
    }

    public String getSemNameColumn() {
        return this.semNameColumn;
    }

    public String getAvailablePermitsColumn() {
        return this.availablePermitsColumn;
    }

    public String getTotalPermitsColumn() {
        return this.totalPermitsColumn;
    }

    public String getLastModifiedByColumn() {
        return this.lastModifiedByColumn;
    }

    public String getLastModifiedAtColumn() {
        return this.lastModifiedAtColumn;
    }

    public String getPermitsByOwnerTableName() {
        return this.permitsByOwnerTableName;
    }

    public String getOwnerColumn() {
        return this.ownerColumn;
    }

    public String getOwnerPermitsColumn() {
        return this.ownerPermitsColumn;
    }

    public HeartBeatTableDesc getHeartBeatTableDesc() {
        return this.heartBeatTableDesc;
    }

    public SemaphoreTablesDesc withDbType(DbType dbType) {
        return new SemaphoreTablesDesc(this.semaphoreTableName, this.semNameColumn, this.availablePermitsColumn, this.totalPermitsColumn, this.lastModifiedByColumn, this.lastModifiedAtColumn, this.permitsByOwnerTableName, this.ownerColumn, this.ownerPermitsColumn, this.heartBeatTableDesc.withDbType(dbType));
    }

    public int hashCode() {
        return this.semaphoreTableName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SemaphoreTablesDesc other = (SemaphoreTablesDesc)obj;
        if (!Objects.equals(this.semaphoreTableName, other.semaphoreTableName)) {
            return false;
        }
        if (!Objects.equals(this.semNameColumn, other.semNameColumn)) {
            return false;
        }
        if (!Objects.equals(this.availablePermitsColumn, other.availablePermitsColumn)) {
            return false;
        }
        if (!Objects.equals(this.totalPermitsColumn, other.totalPermitsColumn)) {
            return false;
        }
        if (!Objects.equals(this.lastModifiedByColumn, other.lastModifiedByColumn)) {
            return false;
        }
        if (!Objects.equals(this.lastModifiedAtColumn, other.lastModifiedAtColumn)) {
            return false;
        }
        if (!Objects.equals(this.permitsByOwnerTableName, other.permitsByOwnerTableName)) {
            return false;
        }
        if (!Objects.equals(this.ownerColumn, other.ownerColumn)) {
            return false;
        }
        if (!Objects.equals(this.ownerPermitsColumn, other.ownerPermitsColumn)) {
            return false;
        }
        return Objects.equals(this.heartBeatTableDesc, other.heartBeatTableDesc);
    }

    public String toString() {
        return "SemaphoreTablesDesc{semaphoreTableName=" + this.semaphoreTableName + ", semNameColumn=" + this.semNameColumn + ", availablePermitsColumn=" + this.availablePermitsColumn + ", totalPermitsColumn=" + this.totalPermitsColumn + ", lastModifiedByColumn=" + this.lastModifiedByColumn + ", lastModifiedAtColumn=" + this.lastModifiedAtColumn + ", permitsByOwnerTableName=" + this.permitsByOwnerTableName + ", ownerColumn=" + this.ownerColumn + ", ownerReservationsColumn=" + this.ownerPermitsColumn + '}';
    }
}

