/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ds;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;

@SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX", "BC_UNCONFIRMED_CAST_OF_RETURN_VALUE", "PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "PREDICTABLE_RANDOM", "IMC_IMMATURE_CLASS_WRONG_FIELD_ORDER"})
public final class RTree<T> {
    private static final float DIM_FACTOR = -2.0f;
    private static final float FUDGE_FACTOR = 1.001f;
    private static final float INIT_COORD = (float)Math.sqrt(3.4028234663852886E38);
    private final int maxEntries;
    private final int minEntries;
    private final int numDims;
    private final float[] pointDims;
    private final SeedPicker seedPicker;
    private Node root;
    private int size;
    private static final int ELEM_WIDTH = 150;
    private static final int ELEM_HEIGHT = 120;

    public RTree(int maxEntries, int minEntries, int numDims, SeedPicker seedPicker) {
        assert (minEntries <= maxEntries / 2);
        this.numDims = numDims;
        this.maxEntries = maxEntries;
        this.minEntries = minEntries;
        this.seedPicker = seedPicker;
        this.pointDims = new float[numDims];
        this.root = this.buildRoot(true);
    }

    public RTree(int maxEntries, int minEntries, int numDims) {
        this(maxEntries, minEntries, numDims, SeedPicker.LINEAR);
    }

    private Node buildRoot(boolean asLeaf) {
        float[] initCoords = new float[this.numDims];
        float[] initDimensions = new float[this.numDims];
        for (int i = 0; i < this.numDims; ++i) {
            initCoords[i] = INIT_COORD;
            initDimensions[i] = -2.0f * INIT_COORD;
        }
        return new Node(initCoords, initDimensions, asLeaf);
    }

    public RTree() {
        this(50, 2, 2, SeedPicker.LINEAR);
    }

    public RTree(int numDimensions) {
        this(50, 2, numDimensions, SeedPicker.LINEAR);
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public int getMinEntries() {
        return this.minEntries;
    }

    public int getNumDims() {
        return this.numDims;
    }

    public int size() {
        return this.size;
    }

    @Nonnull
    public List<T> search(float[] coords, float[] dimensions) {
        assert (coords.length == this.numDims);
        assert (dimensions.length == this.numDims);
        LinkedList results = new LinkedList();
        this.search(coords, dimensions, this.root, results);
        return results;
    }

    private void search(float[] coords, float[] dimensions, Node n, LinkedList<T> results) {
        if (n.leaf) {
            for (Node e : n.children) {
                if (!this.isOverlap(coords, dimensions, e.coords, e.dimensions)) continue;
                results.add(((Entry)e).entry);
            }
        } else {
            for (Node c : n.children) {
                if (!this.isOverlap(coords, dimensions, c.coords, c.dimensions)) continue;
                this.search(coords, dimensions, c, results);
            }
        }
    }

    public boolean delete(float[] coords, float[] dimensions, T entry) {
        assert (coords.length == this.numDims);
        assert (dimensions.length == this.numDims);
        Node l = this.findLeaf(this.root, coords, dimensions, entry);
        if (l == null) {
            throw new IllegalArgumentException("leaf not found for entry " + entry);
        }
        ListIterator li = l.children.listIterator();
        Object removed = null;
        while (li.hasNext()) {
            Entry e = (Entry)li.next();
            if (!e.entry.equals(entry)) continue;
            removed = e.entry;
            li.remove();
            break;
        }
        if (removed != null) {
            this.condenseTree(l);
            --this.size;
        }
        if (this.size == 0) {
            this.root = this.buildRoot(true);
        }
        return removed != null;
    }

    public boolean delete(float[] coords, T entry) {
        return this.delete(coords, this.pointDims, entry);
    }

    private Node findLeaf(Node n, float[] coords, float[] dimensions, T entry) {
        if (n.leaf) {
            for (Node c : n.children) {
                if (!((Entry)c).entry.equals(entry)) continue;
                return n;
            }
            return null;
        }
        for (Node c : n.children) {
            Node result;
            if (!this.isOverlap(c.coords, c.dimensions, coords, dimensions) || (result = this.findLeaf(c, coords, dimensions, entry)) == null) continue;
            return result;
        }
        return null;
    }

    private void condenseTree(Node pn) {
        Node n = pn;
        HashSet<Node> q = new HashSet<Node>();
        while (n != this.root) {
            if (n.leaf && n.children.size() < this.minEntries) {
                q.addAll(n.children);
                n.parent.children.remove(n);
            } else if (!n.leaf && n.children.size() < this.minEntries) {
                LinkedList<Node> toVisit = new LinkedList<Node>(n.children);
                while (!toVisit.isEmpty()) {
                    Node c = toVisit.pop();
                    if (c.leaf) {
                        q.addAll(c.children);
                        continue;
                    }
                    toVisit.addAll(c.children);
                }
                n.parent.children.remove(n);
            } else {
                this.tighten(n);
            }
            n = n.parent;
        }
        if (this.root.children.size() == 0) {
            this.root = this.buildRoot(true);
        } else if (!this.root.leaf && this.root.children.size() == 1) {
            this.root = this.root.children.get(0);
            this.root.parent = null;
        } else {
            this.tighten(this.root);
        }
        for (Node ne : q) {
            Entry e = (Entry)ne;
            this.insert(e.coords, e.dimensions, e.entry);
        }
        this.size -= q.size();
    }

    public void clear() {
        this.root = this.buildRoot(true);
    }

    public void insert(float[] coords, float[] dimensions, T entry) {
        assert (coords.length == this.numDims);
        assert (dimensions.length == this.numDims);
        Entry<T> e = new Entry<T>(coords, dimensions, entry);
        Node l = this.chooseLeaf(this.root, e);
        l.children.add(e);
        ++this.size;
        e.parent = l;
        if (l.children.size() > this.maxEntries) {
            Node[] splits = this.splitNode(l);
            this.adjustTree(splits[0], splits[1]);
        } else {
            this.adjustTree(l, null);
        }
    }

    public void insert(float[] coords, T entry) {
        this.insert(coords, this.pointDims, entry);
    }

    private void adjustTree(Node n, Node nn) {
        if (n == this.root) {
            if (nn != null) {
                this.root = this.buildRoot(false);
                this.root.children.add(n);
                n.parent = this.root;
                this.root.children.add(nn);
                nn.parent = this.root;
            }
            this.tighten(this.root);
            return;
        }
        this.tighten(n);
        if (nn != null) {
            this.tighten(nn);
            if (n.parent.children.size() > this.maxEntries) {
                Node[] splits = this.splitNode(n.parent);
                this.adjustTree(splits[0], splits[1]);
            }
        }
        if (n.parent != null) {
            this.adjustTree(n.parent, null);
        }
    }

    private Node[] splitNode(Node n) {
        Node[] nn = new Node[]{n, new Node(n.coords, n.dimensions, n.leaf)};
        Node nn1 = nn[1];
        nn1.parent = n.parent;
        if (nn1.parent != null) {
            nn1.parent.children.add(nn1);
        }
        LinkedList<Node> cc = new LinkedList<Node>(n.children);
        n.children.clear();
        Node[] ss = this.seedPicker == SeedPicker.LINEAR ? this.lPickSeeds(cc) : this.qPickSeeds(cc);
        Node nn0 = nn[0];
        nn0.children.add(ss[0]);
        nn1.children.add(ss[1]);
        this.tighten(nn);
        while (!cc.isEmpty()) {
            float a1;
            float a0;
            float e1;
            int size0 = nn0.children.size();
            int size1 = nn1.children.size();
            if (size0 >= this.minEntries && size1 + cc.size() == this.minEntries) {
                nn1.children.addAll(cc);
                cc.clear();
                this.tighten(nn);
                return nn;
            }
            if (size1 >= this.minEntries && size0 + cc.size() == this.minEntries) {
                nn0.children.addAll(cc);
                cc.clear();
                this.tighten(nn);
                return nn;
            }
            Node c = this.seedPicker == SeedPicker.LINEAR ? this.lPickNext(cc) : this.qPickNext(cc, nn);
            float e0 = this.getRequiredExpansion(nn0.coords, nn0.dimensions, c);
            Node preferred = e0 < (e1 = this.getRequiredExpansion(nn1.coords, nn1.dimensions, c)) ? nn0 : (e0 > e1 ? nn1 : ((a0 = this.getArea(nn0.dimensions)) < (a1 = this.getArea(nn1.dimensions)) ? nn0 : (e0 > a1 ? nn1 : (size0 < size1 ? nn0 : (size0 > size1 ? nn1 : nn[(int)Math.round(Math.random())])))));
            preferred.children.add(c);
            this.tighten(preferred);
        }
        return nn;
    }

    @SuppressFBWarnings(value={"MRC_METHOD_RETURNS_CONSTANT"})
    private Node[] qPickSeeds(List<Node> nn) {
        Node[] bestPair = new Node[2];
        float maxWaste = -3.4028235E38f;
        for (Node n1 : nn) {
            for (Node n2 : nn) {
                if (n1 == n2) continue;
                float n1a = this.getArea(n1.dimensions);
                float n2a = this.getArea(n2.dimensions);
                float ja = 1.0f;
                for (int i = 0; i < this.numDims; ++i) {
                    float n1coordsi = n1.coords[i];
                    float n2coordsi = n2.coords[i];
                    float jc0 = Math.min(n1coordsi, n2coordsi);
                    float jc1 = Math.max(n1coordsi + n1.dimensions[i], n2coordsi + n2.dimensions[i]);
                    ja *= jc1 - jc0;
                }
                float waste = ja - n1a - n2a;
                if (!(waste > maxWaste)) continue;
                maxWaste = waste;
                bestPair[0] = n1;
                bestPair[1] = n2;
            }
        }
        nn.remove(bestPair[0]);
        nn.remove(bestPair[1]);
        return bestPair;
    }

    private Node qPickNext(LinkedList<Node> cc, Node[] nn) {
        float maxDiff = -3.4028235E38f;
        Node nextC = null;
        for (Node c : cc) {
            float n0Exp = this.getRequiredExpansion(nn[0].coords, nn[0].dimensions, c);
            float n1Exp = this.getRequiredExpansion(nn[1].coords, nn[1].dimensions, c);
            float diff = Math.abs(n1Exp - n0Exp);
            if (!(diff > maxDiff)) continue;
            maxDiff = diff;
            nextC = c;
        }
        assert (nextC != null) : "No node selected from qPickNext";
        cc.remove(nextC);
        return nextC;
    }

    private Node[] lPickSeeds(LinkedList<Node> nn) {
        Node[] bestPair = new Node[2];
        boolean foundBestPair = false;
        float bestSep = 0.0f;
        for (int i = 0; i < this.numDims; ++i) {
            float sep;
            float dimLb = Float.MAX_VALUE;
            float dimMinUb = Float.MAX_VALUE;
            float dimUb = -3.4028235E38f;
            float dimMaxLb = -3.4028235E38f;
            Node nMaxLb = null;
            Node nMinUb = null;
            for (Node n : nn) {
                if (n.coords[i] < dimLb) {
                    dimLb = n.coords[i];
                }
                if (n.dimensions[i] + n.coords[i] > dimUb) {
                    dimUb = n.dimensions[i] + n.coords[i];
                }
                if (n.coords[i] > dimMaxLb) {
                    dimMaxLb = n.coords[i];
                    nMaxLb = n;
                }
                if (!(n.dimensions[i] + n.coords[i] < dimMinUb)) continue;
                dimMinUb = n.dimensions[i] + n.coords[i];
                nMinUb = n;
            }
            float f = sep = nMaxLb == nMinUb ? -1.0f : Math.abs((dimMinUb - dimMaxLb) / (dimUb - dimLb));
            if (!(sep >= bestSep)) continue;
            bestPair[0] = nMaxLb;
            bestPair[1] = nMinUb;
            bestSep = sep;
            foundBestPair = true;
        }
        if (!foundBestPair) {
            bestPair = new Node[]{nn.get(0), nn.get(1)};
        }
        nn.remove(bestPair[0]);
        nn.remove(bestPair[1]);
        return bestPair;
    }

    private Node lPickNext(Deque<Node> cc) {
        return cc.pop();
    }

    private void tighten(Node ... nodes) {
        assert (nodes.length >= 1) : "Pass some nodes to tighten!";
        for (Node n : nodes) {
            int i;
            assert (n.children.size() > 0) : "tighten() called on empty node!";
            float[] minCoords = new float[this.numDims];
            float[] maxCoords = new float[this.numDims];
            for (i = 0; i < this.numDims; ++i) {
                minCoords[i] = Float.MAX_VALUE;
                maxCoords[i] = Float.MIN_VALUE;
                for (Node c : n.children) {
                    c.parent = n;
                    if (c.coords[i] < minCoords[i]) {
                        minCoords[i] = c.coords[i];
                    }
                    if (!(c.coords[i] + c.dimensions[i] > maxCoords[i])) continue;
                    maxCoords[i] = c.coords[i] + c.dimensions[i];
                }
            }
            for (i = 0; i < this.numDims; ++i) {
                int n2 = i;
                maxCoords[n2] = maxCoords[n2] - minCoords[i];
            }
            System.arraycopy(minCoords, 0, n.coords, 0, this.numDims);
            System.arraycopy(maxCoords, 0, n.dimensions, 0, this.numDims);
        }
    }

    private Node chooseLeaf(Node n, Entry<T> e) {
        if (n.leaf) {
            return n;
        }
        float minInc = Float.MAX_VALUE;
        Node next = null;
        for (Node c : n.children) {
            float inc = this.getRequiredExpansion(c.coords, c.dimensions, e);
            if (inc < minInc) {
                minInc = inc;
                next = c;
                continue;
            }
            if (inc != minInc) continue;
            float curArea = 1.0f;
            float thisArea = 1.0f;
            for (int i = 0; i < c.dimensions.length; ++i) {
                if (next == null) {
                    throw new IllegalStateException("Illegal state at " + c);
                }
                curArea *= next.dimensions[i];
                thisArea *= c.dimensions[i];
            }
            if (!(thisArea < curArea)) continue;
            next = c;
        }
        return this.chooseLeaf(next, e);
    }

    private float getRequiredExpansion(float[] coords, float[] dimensions, Node e) {
        float area = this.getArea(dimensions);
        float[] deltas = new float[dimensions.length];
        for (int i = 0; i < deltas.length; ++i) {
            if (coords[i] + dimensions[i] < e.coords[i] + e.dimensions[i]) {
                deltas[i] = e.coords[i] + e.dimensions[i] - coords[i] - dimensions[i];
                continue;
            }
            if (!(coords[i] + dimensions[i] > e.coords[i] + e.dimensions[i])) continue;
            deltas[i] = coords[i] - e.coords[i];
        }
        float expanded = 1.0f;
        for (int i = 0; i < dimensions.length; ++i) {
            area *= dimensions[i] + deltas[i];
        }
        return expanded - area;
    }

    private float getArea(float[] dimensions) {
        float area = 1.0f;
        for (int i = 0; i < dimensions.length; ++i) {
            area *= dimensions[i];
        }
        return area;
    }

    private boolean isOverlap(float[] scoords, float[] sdimensions, float[] coords, float[] dimensions) {
        for (int i = 0; i < scoords.length; ++i) {
            boolean overlapInThisDimension = false;
            if (scoords[i] == coords[i]) {
                overlapInThisDimension = true;
            } else if (scoords[i] < coords[i]) {
                if (scoords[i] + 1.001f * sdimensions[i] >= coords[i]) {
                    overlapInThisDimension = true;
                }
            } else if (scoords[i] > coords[i] && coords[i] + 1.001f * dimensions[i] >= scoords[i]) {
                overlapInThisDimension = true;
            }
            if (overlapInThisDimension) continue;
            return false;
        }
        return true;
    }

    public String visualize() {
        int ubDepth = (int)Math.ceil(Math.log(this.size) / Math.log(this.minEntries)) * 120;
        int ubWidth = this.size * 150;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<html><head></head><body>");
        this.visualize(this.root, pw, 0, 0, ubWidth, ubDepth);
        pw.println("</body>");
        pw.flush();
        return sw.toString();
    }

    private void visualize(Node n, PrintWriter pw, int x0, int y0, int w, int h) {
        pw.printf("<div style=\"position:absolute; left: %d; top: %d; width: %d; height: %d; border: 1px dashed\">%n", x0, y0, w, h);
        pw.println("<pre>");
        pw.println("Node: " + n + " (root==" + (n == this.root) + ") \n");
        pw.println("Coords: " + Arrays.toString(n.coords) + '\n');
        pw.println("Dimensions: " + Arrays.toString(n.dimensions) + '\n');
        pw.println("# Children: " + (n.children == null ? 0 : n.children.size()) + '\n');
        pw.println("isLeaf: " + n.leaf + '\n');
        pw.println("</pre>");
        int numChildren = n.children == null ? 0 : n.children.size();
        for (int i = 0; i < numChildren; ++i) {
            this.visualize(n.children.get(i), pw, (int)((float)x0 + (float)(i * w) / (float)numChildren), y0 + 120, (int)((float)w / (float)numChildren), h - 120);
        }
        pw.println("</div>");
    }

    public String toString() {
        return "RTree{maxEntries=" + this.maxEntries + ", minEntries=" + this.minEntries + ", numDims=" + this.numDims + ", pointDims=" + Arrays.toString(this.pointDims) + ", seedPicker=" + (Object)((Object)this.seedPicker) + ", root=" + this.root + ", size=" + this.size + '}';
    }

    private static class Entry<T>
    extends Node {
        public final T entry;

        public Entry(float[] coords, float[] dimensions, T entry) {
            super(coords, dimensions, true);
            this.entry = entry;
        }

        @Override
        public String toString() {
            return "Entry: " + this.entry;
        }
    }

    private static class Node {
        final float[] coords;
        final float[] dimensions;
        final LinkedList<Node> children;
        final boolean leaf;
        Node parent;

        private Node(float[] coords, float[] dimensions, boolean leaf) {
            this.coords = new float[coords.length];
            this.dimensions = new float[dimensions.length];
            System.arraycopy(coords, 0, this.coords, 0, coords.length);
            System.arraycopy(dimensions, 0, this.dimensions, 0, dimensions.length);
            this.leaf = leaf;
            this.children = new LinkedList();
        }

        public String toString() {
            return "Node{coords=" + Arrays.toString(this.coords) + ", dimensions=" + Arrays.toString(this.dimensions) + ", children=" + this.children + ", leaf=" + this.leaf + ", parent=" + this.parent + '}';
        }
    }

    public static enum SeedPicker {
        LINEAR,
        QUADRATIC;

    }
}

