/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ds;

import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import org.spf4j.ds.Graph;
import org.spf4j.ds.VertexEdges;

public final class Traversals {
    private Traversals() {
    }

    public static <V, E> void traverse(Graph<V, E> graph, V startNode, TraversalCallback<V, E> handler, boolean isBreadth) {
        HashSet traversedNodes = new HashSet(graph.getVertices().size());
        ArrayDeque<Object> traversalQueue = new ArrayDeque<Object>();
        traversalQueue.add(startNode);
        boolean done = false;
        block0: do {
            boolean first = true;
            while (!traversalQueue.isEmpty()) {
                Object node = isBreadth ? traversalQueue.removeFirst() : traversalQueue.removeLast();
                VertexEdges<V, E> edges = graph.getEdges(node);
                if (traversedNodes.contains(node)) continue;
                Map<E, V> incomming = edges.getIncomming();
                boolean hasIncomingBeenTraversed = true;
                for (V val : incomming.values()) {
                    if (traversedNodes.contains(val)) continue;
                    hasIncomingBeenTraversed = false;
                    break;
                }
                if (!first && !hasIncomingBeenTraversed) continue;
                handler.handle(node, incomming);
                traversedNodes.add(node);
                first = false;
                Map<E, V> outgoing = edges.getOutgoing();
                for (V next : outgoing.values()) {
                    traversalQueue.add(next);
                }
            }
            Sets.SetView leftNodes = Sets.difference(graph.getVertices(), traversedNodes);
            if (leftNodes.isEmpty()) {
                done = true;
                continue;
            }
            boolean added = false;
            for (Object node : leftNodes) {
                Collection<V> incomingNodes = graph.getEdges(node).getIncomming().values();
                for (V incoming : incomingNodes) {
                    if (!traversedNodes.contains(incoming)) continue;
                    traversalQueue.add(node);
                    added = true;
                    break;
                }
                if (!added) continue;
                continue block0;
            }
        } while (!done);
    }

    public static <V, E> void customTraverse(Graph<V, E> graph, V startNode, TraversalCallback<V, E> handler) {
        HashSet traversedNodes = new HashSet(graph.getVertices().size());
        PriorityQueue<VertexHolder<V>> traversalQueue = new PriorityQueue<VertexHolder<V>>(16);
        int counter = 0;
        traversalQueue.add(new VertexHolder<V>(startNode, counter++, 0));
        boolean done = false;
        do {
            boolean first = true;
            while (!traversalQueue.isEmpty()) {
                Object node = ((VertexHolder)traversalQueue.remove()).getVertex();
                VertexEdges<V, E> edges = graph.getEdges(node);
                if (traversedNodes.contains(node)) continue;
                Map<E, V> incomming = edges.getIncomming();
                boolean hasIncomingBeenTraversed = true;
                for (V val : incomming.values()) {
                    if (traversedNodes.contains(val)) continue;
                    hasIncomingBeenTraversed = false;
                    break;
                }
                if (!first && !hasIncomingBeenTraversed) continue;
                handler.handle(node, incomming);
                traversedNodes.add(node);
                first = false;
                Map<E, V> outgoing = edges.getOutgoing();
                for (V next : outgoing.values()) {
                    traversalQueue.add(new VertexHolder<V>(next, counter++, graph.getEdges(next).getIncomming().size()));
                }
            }
            Sets.SetView leftNodes = Sets.difference(graph.getVertices(), traversedNodes);
            if (leftNodes.isEmpty()) {
                done = true;
                continue;
            }
            boolean added = false;
            for (Object node : leftNodes) {
                Collection<V> incomingNodes = graph.getEdges(node).getIncomming().values();
                for (V incoming : incomingNodes) {
                    if (!traversedNodes.contains(incoming)) continue;
                    traversalQueue.add(new VertexHolder(node, counter++, 0));
                    added = true;
                    break;
                }
                if (!added) continue;
                break;
            }
            if (!added) break;
        } while (!done);
    }

    public static final class VertexHolder<V>
    implements Comparable<VertexHolder<V>> {
        private final V vertex;
        private final int order;
        private final int nrImcoming;

        public VertexHolder(V vertex, int order, int nrImcoming) {
            this.vertex = vertex;
            this.order = order;
            this.nrImcoming = nrImcoming;
        }

        @Override
        public int compareTo(VertexHolder<V> o) {
            int result = this.nrImcoming - o.nrImcoming;
            if (result == 0) {
                return this.order - o.order;
            }
            return result;
        }

        public V getVertex() {
            return this.vertex;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.vertex != null ? this.vertex.hashCode() : 0);
            hash = 29 * hash + this.order;
            return 29 * hash + this.nrImcoming;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VertexHolder other = (VertexHolder)obj;
            return this.compareTo(other) == 0;
        }
    }

    public static interface TraversalCallback<V, E> {
        public void handle(V var1, Map<E, V> var2);
    }
}

