/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ds;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SuppressFBWarnings(value={"DESERIALIZATION_GADGET"})
public final class UpdateablePriorityQueue<E>
implements Iterable<E>,
Serializable {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final long serialVersionUID = 1L;
    private transient ElementRef[] queue;
    private int size = 0;
    private final Comparator<? super E> comparator;
    private transient int modCount = 0;

    public UpdateablePriorityQueue() {
        this(16, null);
    }

    public UpdateablePriorityQueue(int initialCapacity) {
        this(initialCapacity, null);
    }

    public UpdateablePriorityQueue(int initialCapacity, Comparator<? super E> comparator) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Invalid initial capacity " + initialCapacity);
        }
        this.queue = (ElementRef[])Array.newInstance(ElementRef.class, initialCapacity);
        this.comparator = comparator == null ? Comparator.naturalOrder() : comparator;
    }

    private void grow(int minCapacity) {
        int newCapacity;
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        int oldCapacity = this.queue.length;
        int n = newCapacity = oldCapacity < 64 ? (oldCapacity + 1) * 2 : oldCapacity / 2 * 3;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        }
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.queue = Arrays.copyOf(this.queue, newCapacity);
    }

    public ElementRef add(@Nonnull E e) {
        ++this.modCount;
        int i = this.size;
        if (i >= this.queue.length) {
            this.grow(i + 1);
        }
        this.size = i + 1;
        ElementRef qe = new ElementRef(e, 0);
        if (i == 0) {
            this.queue[0] = qe;
        } else {
            this.siftUp(i, qe);
        }
        return qe;
    }

    @Nullable
    public E peek() {
        if (this.size == 0) {
            return null;
        }
        return (E)this.queue[0].elem;
    }

    @Nullable
    public ElementRef peekEntry() {
        if (this.size == 0) {
            return null;
        }
        return this.queue[0];
    }

    private int indexOf(E o) {
        if (o != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.queue[i].elem)) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean remove(ElementRef qe) {
        int i = qe.index;
        if (i == -1) {
            return false;
        }
        this.removeAt(i);
        return true;
    }

    public boolean remove(E o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.removeAt(i);
        return true;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private boolean removeEq(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (o != this.queue[i]) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public boolean contains(E o) {
        return this.indexOf(o) != -1;
    }

    public Object[] toArray() {
        return Arrays.copyOf(this.queue, this.size);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.queue, this.size, a.getClass());
        }
        System.arraycopy(this.queue, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            ElementRef ref = this.queue[i];
            ref.index = -1;
            this.queue[i] = null;
        }
        this.size = 0;
    }

    @Nullable
    @SuppressFBWarnings(value={"BAS_BLOATED_ASSIGNMENT_SCOPE"})
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        int s = --this.size;
        ++this.modCount;
        ElementRef removedRef = this.queue[0];
        removedRef.index = -1;
        Object result = removedRef.elem;
        ElementRef x = this.queue[s];
        this.queue[s] = null;
        if (s != 0) {
            this.siftDown(0, x);
        }
        return (E)result;
    }

    private E removeAt(int i) {
        assert (i >= 0 && i < this.size);
        ++this.modCount;
        this.queue[i].index = -1;
        int s = --this.size;
        if (s == i) {
            this.queue[i] = null;
        } else {
            ElementRef moved = this.queue[s];
            this.queue[s] = null;
            this.siftDown(i, moved);
            if (this.queue[i] == moved) {
                this.siftUp(i, moved);
                if (this.queue[i] != moved) {
                    return (E)moved.elem;
                }
            }
        }
        return null;
    }

    private void siftUp(int pk, ElementRef x) {
        int parent;
        ElementRef e;
        int k = pk;
        while (k > 0 && x.compareTo(e = this.queue[parent = k - 1 >>> 1]) < 0) {
            this.queue[k] = e;
            e.index = k;
            k = parent;
        }
        this.queue[k] = x;
        x.index = k;
    }

    private void siftDown(int pk, ElementRef x) {
        int k = pk;
        int half = this.size >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            ElementRef c = this.queue[child];
            int right = child + 1;
            if (right < this.size && c.compareTo(this.queue[right]) > 0) {
                child = right;
                c = this.queue[child];
            }
            if (x.compareTo(c) <= 0) break;
            this.queue[k] = c;
            c.index = k;
            k = child;
        }
        this.queue[k] = x;
        x.index = k;
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.queue[i].elem);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.queue = (ElementRef[])Array.newInstance(ElementRef.class, this.size);
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = new ElementRef(s.readObject(), i);
        }
        this.heapify();
    }

    public void heapify() {
        for (int i = (this.size >>> 1) - 1; i >= 0; --i) {
            this.siftDown(i, this.queue[i]);
        }
    }

    public String toString() {
        return "UpdateablePriorityQueue{queue=" + Arrays.toString(this.queue) + ", size=" + this.size + ", comparator=" + this.comparator + ", modCount=" + this.modCount + '}';
    }

    private final class Itr
    implements Iterator<E> {
        private int cursor = 0;
        private int lastRet = -1;
        private ArrayDeque<E> forgetMeNot = null;
        private E lastRetElt = null;
        private int expectedModCount = UpdateablePriorityQueue.access$700(UpdateablePriorityQueue.this);

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < UpdateablePriorityQueue.this.size || this.forgetMeNot != null && !this.forgetMeNot.isEmpty();
        }

        @Override
        public E next() {
            if (this.expectedModCount != UpdateablePriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor < UpdateablePriorityQueue.this.size) {
                this.lastRet = this.cursor++;
                return UpdateablePriorityQueue.this.queue[this.lastRet].elem;
            }
            if (this.forgetMeNot != null) {
                this.lastRet = -1;
                this.lastRetElt = this.forgetMeNot.poll();
                if (this.lastRetElt != null) {
                    return this.lastRetElt;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.expectedModCount != UpdateablePriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet != -1) {
                Object moved = UpdateablePriorityQueue.this.removeAt(this.lastRet);
                this.lastRet = -1;
                if (moved == null) {
                    --this.cursor;
                } else {
                    if (this.forgetMeNot == null) {
                        this.forgetMeNot = new ArrayDeque();
                    }
                    this.forgetMeNot.add(moved);
                }
            } else if (this.lastRetElt != null) {
                UpdateablePriorityQueue.this.removeEq(this.lastRetElt);
                this.lastRetElt = null;
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = UpdateablePriorityQueue.this.modCount;
        }
    }

    public final class ElementRef
    implements Comparable<ElementRef> {
        private E elem;
        private int index;

        ElementRef(E elem, int idx) {
            this.elem = elem;
            this.index = idx;
        }

        @Override
        public int compareTo(ElementRef e) {
            return UpdateablePriorityQueue.this.comparator.compare(this.elem, e.elem);
        }

        public E getElem() {
            return this.elem;
        }

        public int getIndex() {
            return this.index;
        }

        public void setElem(E elem) {
            int compare = UpdateablePriorityQueue.this.comparator.compare(this.elem, elem);
            this.elem = elem;
            if (compare > 0) {
                UpdateablePriorityQueue.this.siftUp(this.index, this);
            } else if (compare < 0) {
                UpdateablePriorityQueue.this.siftDown(this.index, this);
            }
        }

        public void elementMutated() {
            int idx = this.index;
            UpdateablePriorityQueue.this.siftUp(this.index, this);
            if (idx == this.index) {
                UpdateablePriorityQueue.this.siftDown(idx, this);
            }
        }

        public boolean remove() {
            if (this.index < 0) {
                return false;
            }
            UpdateablePriorityQueue.this.removeAt(this.index);
            return true;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.elem);
            return 97 * hash + this.index;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ElementRef other = (ElementRef)obj;
            if (!Objects.equals(this.elem, other.elem)) {
                return false;
            }
            return this.index == other.index;
        }

        public String toString() {
            return "QueueElement{elem=" + this.elem + ", index=" + this.index + '}';
        }
    }
}

