/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;

@CleanupObligation
@Beta
public final class AppendableLimiterWithOverflow
implements Appendable,
Closeable {
    private final int directWriteLimit;
    private final int limit;
    private final Appendable destination;
    private int count;
    private Writer overflowWriter;
    private final CharSequence destinationSuffix;
    private final StringBuilder buffer;
    private StringBuilder asideBuffer;
    private final OverflowSupplier owflSupplier;

    public AppendableLimiterWithOverflow(int limit, final File overflowFile, final CharSequence destinationSuffix, final Charset characterSet, Appendable destination) {
        this(limit, destination, new OverflowSupplier(){

            @Override
            public CharSequence getOverflowReference() {
                String path = overflowFile.getPath();
                StringBuilder sb = new StringBuilder(path.length() + destinationSuffix.length());
                sb.append(destinationSuffix);
                sb.append(path);
                return sb;
            }

            @Override
            public Writer getOverflowWriter() throws IOException {
                return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(overflowFile.toPath(), new OpenOption[0]), characterSet));
            }
        });
    }

    public AppendableLimiterWithOverflow(int limit, Appendable destination, OverflowSupplier owflSupplier) {
        this.limit = limit;
        this.destinationSuffix = owflSupplier.getOverflowReference();
        int refSize = this.destinationSuffix.length();
        this.directWriteLimit = limit - refSize;
        if (this.directWriteLimit < 0) {
            throw new IllegalArgumentException("Limit too small " + limit + " should be at least " + refSize);
        }
        this.destination = destination;
        this.count = 0;
        this.buffer = destination instanceof CharSequence ? null : new StringBuilder(limit);
        this.overflowWriter = null;
        this.asideBuffer = null;
        this.owflSupplier = owflSupplier;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.append(csq, 0, csq.length());
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        int charsToWriteAside;
        int nrChars = end - start;
        int charsToWrite = Math.min(this.directWriteLimit - this.count, nrChars);
        int dwe = start + charsToWrite;
        if (charsToWrite > 0) {
            this.destination.append(csq, start, dwe);
            if (this.buffer != null) {
                this.buffer.append(csq, start, charsToWrite);
            }
            this.count += charsToWrite;
        }
        if ((charsToWriteAside = Math.min(this.limit - this.count, end - dwe)) > 0) {
            if (this.asideBuffer == null) {
                this.asideBuffer = new StringBuilder(this.limit - this.directWriteLimit);
            }
            this.asideBuffer.append(csq, dwe, dwe + charsToWriteAside);
            this.count += charsToWriteAside;
        }
        if (charsToWrite + charsToWriteAside < end) {
            this.createOverflowIfNeeded();
            this.overflowWriter.append(csq, charsToWrite + charsToWriteAside, end);
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        int charsToWrite = Math.min(this.directWriteLimit - this.count, 1);
        if (charsToWrite > 0) {
            this.destination.append(c);
            if (this.buffer != null) {
                this.buffer.append(c);
            }
            ++this.count;
        } else {
            int charsToWriteAside = Math.min(this.limit - this.count, 1);
            if (charsToWriteAside > 0) {
                if (this.asideBuffer == null) {
                    this.asideBuffer = new StringBuilder(this.limit - this.directWriteLimit);
                }
                this.asideBuffer.append(c);
                ++this.count;
            } else {
                this.createOverflowIfNeeded();
                this.overflowWriter.append(c);
            }
        }
        return this;
    }

    public void createOverflowIfNeeded() throws IOException {
        if (this.count >= this.limit && this.overflowWriter == null) {
            this.overflowWriter = this.owflSupplier.getOverflowWriter();
            if (this.buffer != null) {
                this.overflowWriter.append(this.buffer);
            } else {
                CharSequence cs = (CharSequence)((Object)this.destination);
                int l = cs.length();
                this.overflowWriter.append(cs, l - this.directWriteLimit, l);
            }
            this.overflowWriter.append(this.asideBuffer);
            this.asideBuffer = null;
            this.destination.append(this.destinationSuffix);
        }
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        if (this.overflowWriter != null) {
            this.overflowWriter.close();
        } else if (this.asideBuffer != null) {
            this.destination.append(this.asideBuffer);
        }
    }

    public String toString() {
        return "AppendableLimiterWithOverflow{directWriteLimit=" + this.directWriteLimit + ", limit=" + this.limit + ", destination=" + this.destination + ", count=" + this.count + ", overflowWriter=" + this.overflowWriter + ", destinationSuffix=" + this.destinationSuffix + ", buffer=" + this.buffer + ", overflow=" + this.owflSupplier + ", asideBuffer=" + this.asideBuffer + '}';
    }

    public static interface OverflowSupplier {
        public CharSequence getOverflowReference();

        public Writer getOverflowWriter() throws IOException;
    }
}

