/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.OutputStream;
import org.spf4j.base.Base64;
import org.spf4j.recyclable.SizedRecyclingSupplier;
import org.spf4j.recyclable.impl.ArraySuppliers;

@CleanupObligation
public final class BufferedOutputStream
extends OutputStream {
    private byte[] buf;
    private final int length;
    private final OutputStream os;
    private final SizedRecyclingSupplier<byte[]> bufferProvider;
    private int count;

    public BufferedOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public BufferedOutputStream(OutputStream out, int size) {
        this(out, size, ArraySuppliers.Bytes.JAVA_NEW);
    }

    public BufferedOutputStream(OutputStream out, int size, SizedRecyclingSupplier<byte[]> bufferProvider) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0 : " + size);
        }
        this.bufferProvider = bufferProvider;
        this.buf = bufferProvider.get(size);
        this.length = size;
        this.os = out;
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.os.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed " + this.os);
        }
        if (this.count >= this.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed " + this.os);
        }
        if (len >= this.length) {
            this.flushBuffer();
            this.os.write(b, off, len);
            return;
        }
        if (len > this.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed " + this.os);
        }
        this.flushBuffer();
        this.os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DischargesObligation
    public synchronized void close() throws IOException {
        if (this.buf != null) {
            try (OutputStream los = this.os;){
                this.flush();
            }
            finally {
                this.bufferProvider.recycle(this.buf);
                this.buf = null;
            }
        }
    }

    public String toString() {
        return "BufferedOutputStream{buf=" + (this.buf != null ? Base64.encodeBase64(this.buf) : "null") + ", length=" + this.length + ", os=" + this.os + ", bufferProvider=" + this.bufferProvider + ", count=" + this.count + '}';
    }
}

