/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.io.ObjectAppender;
import org.spf4j.io.ObjectAppenderSupplier;
import org.spf4j.reflect.CachingTypeMapWrapper;
import org.spf4j.reflect.GraphTypeMap;

@ParametersAreNonnullByDefault
@Beta
public final class ConfigurableAppenderSupplier
implements ObjectAppenderSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableAppenderSupplier.class);
    private final CachingTypeMapWrapper<ObjectAppender> appenderMap = new CachingTypeMapWrapper(new GraphTypeMap());

    public ConfigurableAppenderSupplier() {
        this(true, x -> false, new ObjectAppender[0]);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public ConfigurableAppenderSupplier(boolean registerFromServiceLoader, Predicate<Class<?>> except, ObjectAppender<?> ... appenders) {
        if (registerFromServiceLoader) {
            ServiceLoader<ObjectAppender> load = ServiceLoader.load(ObjectAppender.class);
            for (ObjectAppender appender : load) {
                Class<?> appenderType = ConfigurableAppenderSupplier.getAppenderType(appender);
                if (except.test(appenderType) || this.register((Class<T>)appenderType, (ObjectAppender<? super T>)appender)) continue;
                LOG.warn("Attempting to register duplicate appender({}) for {} ", (Object)appender, appenderType);
            }
        }
        for (ObjectAppender<?> appender : appenders) {
            if (this.register((Class<T>)ConfigurableAppenderSupplier.getAppenderType(appender), (ObjectAppender<? super T>)appender)) continue;
            throw new IllegalArgumentException("Cannot register appender " + appender);
        }
        this.appenderMap.putIfNotPresent((Type)((Object)Object.class), ObjectAppender.TOSTRING_APPENDER);
    }

    public static Class<?> getAppenderType(ObjectAppender<?> appender) {
        Type[] genericInterfaces = appender.getClass().getGenericInterfaces();
        Class appenderType = null;
        for (Type type : genericInterfaces) {
            ParameterizedType pType;
            if (!(type instanceof ParameterizedType) || (pType = (ParameterizedType)type).getRawType() != ObjectAppender.class) continue;
            appenderType = (Class)pType.getActualTypeArguments()[0];
            break;
        }
        if (appenderType == null) {
            throw new IllegalArgumentException("Improperly declared Appender " + appender);
        }
        return appenderType;
    }

    public <T> int register(Class<T> type, ObjectAppender<? super T> ... appenders) {
        int i = 0;
        for (ObjectAppender<? super T> appender : appenders) {
            if (!this.register(type, appender)) continue;
            ++i;
        }
        return i;
    }

    public <T> void replace(Class<T> type, Function<ObjectAppender<? super T>, ObjectAppender<? super T>> replace) {
        this.appenderMap.replace(type, replace);
    }

    @CheckReturnValue
    private <T> boolean register(Class<T> type, ObjectAppender<? super T> appender) {
        return this.appenderMap.putIfNotPresent(type, appender);
    }

    public boolean unregister(Class<?> type) {
        return this.appenderMap.remove(type);
    }

    @Override
    public ObjectAppender get(Type type) {
        return (ObjectAppender)this.appenderMap.get(type);
    }

    public String toString() {
        return "ConfigurableAppenderSupplier{lookup=" + this.appenderMap + '}';
    }
}

