/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class LazyOutputStreamWrapper
extends OutputStream {
    private volatile OutputStream wrapped;
    private final Supplier<OutputStream> osSuplier;

    public LazyOutputStreamWrapper(Supplier<OutputStream> osSuplier) {
        this.osSuplier = osSuplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream getWrapped() {
        OutputStream os = this.wrapped;
        if (os == null) {
            Supplier<OutputStream> supplier = this.osSuplier;
            synchronized (supplier) {
                os = this.wrapped;
                if (os == null) {
                    this.wrapped = os = this.osSuplier.get();
                }
            }
        }
        return os;
    }

    @Override
    public void write(int b) throws IOException {
        this.getWrapped().write(b);
    }

    @Override
    public void close() throws IOException {
        this.getWrapped().close();
    }

    @Override
    public void flush() throws IOException {
        this.getWrapped().flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.getWrapped().write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.getWrapped().write(b);
    }

    public String toString() {
        return "LazyOutputStreamWrapper{wrapped=" + this.wrapped + ", osSuplier=" + this.osSuplier + '}';
    }
}

