/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface ObjectAppender<T> {
    public static final ObjectAppender<Object> TOSTRING_APPENDER = new ObjectAppender<Object>(){

        @Override
        public void append(Object object, Appendable appendTo) throws IOException {
            String toString = null;
            int i = 10;
            do {
                try {
                    toString = object.toString();
                }
                catch (ConcurrentModificationException ex) {
                    --i;
                }
            } while (toString == null && i > 0);
            if (i != 10) {
                appendTo.append("ConcurrentlyModifiedDuringToString:");
            }
            if (toString == null) {
                appendTo.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
            } else {
                appendTo.append(toString);
            }
        }
    };

    public void append(T var1, Appendable var2) throws IOException;
}

