/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.csv;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.map.hash.THashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.CharSequences;
import org.spf4j.io.PushbackReader;
import org.spf4j.io.csv.CsvHandler;
import org.spf4j.io.csv.CsvMapHandler;
import org.spf4j.io.csv.CsvParseException;
import org.spf4j.io.csv.CsvReader;
import org.spf4j.io.csv.CsvReader2Iterator;
import org.spf4j.io.csv.CsvRowHandler;
import org.spf4j.io.csv.CsvRuntimeException;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
public final class CharSeparatedValues {
    public static final int UTF_BOM = 65279;
    private final char separator;
    private final char[] toEscape;

    public CharSeparatedValues(char separator) {
        Preconditions.checkArgument((separator != '\n' && separator != '\r' && separator != '\"' ? 1 : 0) != 0, (String)"Illegal separator character %s", (char)separator);
        this.separator = separator;
        this.toEscape = new char[]{separator, '\n', '\r', '\"'};
    }

    public void writeCsvRow(Appendable writer, Object ... elems) throws IOException {
        if (elems.length > 0) {
            Object elem;
            int i = 0;
            if ((elem = elems[i++]) != null) {
                this.writeCsvElement(elem.toString(), writer);
            }
            while (i < elems.length) {
                writer.append(this.separator);
                if ((elem = elems[i++]) == null) continue;
                this.writeCsvElement(elem.toString(), writer);
            }
        }
        writer.append('\n');
    }

    public void writeCsvRow2(Appendable writer, Object obj, Object ... elems) throws IOException {
        if (obj != null) {
            this.writeCsvElement(obj.toString(), writer);
        }
        for (Object elem : elems) {
            writer.append(this.separator);
            if (elem == null) continue;
            this.writeCsvElement(elem.toString(), writer);
        }
        writer.append('\n');
    }

    public void writeCsvRow(Appendable writer, long ... elems) throws IOException {
        this.writeCsvRowNoEOL(elems, writer);
        writer.append('\n');
    }

    public void writeCsvRowNoEOL(long[] elems, Appendable writer) throws IOException {
        if (elems.length > 0) {
            int i = 0;
            writer.append(Long.toString(elems[i++]));
            while (i < elems.length) {
                writer.append(this.separator);
                writer.append(Long.toString(elems[i++]));
            }
        }
    }

    public void writeCsvRow(Appendable writer, Iterable<?> elems) throws IOException {
        this.writeCsvRowNoEOL(elems, writer);
        writer.append('\n');
    }

    public void writeCsvRowNoEOL(Iterable<?> elems, Appendable writer) throws IOException {
        Iterator<?> it = elems.iterator();
        if (it.hasNext()) {
            Object next = it.next();
            if (next != null) {
                this.writeCsvElement(next.toString(), writer);
            }
            while (it.hasNext()) {
                writer.append(this.separator);
                next = it.next();
                if (next == null) continue;
                this.writeCsvElement(next.toString(), writer);
            }
        }
    }

    public <T> T read(File file, Charset charset, CsvMapHandler<T> handler) throws IOException, CsvParseException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), charset));){
            T t = this.read((Reader)br, handler);
            return t;
        }
    }

    public <T> T read(File file, Charset charset, CsvHandler<T> handler) throws IOException, CsvParseException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), charset));){
            T t = this.read((Reader)br, handler);
            return t;
        }
    }

    public List<Map<String, String>> read(Reader preader) throws IOException, CsvParseException {
        return this.read(preader, new ToListMapHandler());
    }

    public <T> T read(Reader preader, CsvMapHandler<T> handler) throws IOException, CsvParseException {
        return this.read(preader, new CsvMapHandler2CsvHandler<T>(handler));
    }

    public List<String> readRow(Reader reader) throws IOException, CsvParseException {
        return this.readRow(reader, new CsvRow2List());
    }

    public <T> T readRow(Reader reader, CsvRowHandler<T> handler) throws IOException, CsvParseException {
        return this.read(reader, new OneRowHandler<T>(handler));
    }

    public <T> T read(Reader preader, CsvHandler<T> handler) throws IOException, CsvParseException {
        PushbackReader reader = new PushbackReader(preader);
        int firstChar = reader.read();
        if (firstChar != 65279 && firstChar >= 0) {
            reader.unread(firstChar);
        }
        return this.readNoBom(reader, handler);
    }

    public <T> T readNoBom(PushbackReader reader, CsvHandler<T> handler) throws IOException, CsvParseException {
        boolean start = true;
        StringBuilder strB = new StringBuilder();
        boolean loop = true;
        int lineNr = 0;
        try {
            block7: do {
                if (start) {
                    handler.startRow(lineNr);
                    start = false;
                }
                strB.setLength(0);
                int c = this.readCsvElement(reader, strB, lineNr);
                handler.element(strB);
                switch (c) {
                    case 13: {
                        handler.endRow();
                        start = true;
                        int c2 = reader.read();
                        if (c2 < 0) {
                            loop = false;
                            break;
                        }
                        if (c2 == 10) continue block7;
                        reader.unread(c2);
                        break;
                    }
                    case 10: {
                        ++lineNr;
                        handler.endRow();
                        start = true;
                        break;
                    }
                    default: {
                        if (c == this.separator) continue block7;
                        if (c < 0) {
                            loop = false;
                            break;
                        }
                        throw new CsvParseException("Unexpected character " + c + " at line " + lineNr);
                    }
                }
            } while (loop);
        }
        catch (IOException ex) {
            throw new IOException("IO issue at line " + lineNr, ex);
        }
        catch (RuntimeException ex) {
            throw new CsvRuntimeException("Exception at line " + lineNr, ex);
        }
        handler.endRow();
        return handler.eof();
    }

    public Iterable<Iterable<String>> asIterable(Reader preader) {
        return () -> {
            try {
                return new CsvReader2Iterator(this.reader(preader));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        };
    }

    public CsvReader reader(Reader preader) throws IOException {
        PushbackReader reader = new PushbackReader(preader);
        int firstChar = reader.read();
        if (firstChar != 65279 && firstChar >= 0) {
            reader.unread(firstChar);
        }
        return this.readerNoBOM(reader);
    }

    public CsvReader readerNoBOM(PushbackReader reader) {
        return new CsvReaderImpl(reader);
    }

    public void writeCsvElement(CharSequence elem, Appendable writer) throws IOException {
        if (CharSequences.containsAnyChar(elem, this.toEscape)) {
            CharSeparatedValues.writeQuotedCsvElement(elem, writer);
        } else {
            writer.append(elem);
        }
    }

    public static void writeQuotedCsvElement(CharSequence elem, Appendable writer) throws IOException {
        int length = elem.length();
        writer.append('\"');
        for (int i = 0; i < length; ++i) {
            char c = elem.charAt(i);
            if (c == '\"') {
                writer.append("\"\"");
                continue;
            }
            writer.append(c);
        }
        writer.append('\"');
    }

    public CharSequence toCsvElement(CharSequence elem) {
        if (CharSequences.containsAnyChar(elem, this.toEscape)) {
            StringWriter sw = new StringWriter(elem.length() - 1);
            try {
                CharSeparatedValues.writeQuotedCsvElement(elem, sw);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            return sw.toString();
        }
        return elem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CheckReturnValue
    public int readCsvElement(Reader reader, StringBuilder addElemTo, int lineNr) throws IOException, CsvParseException {
        int c = reader.read();
        if (c < 0) {
            return c;
        }
        if (c == 34) {
            c = reader.read();
            while (c >= 0) {
                if (c == 34) {
                    int c2 = reader.read();
                    if (c2 < 0) return c2;
                    if (c2 != 34) return c2;
                    addElemTo.append((char)c);
                } else {
                    addElemTo.append((char)c);
                }
                c = reader.read();
            }
            throw new CsvParseException("Escaped CSV element " + addElemTo + " not terminated correctly at " + lineNr);
        }
        while (c != this.separator && c != 10 && c != 13 && c >= 0) {
            addElemTo.append((char)c);
            c = reader.read();
        }
        return c;
    }

    public String toString() {
        return "CharSepValues{separator=" + this.separator + '}';
    }

    private static final class CsvRow2List
    implements CsvRowHandler<List<String>> {
        private final List<String> result = new ArrayList<String>();

        private CsvRow2List() {
        }

        @Override
        public void element(CharSequence elem) {
            this.result.add(elem.toString());
        }

        @Override
        public List<String> eof() {
            return this.result;
        }
    }

    private static class OneRowHandler<T>
    implements CsvHandler<T> {
        private final CsvRowHandler<T> handler;

        OneRowHandler(CsvRowHandler<T> handler) {
            this.handler = handler;
        }

        @Override
        public void startRow(int rowNr) {
            if (rowNr > 0) {
                throw new IllegalArgumentException("Multiple rows encountered for " + this);
            }
        }

        @Override
        public void element(CharSequence elem) {
            this.handler.element(elem);
        }

        @Override
        public T eof() {
            return this.handler.eof();
        }
    }

    private class CsvReaderImpl
    implements CsvReader {
        private final PushbackReader reader;
        private final StringBuilder currentElement = new StringBuilder();
        private CsvReader.TokenType currentToken;
        private CsvReader.TokenType nextToken;
        private int lineNr = 0;

        CsvReaderImpl(PushbackReader reader) {
            this.reader = reader;
        }

        private void readCurrentElement() throws IOException, CsvParseException {
            this.currentElement.setLength(0);
            int next = CharSeparatedValues.this.readCsvElement(this.reader, this.currentElement, this.lineNr);
            this.currentToken = CsvReader.TokenType.ELEMENT;
            switch (next) {
                case 13: {
                    int c2 = this.reader.read();
                    if (c2 < 0) {
                        this.nextToken = CsvReader.TokenType.END_DOCUMENT;
                        break;
                    }
                    if (c2 != 10) {
                        this.reader.unread(c2);
                    }
                    ++this.lineNr;
                    this.nextToken = CsvReader.TokenType.END_ROW;
                    break;
                }
                case 10: {
                    ++this.lineNr;
                    this.nextToken = CsvReader.TokenType.END_ROW;
                    break;
                }
                default: {
                    if (next == CharSeparatedValues.this.separator) break;
                    if (next < 0) {
                        this.nextToken = CsvReader.TokenType.END_DOCUMENT;
                        break;
                    }
                    throw new CsvParseException("Unexpected character " + next + " at line" + this.lineNr);
                }
            }
        }

        @Override
        public CsvReader.TokenType next() throws IOException, CsvParseException {
            if (this.currentToken == null) {
                if (this.nextToken == null) {
                    this.readCurrentElement();
                    CsvReader.TokenType result = this.currentToken;
                    if (result != CsvReader.TokenType.END_DOCUMENT) {
                        this.currentToken = null;
                    }
                    return result;
                }
                CsvReader.TokenType result = this.nextToken;
                if (result != CsvReader.TokenType.END_DOCUMENT) {
                    this.nextToken = null;
                }
                return result;
            }
            return this.currentToken;
        }

        @Override
        public CharSequence getElement() {
            return this.currentElement;
        }
    }

    private static class CsvMapHandler2CsvHandler<T>
    implements CsvHandler<T> {
        private final CsvMapHandler<T> handler;
        private boolean first = true;
        private final List<String> header = new ArrayList<String>();
        private int elemIdx;
        private Map<String, String> row = null;
        private int lineNr;

        CsvMapHandler2CsvHandler(CsvMapHandler<T> handler) {
            this.handler = handler;
        }

        @Override
        public void startRow(int ln) {
            this.lineNr = ln;
            this.elemIdx = 0;
            if (!this.first) {
                this.row = new THashMap(this.header.size());
            }
        }

        @Override
        public void element(CharSequence elem) throws CsvParseException {
            if (this.first) {
                this.header.add(elem.toString());
            } else {
                if (this.header.size() <= this.elemIdx) {
                    throw new CsvParseException("Too many elements in row " + this.row + " at line " + this.lineNr);
                }
                this.row.put(this.header.get(this.elemIdx), elem.toString());
            }
            ++this.elemIdx;
        }

        @Override
        public void endRow() {
            if (this.first) {
                this.first = false;
            } else {
                this.handler.row(this.row);
            }
        }

        @Override
        public T eof() {
            return this.handler.eof();
        }
    }

    private static class ToListMapHandler
    implements CsvMapHandler<List<Map<String, String>>> {
        private List<Map<String, String>> result = new ArrayList<Map<String, String>>();

        private ToListMapHandler() {
        }

        @Override
        public void row(Map<String, String> row) {
            this.result.add(row);
        }

        @Override
        public List<Map<String, String>> eof() {
            return this.result;
        }
    }
}

