/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jdbc;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.sql.DataSource;
import org.spf4j.base.CallablesNano;
import org.spf4j.base.CallablesNanoNonInterrupt;
import org.spf4j.base.HandlerNano;
import org.spf4j.base.JavaUtils;

@Beta
public final class JdbcTemplate {
    private static final int MAX_JDBC_TIMEOUTSECONDS = Integer.getInteger("spf4j.jdbc.maxdbcTimeoutSeconds", 86400);
    private final DataSource dataSource;

    public JdbcTemplate(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static void checkJdbcObjectName(CharSequence name) {
        if (!JavaUtils.isJavaIdentifier(name) || name.length() > 30) {
            throw new IllegalArgumentException("Invalid database Object identifier " + name);
        }
    }

    @SuppressFBWarnings(value={"BED_BOGUS_EXCEPTION_DECLARATION"})
    public <R> R transactOnConnection(final HandlerNano<Connection, R, SQLException> handler, long timeout, TimeUnit tu) throws SQLException, InterruptedException {
        try {
            return (R)CallablesNano.executeWithRetry(new CallablesNano.NanoTimeoutCallable<R, SQLException>(tu.toNanos(timeout)){

                /*
                 * Exception decompiling
                 */
                @Override
                @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
                public R call(long deadlineNanos) throws SQLException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }, 2, 1000L, SQLException.class);
        }
        catch (TimeoutException ex) {
            throw new SQLTimeoutException(ex);
        }
    }

    @SuppressFBWarnings(value={"BED_BOGUS_EXCEPTION_DECLARATION"})
    public <R> R transactOnConnectionNonInterrupt(final HandlerNano<Connection, R, SQLException> handler, long timeout, TimeUnit tu) throws SQLException {
        return (R)CallablesNanoNonInterrupt.executeWithRetry(new CallablesNano.NanoTimeoutCallable<R, SQLException>(tu.toNanos(timeout)){

            /*
             * Exception decompiling
             */
            @Override
            @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
            public R call(long deadlineNanos) throws SQLException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, 2, 1000L, SQLException.class);
    }

    public static int getTimeoutToDeadlineSeconds(long deadlineNanos) {
        long toSeconds = TimeUnit.NANOSECONDS.toSeconds(deadlineNanos - System.nanoTime());
        if (toSeconds < 0L) {
            throw new UncheckedTimeoutException("deadline exceeded by " + -toSeconds + " seconds");
        }
        if (toSeconds > (long)MAX_JDBC_TIMEOUTSECONDS) {
            return MAX_JDBC_TIMEOUTSECONDS;
        }
        return (int)toSeconds;
    }

    public String toString() {
        return "JdbcTemplate{dataSource=" + this.dataSource + '}';
    }

    static /* synthetic */ DataSource access$000(JdbcTemplate x0) {
        return x0.dataSource;
    }
}

