/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.InvalidAttributeValueException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.spf4j.jmx.ExportedValue;
import org.spf4j.jmx.GlobalMXBeanMapperSupplier;
import org.spf4j.jmx.JMXBeanMapping;

class BeanExportedValue
implements ExportedValue<Object> {
    private final String name;
    private final String description;
    private final Method getMethod;
    private final Method setMethod;
    private final Object object;
    private final Type valueClass;
    private final JMXBeanMapping converter;

    BeanExportedValue(@Nonnull String name, @Nullable String description, @Nullable Method getMethod, @Nullable Method setMethod, @Nullable Object object, @Nonnull Type valueClass, boolean mapOpenType) {
        this.name = name;
        this.description = description;
        this.getMethod = getMethod;
        this.setMethod = setMethod;
        this.object = object;
        this.valueClass = valueClass;
        if (mapOpenType) {
            try {
                this.converter = GlobalMXBeanMapperSupplier.getOpenTypeMapping(valueClass);
            }
            catch (NotSerializableException ex) {
                throw new UnsupportedOperationException("Unable to export " + getMethod + ", " + setMethod, ex);
            }
        } else {
            this.converter = null;
        }
    }

    public BeanExportedValue withSetter(@Nonnull Method psetMethod) {
        if (this.setMethod != null) {
            throw new IllegalArgumentException("duplicate value registration attemted " + this.setMethod + ", " + psetMethod);
        }
        return new BeanExportedValue(this.name, this.description, this.getMethod, psetMethod, this.object, this.valueClass, this.converter != null);
    }

    public BeanExportedValue withGetter(@Nonnull Method pgetMethod, @Nonnull String pdescription) {
        if (this.getMethod != null) {
            throw new IllegalArgumentException("duplicate value registration attemted " + this.getMethod + ", " + pgetMethod);
        }
        return new BeanExportedValue(this.name, pdescription, pgetMethod, this.setMethod, this.object, this.valueClass, this.converter != null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object get() throws OpenDataException {
        try {
            if (this.converter != null) {
                return this.converter.toOpenValue(this.getMethod.invoke(this.object, new Object[0]));
            }
            return this.getMethod.invoke(this.object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            OpenDataException thr = new OpenDataException("Cannot get " + this.getMethod);
            thr.addSuppressed(ex);
            throw thr;
        }
    }

    @Override
    public void set(Object value) throws InvalidAttributeValueException, InvalidObjectException {
        if (this.setMethod == null) {
            throw new InvalidAttributeValueException(this.name + " is a read only attribute ");
        }
        try {
            if (this.converter != null) {
                this.setMethod.invoke(this.object, this.converter.fromOpenValue(value));
            } else {
                this.setMethod.invoke(this.object, value);
            }
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            InvalidObjectException iox = new InvalidObjectException("Cannot set " + value);
            iox.addSuppressed(ex);
            throw iox;
        }
    }

    @Override
    public boolean isWriteable() {
        return this.setMethod != null;
    }

    @Override
    public Type getValueType() {
        return this.valueClass;
    }

    public boolean isValid() {
        return this.getMethod != null;
    }

    public String toString() {
        return "ExportedValueImpl{name=" + this.name + ", description=" + this.description + ", getMethod=" + this.getMethod + ", setMethod=" + this.setMethod + ", object=" + this.object + ", valueClass=" + this.valueClass + ", converter=" + this.converter + '}';
    }

    @Override
    public OpenType<?> getValueOpenType() {
        return this.converter != null ? this.converter.getOpenType() : null;
    }
}

