/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Reflections;
import org.spf4j.base.Throwables;
import org.spf4j.jmx.ExportedOperation;
import org.spf4j.jmx.ExportedValue;

@SuppressFBWarnings(value={"LEST_LOST_EXCEPTION_STACK_TRACE"})
final class ExportedValuesMBean
implements DynamicMBean {
    private static final Logger LOG = LoggerFactory.getLogger(ExportedValuesMBean.class);
    private static final Pattern INVALID_CHARS = Pattern.compile("[^a-zA-Z0-9_\\-\\.]");
    private final Map<String, ExportedValue<?>> exportedValues;
    private final Map<String, ExportedOperation> exportedOperations;
    private final ObjectName objectName;
    private final MBeanInfo beanInfo;

    ExportedValuesMBean(ObjectName objectName, Map<String, ExportedValue<?>> exportedValues, Map<String, ExportedOperation> exportedOperations) {
        this.exportedOperations = exportedOperations;
        this.exportedValues = exportedValues;
        this.objectName = objectName;
        this.beanInfo = this.createBeanInfo();
    }

    ExportedValuesMBean(ObjectName objectName, ExportedValue<?>[] exported, ExportedOperation[] operations) {
        this.exportedValues = new HashMap(exported.length);
        for (ExportedValue<?> val : exported) {
            if (this.exportedValues.put(val.getName(), val) == null) continue;
            throw new IllegalArgumentException("Duplicate attribute " + val);
        }
        this.exportedOperations = new HashMap<String, ExportedOperation>(operations.length);
        for (ExportedOperation op : operations) {
            if (this.exportedOperations.put(op.getName(), op) == null) continue;
            throw new IllegalArgumentException("Duplicate operation " + op);
        }
        this.objectName = objectName;
        this.beanInfo = this.createBeanInfo();
    }

    ExportedValuesMBean(ExportedValuesMBean extend, ExportedValue<?>[] exported, ExportedOperation[] operations) {
        this.exportedValues = new HashMap(exported.length + extend.exportedValues.size());
        this.exportedValues.putAll(extend.exportedValues);
        for (ExportedValue<?> val : exported) {
            if (this.exportedValues.put(val.getName(), val) == null) continue;
            throw new IllegalArgumentException("Duplicate attribute " + val);
        }
        this.exportedOperations = new HashMap<String, ExportedOperation>(operations.length + extend.exportedOperations.size());
        this.exportedOperations.putAll(extend.exportedOperations);
        for (ExportedOperation op : operations) {
            if (this.exportedOperations.put(op.getName(), op) == null) continue;
            throw new IllegalArgumentException("Duplicate operation " + op);
        }
        this.objectName = extend.getObjectName();
        this.beanInfo = extend.beanInfo;
    }

    ExportedValuesMBean(ExportedValuesMBean extend, Map<String, ExportedValue<?>> exportedValues, Map<String, ExportedOperation> exportedOperations) {
        this.exportedValues = exportedValues;
        this.exportedValues.putAll(extend.exportedValues);
        this.exportedOperations = exportedOperations;
        this.exportedOperations.putAll(extend.exportedOperations);
        this.objectName = extend.getObjectName();
        this.beanInfo = this.createBeanInfo();
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException {
        ExportedValue<?> result = this.exportedValues.get(name);
        if (result == null) {
            throw new AttributeNotFoundException(name);
        }
        try {
            return result.get();
        }
        catch (RuntimeException | OpenDataException ex) {
            LOG.error("Exception while getting attr {}", (Object)name, (Object)ex);
            throw new MBeanException(null, "Error getting attribute" + name + " detail:\n" + Throwables.toString(ex));
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException {
        String name = attribute.getName();
        ExportedValue<?> result = this.exportedValues.get(name);
        if (result == null) {
            throw new AttributeNotFoundException(name);
        }
        try {
            result.set(attribute.getValue());
        }
        catch (InvalidObjectException | RuntimeException ex) {
            LOG.warn("Exception while setting attr {}", (Object)attribute, (Object)ex);
            throw new InvalidAttributeValueException("Invalid value " + attribute + " detail:\n" + Throwables.toString(ex));
        }
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        AttributeList list = new AttributeList(names.length);
        for (String name : names) {
            try {
                ExportedValue<?> attr = this.exportedValues.get(name);
                if (attr == null) {
                    throw new IllegalArgumentException("No attribute with name " + name);
                }
                list.add(new Attribute(name, attr.get()));
            }
            catch (RuntimeException | OpenDataException ex) {
                LOG.error("Exception getting attribute {}", (Object)name, (Object)ex);
                throw new JMRuntimeException("Exception while getting attributes " + Arrays.toString(names) + ", detail:\n" + Throwables.toString(ex));
            }
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        AttributeList result = new AttributeList(list.size());
        for (Attribute attr : list.asList()) {
            ExportedValue<?> eval = this.exportedValues.get(attr.getName());
            if (eval == null) continue;
            try {
                eval.set(attr.getValue());
                result.add(attr);
            }
            catch (InvalidObjectException | RuntimeException | InvalidAttributeValueException ex) {
                LOG.warn("Exception while setting attr {}", (Object)attr, (Object)ex);
                throw new JMRuntimeException("Exception while setting attributes " + list + ", detail:\n" + Throwables.toString(ex));
            }
        }
        return result;
    }

    @Override
    public Object invoke(String name, Object[] args, String[] sig) throws MBeanException {
        try {
            return this.exportedOperations.get(name).invoke(args);
        }
        catch (InvalidObjectException | RuntimeException | OpenDataException ex) {
            LOG.warn("Exception while invoking operation {}({})", new Object[]{name, args, ex});
            throw new MBeanException(null, "Exception invoking" + name + " with " + Arrays.toString(args) + ", detail:\n" + Throwables.toString(ex));
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.beanInfo;
    }

    public static ObjectName createObjectName(String domain, String name) {
        try {
            String sanitizedDomain = INVALID_CHARS.matcher(domain).replaceAll("_");
            String sanitizedName = INVALID_CHARS.matcher(name).replaceAll("_");
            StringBuilder builder = new StringBuilder();
            builder.append(sanitizedDomain).append(':');
            builder.append("name=").append(sanitizedName);
            return new ObjectName(builder.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid name for " + domain + ", " + name, e);
        }
    }

    private MBeanInfo createBeanInfo() {
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[this.exportedValues.size()];
        int i = 0;
        for (ExportedValue<?> val : this.exportedValues.values()) {
            attrs[i++] = ExportedValuesMBean.createAttributeInfo(val);
        }
        MBeanOperationInfo[] operations = new MBeanOperationInfo[this.exportedOperations.size()];
        i = 0;
        for (ExportedOperation op : this.exportedOperations.values()) {
            MBeanParameterInfo[] paramInfos = op.getParameterInfos();
            String description = op.getDescription();
            if (description == null || description.isEmpty()) {
                description = op.getName();
            }
            OpenType<?> openType = op.getReturnOpenType();
            operations[i++] = new MBeanOperationInfo(op.getName(), description, paramInfos, op.getReturnType().getName(), 0, openType == null ? null : new ImmutableDescriptor(new String[]{"openType", "originalType"}, new Object[]{openType, op.getReturnType().getName()}));
        }
        return new MBeanInfo(this.objectName.toString(), "spf4j exported", attrs, null, operations, null);
    }

    private static MBeanAttributeInfo createAttributeInfo(ExportedValue<?> val) {
        Type oClass = val.getValueType();
        Class<?> valClass = oClass instanceof Class ? Reflections.primitiveToWrapper((Class)oClass) : null;
        OpenType<?> openType = val.getValueOpenType();
        String description = val.getDescription();
        if (description == null || description.isEmpty()) {
            description = val.getName();
        }
        if (openType != null) {
            try {
                return new OpenMBeanAttributeInfoSupport(val.getName(), description, openType, true, val.isWriteable(), valClass == Boolean.class);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Cannot export " + val, ex);
            }
        }
        return new MBeanAttributeInfo(val.getName(), oClass.getTypeName(), val.getDescription(), true, val.isWriteable(), valClass == Boolean.class);
    }

    public String toString() {
        return "ExportedValuesMBean{exportedValues=" + this.exportedValues + ", exportedOperations=" + this.exportedOperations + ", objectName=" + this.objectName + ", beanInfo=" + this.beanInfo + '}';
    }
}

