/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.spf4j.jmx.DynamicMBeanBuilder;
import org.spf4j.jmx.ExportedValuesMBean;

public final class Registry {
    private static final MBeanServer MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private static final Map<ObjectName, Object> REGISTERED = new HashMap<ObjectName, Object>();

    private Registry() {
    }

    public static synchronized Object registerMBean(ObjectName objectName, Object mbean) {
        Object replaced = null;
        if (MBEAN_SERVER.isRegistered(objectName)) {
            try {
                replaced = REGISTERED.remove(objectName);
                MBEAN_SERVER.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException ex) {
                throw new IllegalStateException(ex);
            }
        }
        try {
            MBEAN_SERVER.registerMBean(mbean, objectName);
        }
        catch (InstanceAlreadyExistsException ex) {
            throw new IllegalStateException(ex);
        }
        catch (MBeanRegistrationException | NotCompliantMBeanException ex) {
            throw new IllegalArgumentException("Invalid MBean " + mbean, ex);
        }
        REGISTERED.put(objectName, mbean);
        return replaced;
    }

    public static synchronized void registerIfNotExistsMBean(ObjectName objectName, Object mbean) {
        try {
            MBEAN_SERVER.registerMBean(mbean, objectName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException ex) {
            throw new RuntimeException(ex);
        }
        REGISTERED.put(objectName, mbean);
    }

    public static synchronized Object getRegistered(ObjectName objectName) {
        return REGISTERED.get(objectName);
    }

    public static Object getRegistered(String domain, String name) {
        return Registry.getRegistered(ExportedValuesMBean.createObjectName(domain, name));
    }

    public static Object registerMBean(String domain, String name, Object object) {
        return Registry.registerMBean(ExportedValuesMBean.createObjectName(domain, name), object);
    }

    @Nullable
    public static Object unregister(Object object) {
        Class<?> aClass = object.getClass();
        return Registry.unregister(aClass.getPackage().getName(), aClass.getSimpleName());
    }

    @Nullable
    public static Object unregister(Class<?> object) {
        return Registry.unregister(object.getPackage().getName(), object.getSimpleName());
    }

    @Nullable
    public static Object unregister(String packageName, String mbeanName) {
        ObjectName objectName = ExportedValuesMBean.createObjectName(packageName, mbeanName);
        return Registry.unregister(objectName);
    }

    @Nullable
    public static synchronized Object unregister(ObjectName objectName) {
        Object result = null;
        if (MBEAN_SERVER.isRegistered(objectName)) {
            try {
                result = REGISTERED.remove(objectName);
                MBEAN_SERVER.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException ex) {
                throw new IllegalArgumentException("Cannot unregister " + objectName, ex);
            }
        }
        return result;
    }

    public static ExportedValuesMBean export(Object object) {
        Class<?> aClass = object.getClass();
        return Registry.export(aClass.getPackage().getName(), aClass.getSimpleName(), object);
    }

    public static ExportedValuesMBean export(Class<?> object) {
        return Registry.export(object.getPackage().getName(), object.getSimpleName(), object);
    }

    public static ExportedValuesMBean export(String packageName, String mbeanName, Object ... objects) {
        return new DynamicMBeanBuilder().withJmxExportObjects(objects).replace(packageName, mbeanName);
    }

    @Deprecated
    @SuppressFBWarnings(value={"OCP_OVERLY_CONCRETE_PARAMETER"})
    public static ExportedValuesMBean export(String packageName, String mbeanName, Properties attributes, Object ... objects) {
        DynamicMBeanBuilder builder = new DynamicMBeanBuilder().withJmxExportObjects(objects);
        if (attributes != null) {
            builder.withAttributes(attributes);
        }
        return builder.replace(packageName, mbeanName);
    }

    @Deprecated
    public static ExportedValuesMBean export(String packageName, String mbeanName, @Nullable Map<String, Object> attributes, Object ... objects) {
        DynamicMBeanBuilder builder = new DynamicMBeanBuilder().withJmxExportObjects(objects);
        if (attributes != null) {
            builder.withAttributes(attributes);
        }
        return builder.replace(packageName, mbeanName);
    }
}

