/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx.mappers;

import com.sun.jmx.mbeanserver.MXBeanMapping;
import java.io.InvalidObjectException;
import java.lang.reflect.Type;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.spf4j.jmx.JMXBeanMapping;

public final class MXBeanMappings {
    private MXBeanMappings() {
    }

    public static JMXBeanMapping convert(final MXBeanMapping mapping) {
        return new JMXBeanMapping(){

            @Override
            public Object fromOpenValue(Object openValue) throws InvalidObjectException {
                return mapping.fromOpenValue(openValue);
            }

            @Override
            public Object toOpenValue(Object javaValue) throws OpenDataException {
                return mapping.toOpenValue(javaValue);
            }

            @Override
            public Type getJavaType() {
                return mapping.getJavaType();
            }

            @Override
            public OpenType<?> getOpenType() {
                return mapping.getOpenType();
            }

            @Override
            public Class<?> getMappedType() {
                return mapping.getOpenClass();
            }
        };
    }

    public static MXBeanMapping convert(final JMXBeanMapping mapping) {
        return new MXBeanMapping(mapping.getJavaType(), mapping.getOpenType()){

            @Override
            public Object fromOpenValue(Object openValue) throws InvalidObjectException {
                return mapping.fromOpenValue(openValue);
            }

            @Override
            public Object toOpenValue(Object javaValue) throws OpenDataException {
                return mapping.toOpenValue(javaValue);
            }
        };
    }

    public static Class<?> makeOpenClass(Type javaType, OpenType<?> openType) {
        if (javaType instanceof Class && ((Class)javaType).isPrimitive()) {
            return (Class)javaType;
        }
        try {
            String className = openType.getClassName();
            return Class.forName(className, false, MXBeanMapping.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot get OpenType " + openType, e);
        }
    }
}

