/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx.mappers;

import com.sun.jmx.mbeanserver.MXBeanMapping;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.apache.commons.lang3.tuple.Pair;
import org.spf4j.base.ComparablePair;
import org.spf4j.base.SerializablePair;
import org.spf4j.jmx.JMXBeanMapping;
import org.spf4j.jmx.JMXBeanMappingSupplier;

@SuppressFBWarnings(value={"SCII_SPOILED_CHILD_INTERFACE_IMPLEMENTOR", "CLI_CONSTANT_LIST_INDEX"})
public final class MapEntryOpenTypeMapping
extends MXBeanMapping
implements JMXBeanMapping {
    private static final String[] NAMES = new String[]{"key", "value"};
    private final JMXBeanMappingSupplier typeMapper;
    private final Class<?> rawType;
    private final Type[] actualTypeArguments;

    public MapEntryOpenTypeMapping(ParameterizedType javaType, JMXBeanMappingSupplier typeMapper) throws NotSerializableException {
        super(javaType, MapEntryOpenTypeMapping.typeFromMapEntry(javaType, typeMapper));
        this.typeMapper = typeMapper;
        this.rawType = (Class)javaType.getRawType();
        this.actualTypeArguments = javaType.getActualTypeArguments();
    }

    @Override
    @SuppressFBWarnings(value={"URV_INHERITED_METHOD_WITH_RELATED_TYPES"})
    public Object fromOpenValue(Object openValue) throws InvalidObjectException {
        if (!(openValue instanceof CompositeData)) {
            throw new InvalidObjectException("Not a CompositeData " + openValue);
        }
        CompositeData cd = (CompositeData)openValue;
        try {
            if (this.rawType == Pair.class) {
                return Pair.of((Object)this.typeMapper.get(this.actualTypeArguments[0]).fromOpenValue(cd.get("key")), (Object)this.typeMapper.get(this.actualTypeArguments[1]).fromOpenValue(cd.get("value")));
            }
            if (this.rawType == SerializablePair.class) {
                return SerializablePair.of((Serializable)this.typeMapper.get(this.actualTypeArguments[0]).fromOpenValue(cd.get("key")), (Serializable)this.typeMapper.get(this.actualTypeArguments[1]).fromOpenValue(cd.get("value")));
            }
            if (this.rawType == ComparablePair.class) {
                return new ComparablePair<Serializable, Serializable>((Serializable)((Object)((Comparable)((Object)((Serializable)this.typeMapper.get(this.actualTypeArguments[0]).fromOpenValue(cd.get("key")))))), (Serializable)((Object)((Comparable)((Object)((Serializable)this.typeMapper.get(this.actualTypeArguments[1]).fromOpenValue(cd.get("value")))))));
            }
            return Pair.of((Object)this.typeMapper.get(this.actualTypeArguments[0]).fromOpenValue(cd.get("key")), (Object)this.typeMapper.get(this.actualTypeArguments[1]).fromOpenValue(cd.get("value")));
        }
        catch (NotSerializableException ex) {
            InvalidObjectException iex = new InvalidObjectException("Not serializable " + openValue);
            iex.initCause(ex);
            throw iex;
        }
    }

    @Override
    public Object toOpenValue(Object javaValue) throws OpenDataException {
        Map.Entry entry = (Map.Entry)javaValue;
        try {
            return new CompositeDataSupport((CompositeType)this.getOpenType(), NAMES, new Object[]{this.typeMapper.get(this.actualTypeArguments[0]).toOpenValue(entry.getKey()), this.typeMapper.get(this.actualTypeArguments[1]).toOpenValue(entry.getValue())});
        }
        catch (NotSerializableException ex) {
            OpenDataException iex = new OpenDataException("Not serializable " + javaValue);
            iex.initCause(ex);
            throw iex;
        }
    }

    private static CompositeType typeFromMapEntry(ParameterizedType type, JMXBeanMappingSupplier typeMapper) throws NotSerializableException {
        Type[] typeArgs = type.getActualTypeArguments();
        String[] descriptions = new String[2];
        OpenType[] types = new OpenType[2];
        descriptions[0] = "key of " + type;
        Type typeArg0 = typeArgs[0];
        JMXBeanMapping km = typeMapper.get(typeArg0);
        if (km == null) {
            throw new IllegalArgumentException("Cannot map to open type " + typeArg0);
        }
        types[0] = km.getOpenType();
        descriptions[1] = "value of " + type;
        Type typeArg1 = typeArgs[1];
        JMXBeanMapping km2 = typeMapper.get(typeArg1);
        if (km2 == null) {
            throw new IllegalArgumentException("Cannot map to open type " + typeArg1);
        }
        types[1] = km2.getOpenType();
        try {
            return new CompositeType(type.getTypeName(), type.toString(), NAMES, descriptions, types);
        }
        catch (OpenDataException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public Class<?> getMappedType() {
        return this.getOpenClass();
    }

    public String toString() {
        return "MapEntryOpenTypeMapping{javaType=" + this.getJavaType() + ", openType=" + this.getOpenType() + '}';
    }
}

