/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx.mappers;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.sun.jmx.mbeanserver.MXBeanMapping;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecordBase;
import org.spf4j.base.Reflections;
import org.spf4j.jmx.JMXBeanMapping;
import org.spf4j.jmx.JMXBeanMappingSupplier;

@SuppressFBWarnings(value={"SCII_SPOILED_CHILD_INTERFACE_IMPLEMENTOR"})
public final class SpecificRecordOpenTypeMapping
extends MXBeanMapping
implements JMXBeanMapping {
    private static final Schema NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
    private final JMXBeanMappingSupplier typeMapper;

    public SpecificRecordOpenTypeMapping(Class<? extends SpecificRecordBase> javaType, JMXBeanMappingSupplier typeMapper) throws NotSerializableException {
        super(javaType, SpecificRecordOpenTypeMapping.typeFromSpecificRecord(javaType, typeMapper));
        this.typeMapper = typeMapper;
    }

    @Override
    public Object fromOpenValue(Object openValue) throws InvalidObjectException {
        SpecificRecordBase rec;
        if (!(openValue instanceof CompositeData)) {
            throw new InvalidObjectException("Not a CompositeData " + openValue);
        }
        CompositeData cd = (CompositeData)openValue;
        CompositeType compositeType = cd.getCompositeType();
        String typeName = compositeType.getTypeName();
        try {
            rec = (SpecificRecordBase)Class.forName(typeName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            InvalidObjectException oex = new InvalidObjectException("Invalid object " + openValue);
            oex.addSuppressed(ex);
            throw oex;
        }
        for (Schema.Field field : rec.getSchema().getFields()) {
            Object obj = cd.get(field.name());
            try {
                rec.put(field.pos(), this.typeMapper.get(SpecificRecordOpenTypeMapping.getGenericType(field.schema())).fromOpenValue(obj));
            }
            catch (NotSerializableException ex) {
                InvalidObjectException tex = new InvalidObjectException("Ivalid Object " + obj + " id " + cd);
                tex.addSuppressed(ex);
                throw tex;
            }
        }
        return rec;
    }

    private static <K, V> TypeToken<Map<K, V>> mapToken(TypeToken<K> keyToken, TypeToken<V> valueToken) {
        return new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyToken).where(new TypeParameter<V>(){}, valueToken);
    }

    private static <T> TypeToken<List<T>> listToken(TypeToken<T> valToken) {
        return new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, valToken);
    }

    public static Type getGenericType(Schema schema) {
        Schema.Type type = schema.getType();
        switch (type) {
            case ARRAY: {
                Type elementType = SpecificRecordOpenTypeMapping.getGenericType(schema.getElementType());
                return SpecificRecordOpenTypeMapping.listToken(TypeToken.of((Type)elementType)).getType();
            }
            case MAP: {
                Type valueType = SpecificRecordOpenTypeMapping.getGenericType(schema.getValueType());
                return SpecificRecordOpenTypeMapping.mapToken(TypeToken.of(String.class), TypeToken.of((Type)valueType)).getType();
            }
            case UNION: {
                List types = schema.getTypes();
                if (types.size() == 2 && types.contains(NULL_SCHEMA)) {
                    return Reflections.primitiveToWrapper(SpecificRecordOpenTypeMapping.getGenericType((Schema)types.get(((Schema)types.get(0)).equals((Object)NULL_SCHEMA) ? 1 : 0)));
                }
                throw new IllegalArgumentException("Schema " + schema + "Cannot be mapped to an OpenType duw to multibranch union");
            }
        }
        return SpecificData.get().getClass(schema);
    }

    @Override
    public Object toOpenValue(Object javaValue) throws OpenDataException {
        SpecificRecordBase sr = (SpecificRecordBase)javaValue;
        return this.fromSpecificRecord(sr);
    }

    private CompositeData fromSpecificRecord(SpecificRecordBase r) throws OpenDataException {
        CompositeType ctype;
        try {
            ctype = SpecificRecordOpenTypeMapping.typeFromSpecificRecord(r, this.typeMapper);
        }
        catch (NotSerializableException ex) {
            throw new UncheckedIOException(ex);
        }
        Schema schema = r.getSchema();
        List fields = schema.getFields();
        int size = fields.size();
        String[] names = new String[size];
        Object[] values = new Object[size];
        for (Schema.Field field : fields) {
            JMXBeanMapping mapping;
            int pos = field.pos();
            names[pos] = field.name();
            Object val = r.get(pos);
            try {
                mapping = this.typeMapper.get(SpecificRecordOpenTypeMapping.getGenericType(field.schema()));
            }
            catch (NotSerializableException ex) {
                throw new UncheckedIOException(ex);
            }
            values[pos] = mapping.toOpenValue(val);
        }
        return new CompositeDataSupport(ctype, names, values);
    }

    private static CompositeType typeFromSpecificRecord(Class<? extends SpecificRecordBase> rc, JMXBeanMappingSupplier typeMapper) throws NotSerializableException {
        try {
            return SpecificRecordOpenTypeMapping.typeFromSpecificRecord(rc.newInstance(), typeMapper);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new UncheckedExecutionException((Throwable)ex);
        }
    }

    private static CompositeType typeFromSpecificRecord(SpecificRecordBase r, JMXBeanMappingSupplier typeMapper) throws NotSerializableException {
        Schema schema = r.getSchema();
        List fields = schema.getFields();
        int size = fields.size();
        String[] names = new String[size];
        String[] descriptions = new String[size];
        OpenType[] types = new OpenType[size];
        for (Schema.Field field : fields) {
            int pos = field.pos();
            names[pos] = field.name();
            descriptions[pos] = field.doc();
            types[pos] = typeMapper.get(SpecificRecordOpenTypeMapping.getGenericType(field.schema())).getOpenType();
        }
        try {
            return new CompositeType(schema.getFullName(), schema.getDoc(), names, descriptions, types);
        }
        catch (OpenDataException ex) {
            throw new UncheckedExecutionException((Throwable)ex);
        }
    }

    @Override
    public Class<?> getMappedType() {
        return this.getOpenClass();
    }

    public String toString() {
        return "SpecificRecordOpenTypeMapping{javaType=" + this.getJavaType() + ", openType=" + this.getOpenType() + '}';
    }
}

