/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.os;

import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Runtime;
import org.spf4j.base.SysExits;
import org.spf4j.os.ProcessHandler;
import org.spf4j.os.ProcessResponse;
import org.spf4j.os.StdOutToStringProcessHandler;
import org.spf4j.unix.Lsof;
import org.spf4j.unix.UnixException;
import org.spf4j.unix.UnixResources;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public final class OperatingSystem {
    private static final long ABORT_TIMEOUT_MILLIS = Long.getLong("spf4j.os.abortTimeoutMillis", 5000L);
    private static final Path FD_FOLDER = Paths.get("/proc/" + Runtime.PID + "/fd", new String[0]);
    private static final java.lang.management.OperatingSystemMXBean OS_MBEAN = ManagementFactory.getOperatingSystemMXBean();
    private static final OperatingSystemMXBean SUN_OS_MBEAN = OS_MBEAN instanceof OperatingSystemMXBean ? (OperatingSystemMXBean)OS_MBEAN : null;
    private static final UnixOperatingSystemMXBean UNIX_OS_MBEAN;
    public static final long MAX_NR_OPENFILES;

    private OperatingSystem() {
    }

    public static java.lang.management.OperatingSystemMXBean getOSMbean() {
        return OS_MBEAN;
    }

    @Nullable
    public static OperatingSystemMXBean getSunJdkOSMBean() {
        return SUN_OS_MBEAN;
    }

    @Nullable
    public static UnixOperatingSystemMXBean getUnixOsMBean() {
        return UNIX_OS_MBEAN;
    }

    public static long getOpenFileDescriptorCount() {
        if (UNIX_OS_MBEAN != null) {
            return UNIX_OS_MBEAN.getOpenFileDescriptorCount();
        }
        try {
            if (Runtime.isMacOsx()) {
                try {
                    return Lsof.getNrOpenFiles();
                }
                catch (ExecutionException | TimeoutException ex) {
                    Lazy.LOG.warn("Unable to get nr of open files", (Throwable)ex);
                    return -1L;
                }
                catch (InterruptedException ex) {
                    Lazy.LOG.warn("Unable to get nr of open files", (Throwable)ex);
                    Thread.currentThread().interrupt();
                    return -1L;
                }
            }
            if (Files.isDirectory(FD_FOLDER, new LinkOption[0])) {
                int result = 0;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(FD_FOLDER);){
                    Iterator<Path> iterator = stream.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        ++result;
                    }
                }
                return result;
            }
            return -1L;
        }
        catch (IOException ex) {
            String msg = ex.getMessage();
            if (msg != null && msg.contains("Too many open files")) {
                return OperatingSystem.getMaxFileDescriptorCount();
            }
            Lazy.LOG.warn("Unable to get nr of open files", (Throwable)ex);
            return -1L;
        }
    }

    public static long getMaxFileDescriptorCount() {
        return MAX_NR_OPENFILES;
    }

    public static int killProcess(Process proc, long terminateTimeoutMillis, long forceTerminateTimeoutMillis) throws InterruptedException {
        proc.destroy();
        if (proc.waitFor(terminateTimeoutMillis, TimeUnit.MILLISECONDS)) {
            return proc.exitValue();
        }
        proc.destroyForcibly();
        if (!proc.waitFor(forceTerminateTimeoutMillis, TimeUnit.MILLISECONDS)) {
            throw new UncheckedTimeoutException("Cannot terminate " + proc);
        }
        return proc.exitValue();
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"COMMAND_INJECTION", "CC_CYCLOMATIC_COMPLEXITY"})
    public static <T, E> ProcessResponse<T, E> forkExec(String[] command, ProcessHandler<T, E> handler, long timeoutMillis, long terminationTimeoutMillis) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String forkExec(String[] command, long timeoutMillis) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        ProcessResponse<String, String> resp = OperatingSystem.forkExec(command, new StdOutToStringProcessHandler(), timeoutMillis, 60000L);
        if (resp.getResponseExitCode() != SysExits.OK) {
            throw new ExecutionException("Failed to execute " + Arrays.toString(command) + ", returned" + resp.getResponseCode() + ", stderr = " + resp.getErrOutput(), null);
        }
        return resp.getOutput();
    }

    private static /* synthetic */ Object lambda$forkExec$1(ProcessHandler handler, InputStream pos) throws Exception {
        return handler.handleStdOut(pos);
    }

    private static /* synthetic */ Object lambda$forkExec$0(ProcessHandler handler, InputStream pes) throws Exception {
        return handler.handleStdErr(pes);
    }

    static {
        if (OS_MBEAN instanceof UnixOperatingSystemMXBean) {
            UNIX_OS_MBEAN = (UnixOperatingSystemMXBean)OS_MBEAN;
            MAX_NR_OPENFILES = UNIX_OS_MBEAN.getMaxFileDescriptorCount();
        } else {
            UNIX_OS_MBEAN = null;
            if (Runtime.isWindows()) {
                MAX_NR_OPENFILES = Integer.MAX_VALUE;
            } else if (Runtime.haveJnaPlatformClib()) {
                try {
                    MAX_NR_OPENFILES = UnixResources.RLIMIT_NOFILE.getSoftLimit();
                }
                catch (UnixException ex) {
                    throw new ExceptionInInitializerError(ex);
                }
            } else {
                MAX_NR_OPENFILES = Integer.MAX_VALUE;
            }
        }
    }

    private static final class Lazy {
        private static final Logger LOG = LoggerFactory.getLogger(Lazy.class);

        private Lazy() {
        }
    }
}

