/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

@Immutable
public interface MeasurementsInfo {
    @Nonnull
    public Object getMeasuredEntity();

    @Nonnull
    public String getDescription();

    public String[] getMeasurementNames();

    public String[] getMeasurementUnits();

    public String getMeasurementName(int var1);

    public String getMeasurementUnit(int var1);

    public int getNumberOfMeasurements();

    default public CompositeType toCompositeType() {
        OpenType[] types = new OpenType[this.getNumberOfMeasurements()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = SimpleType.LONG;
        }
        try {
            String entityName = this.getMeasuredEntity().toString();
            String description = this.getDescription();
            if (description.isEmpty()) {
                description = entityName;
            }
            return new CompositeType(entityName, description, this.getMeasurementNames(), this.getMeasurementUnits(), types);
        }
        catch (OpenDataException ex) {
            throw new IllegalArgumentException("Cannot convert to composite data " + this, ex);
        }
    }
}

