/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.cpu;

import com.sun.management.OperatingSystemMXBean;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.os.OperatingSystem;
import org.spf4j.perf.MeasurementRecorder;
import org.spf4j.perf.impl.RecorderFactory;

@SuppressFBWarnings(value={"IICU_INCORRECT_INTERNAL_CLASS_USE"})
public final class CpuUsageSampler {
    private static ScheduledFuture<?> samplingFuture;

    private CpuUsageSampler() {
    }

    public static long getProcessCpuTimeNanos() {
        OperatingSystemMXBean sunJdkOSMBean = OperatingSystem.getSunJdkOSMBean();
        if (sunJdkOSMBean != null) {
            return sunJdkOSMBean.getProcessCpuTime();
        }
        return -1L;
    }

    @JmxExport
    public static synchronized void start(@JmxExport(value="sampleTimeMillis") int sampleTime) {
        if (samplingFuture != null) {
            throw new IllegalStateException("Cpu time Sampling already started " + samplingFuture);
        }
        final MeasurementRecorder cpuUsage = RecorderFactory.createDirectRecorder("cpu-time", "ns", sampleTime);
        samplingFuture = DefaultScheduler.INSTANCE.scheduleWithFixedDelay(new AbstractRunnable(){
            private long lastValue = 0L;

            @Override
            public void doRun() {
                long currTime = CpuUsageSampler.getProcessCpuTimeNanos();
                cpuUsage.record(currTime - this.lastValue);
                this.lastValue = currTime;
            }
        }, sampleTime, sampleTime, TimeUnit.MILLISECONDS);
    }

    @JmxExport
    public static synchronized void stop() {
        if (samplingFuture != null) {
            samplingFuture.cancel(false);
            samplingFuture = null;
        }
    }

    @JmxExport
    public static synchronized boolean isStarted() {
        return samplingFuture != null;
    }

    static {
        Registry.export(CpuUsageSampler.class);
        if (OperatingSystem.getSunJdkOSMBean() != null) {
            Runtime.queueHook(2, new AbstractRunnable(true){

                @Override
                public void doRun() {
                    CpuUsageSampler.stop();
                }
            });
        }
    }
}

