/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.perf.MeasurementRecorder;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.impl.MeasurementsInfoImpl;

public final class DirectStoreAccumulator
implements MeasurementRecorder,
Closeable {
    private static final String[] MEASUREMENTS = new String[]{"value"};
    private final MeasurementsInfo info;
    private final MeasurementStore measurementStore;
    private final long tableId;
    private volatile long lastRecordedTS;
    private volatile long lastRecordedValue;

    public DirectStoreAccumulator(Object measuredEntity, String description, String unitOfMeasurement, int sampleTimeMillis, MeasurementStore measurementStore) {
        this.info = new MeasurementsInfoImpl(measuredEntity, description, MEASUREMENTS, new String[]{unitOfMeasurement});
        this.measurementStore = measurementStore;
        try {
            this.tableId = measurementStore.alocateMeasurements(this.info, sampleTimeMillis);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @JmxExport
    public String getUnitOfMeasurement() {
        return this.info.getMeasurementUnit(0);
    }

    @Override
    public void record(long measurement) {
        this.recordAt(System.currentTimeMillis(), measurement);
    }

    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
    public synchronized void recordAt(long timestampMillis, long measurement) {
        this.lastRecordedValue = measurement;
        this.lastRecordedTS = timestampMillis;
        try {
            this.measurementStore.saveMeasurements(this.tableId, timestampMillis, measurement);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void registerJmx() {
        Registry.export("org.spf4j.perf.recorders", this.info.getMeasuredEntity().toString(), this);
    }

    @Override
    public void close() {
        Registry.unregister("org.spf4j.perf.recorders", this.info.getMeasuredEntity().toString());
    }

    @JmxExport(description="Last recorded value")
    public RecordedValue getLastRecorded() {
        return new RecordedValue(this.lastRecordedTS, this.lastRecordedValue);
    }

    @JmxExport
    @SuppressFBWarnings(value={"SPP_NON_USEFUL_TOSTRING"})
    public String getInfo() {
        return this.info.toString();
    }

    public String toString() {
        return "DirectStoreAccumulator{info=" + this.info + ", measurementStore=" + this.measurementStore + ", tableId=" + this.tableId + ", lastRecordedTS=" + this.lastRecordedTS + ", lastRecordedValue=" + this.lastRecordedValue + '}';
    }

    public static final class RecordedValue {
        private final long ts;
        private final long value;

        @ConstructorProperties(value={"ts", "value"})
        public RecordedValue(long ts, long value) {
            this.ts = ts;
            this.value = value;
        }

        public long getTs() {
            return this.ts;
        }

        public long getValue() {
            return this.value;
        }
    }
}

