/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.MultiMeasurementRecorder;

@SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"})
public final class DirectStoreMultiAccumulator
implements MultiMeasurementRecorder,
Closeable {
    private final MeasurementsInfo info;
    private final MeasurementStore measurementStore;
    private final long tableId;
    private volatile long[] lastRecorded;

    public DirectStoreMultiAccumulator(MeasurementsInfo info, MeasurementStore measurementStore) {
        try {
            this.info = info;
            this.measurementStore = measurementStore;
            this.tableId = measurementStore.alocateMeasurements(info, 0);
            this.lastRecorded = org.spf4j.base.Arrays.EMPTY_LONG_ARRAY;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void record(long ... measurement) {
        this.recordAt(System.currentTimeMillis(), measurement);
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
    public void recordAt(long timestampMillis, long ... measurement) {
        try {
            this.measurementStore.saveMeasurements(this.tableId, timestampMillis, measurement);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        finally {
            this.lastRecorded = measurement;
        }
    }

    public void registerJmx() {
        Registry.export("org.spf4j.perf.recorders", this.info.getMeasuredEntity().toString(), this);
    }

    @JmxExport
    public long[] getLastRecorded() {
        return (long[])this.lastRecorded.clone();
    }

    @JmxExport
    public String getInfo() {
        return this.info.toString();
    }

    @Override
    public void close() {
        Registry.unregister("org.spf4j.perf.recorders", this.info.getMeasuredEntity().toString());
    }

    public String toString() {
        return "DirectStoreMultiAccumulator{info=" + this.info + ", measurementStore=" + this.measurementStore + ", tableId=" + this.tableId + ", lastRecorded=" + Arrays.toString(this.lastRecorded) + '}';
    }
}

