/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.math.LongMath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.perf.MeasurementAccumulator;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.impl.AbstractMeasurementAccumulator;
import org.spf4j.perf.impl.MeasurementsInfoImpl;

@ParametersAreNonnullByDefault
@ThreadSafe
public final class QuantizedAccumulator
extends AbstractMeasurementAccumulator {
    private long minMeasurement;
    private long maxMeasurement;
    private long measurementCount;
    private long measurementTotal;
    private final int quantasPerMagnitude;
    private final long[] bucketLimits;
    private final MeasurementsInfo info;
    private final int factor;
    private final int lowerMagnitude;
    private final int higherMagnitude;
    private final long[] quatizedMeasurements;

    public QuantizedAccumulator(Object measuredEntity, String description, String unitOfMeasurement, int factor, int lowerMagnitude, int higherMagnitude, int quantasPerMagnitude) {
        assert (quantasPerMagnitude <= factor);
        assert (lowerMagnitude < higherMagnitude);
        assert (quantasPerMagnitude > 0);
        this.factor = factor;
        this.lowerMagnitude = lowerMagnitude;
        this.higherMagnitude = higherMagnitude;
        this.minMeasurement = Long.MAX_VALUE;
        this.maxMeasurement = Long.MIN_VALUE;
        this.measurementCount = 0L;
        this.measurementTotal = 0L;
        this.quantasPerMagnitude = quantasPerMagnitude;
        long[] magnitudes = QuantizedAccumulator.createMagnitudeLimits2(factor, lowerMagnitude, higherMagnitude);
        int qm1 = quantasPerMagnitude - 1;
        int l = (magnitudes.length - 1) * qm1 + 2;
        if (lowerMagnitude < 0) {
            l += 2;
        } else if (lowerMagnitude == 0) {
            ++l;
        }
        this.quatizedMeasurements = new long[l];
        this.bucketLimits = new long[l - 1];
        int nrm = l + 4;
        String[] uom = new String[nrm];
        String[] result = new String[nrm];
        int m = 0;
        result[m] = "total";
        uom[m] = unitOfMeasurement;
        result[++m] = "count";
        uom[m] = "count";
        result[++m] = "min";
        uom[m] = unitOfMeasurement;
        result[++m] = "max";
        uom[m] = unitOfMeasurement;
        long lm = magnitudes[0];
        result[++m] = "QNI_" + lm;
        uom[m] = "count";
        ++m;
        this.bucketLimits[0] = lm;
        if (magnitudes.length > 0) {
            int k = 1;
            long prevVal = lm;
            StringBuilder sb = new StringBuilder(16);
            for (int i = 1; i < magnitudes.length; ++i) {
                int j;
                long pval;
                int nrQ;
                long qsize;
                long magVal = magnitudes[i];
                if (prevVal < 0L) {
                    qsize = -prevVal / (long)quantasPerMagnitude;
                    nrQ = magVal == 0L ? quantasPerMagnitude : qm1;
                    pval = prevVal;
                    for (j = 0; j < nrQ - 1; ++j) {
                        sb.setLength(0);
                        sb.append('Q').append(pval).append('_');
                        sb.append(pval += qsize);
                        result[m] = sb.toString();
                        uom[m] = "count";
                        ++m;
                        this.bucketLimits[k++] = pval;
                    }
                    sb.setLength(0);
                    sb.append('Q').append(pval).append('_');
                    pval += magVal - pval;
                    sb.append(pval);
                    result[m] = sb.toString();
                    uom[m] = "count";
                    ++m;
                    this.bucketLimits[k++] = pval;
                } else {
                    qsize = magVal / (long)quantasPerMagnitude;
                    nrQ = prevVal == 0L ? quantasPerMagnitude : qm1;
                    pval = prevVal;
                    sb.setLength(0);
                    sb.append('Q').append(pval).append('_');
                    sb.append(pval += qsize + (pval == 0L ? 0L : qsize - pval));
                    result[m] = sb.toString();
                    uom[m] = "count";
                    ++m;
                    this.bucketLimits[k++] = pval;
                    for (j = 0; j < nrQ - 1; ++j) {
                        sb.setLength(0);
                        sb.append('Q').append(pval).append('_');
                        sb.append(pval += qsize);
                        result[m] = sb.toString();
                        uom[m] = "count";
                        ++m;
                        this.bucketLimits[k++] = pval;
                    }
                }
                prevVal = magVal;
            }
            sb.setLength(0);
            result[m] = sb.append('Q').append(prevVal).append("_PI").toString();
            uom[m] = "count";
        }
        this.info = new MeasurementsInfoImpl(measuredEntity, description, result, uom);
    }

    static long[] createMagnitudeLimits2(int factor, int lowerMagnitude, int higherMagnitude) {
        int j;
        long[] magnitudes = new long[higherMagnitude - lowerMagnitude + 1];
        int idx = 0;
        if (lowerMagnitude < 0) {
            int toMagnitude = Math.min(-1, higherMagnitude);
            long toValue = -LongMath.pow((long)factor, (int)(-toMagnitude));
            j = idx = toMagnitude - lowerMagnitude;
            while (j >= 0) {
                magnitudes[j--] = toValue;
                toValue *= (long)factor;
            }
            ++idx;
        }
        if (lowerMagnitude <= 0 && higherMagnitude >= 0) {
            magnitudes[idx++] = 0L;
        }
        int fromMagnitude = Math.max(1, lowerMagnitude);
        long fromValue = LongMath.pow((long)factor, (int)fromMagnitude);
        j = idx;
        while (j < magnitudes.length) {
            magnitudes[j++] = fromValue;
            fromValue *= (long)factor;
        }
        return magnitudes;
    }

    private QuantizedAccumulator(MeasurementsInfo info, int factor, int lowerMagnitude, int higherMagnitude, long minMeasurement, long maxMeasurement, long measurementCount, long measurementTotal, int quantasPerMagnitude, long[] bucketLimits, long[] quatizedMeasurements) {
        assert (quantasPerMagnitude <= factor);
        assert (lowerMagnitude < higherMagnitude);
        assert (quantasPerMagnitude > 0);
        this.factor = factor;
        this.lowerMagnitude = lowerMagnitude;
        this.higherMagnitude = higherMagnitude;
        this.minMeasurement = minMeasurement;
        this.maxMeasurement = maxMeasurement;
        this.measurementCount = measurementCount;
        this.measurementTotal = measurementTotal;
        this.quantasPerMagnitude = quantasPerMagnitude;
        this.bucketLimits = bucketLimits;
        this.quatizedMeasurements = quatizedMeasurements;
        this.info = info;
    }

    public String getUnitOfMeasurement() {
        return this.info.getMeasurementUnit(0);
    }

    @VisibleForTesting
    static int findBucket(long[] bucketLimits, long value) {
        int idx = Arrays.binarySearch(bucketLimits, value);
        if (idx >= 0) {
            return idx + 1;
        }
        return -(idx + 1);
    }

    @Override
    public synchronized void record(long measurement) {
        ++this.measurementCount;
        this.measurementTotal += measurement;
        if (measurement < this.minMeasurement) {
            this.minMeasurement = measurement;
        }
        if (measurement > this.maxMeasurement) {
            this.maxMeasurement = measurement;
        }
        int n = QuantizedAccumulator.findBucket(this.bucketLimits, measurement);
        this.quatizedMeasurements[n] = this.quatizedMeasurements[n] + 1L;
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public synchronized long[] get() {
        if (this.measurementCount == 0L) {
            return null;
        }
        long[] result = new long[this.info.getNumberOfMeasurements()];
        int i = 0;
        result[i++] = this.measurementTotal;
        result[i++] = this.measurementCount;
        result[i++] = this.minMeasurement;
        result[i++] = this.maxMeasurement;
        for (int j = 0; j < this.quatizedMeasurements.length; ++j) {
            result[i++] = this.quatizedMeasurements[j];
        }
        return result;
    }

    @Override
    public MeasurementsInfo getInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NOS_NON_OWNED_SYNCHRONIZATION"})
    public MeasurementAccumulator aggregate(MeasurementAccumulator mSource) {
        if (mSource instanceof QuantizedAccumulator) {
            long measurementTotalM;
            long measurementCountM;
            long maxMeasurementM;
            long minMeasurementM;
            long[] quantizedM;
            QuantizedAccumulator other = (QuantizedAccumulator)mSource;
            QuantizedAccumulator quantizedAccumulator = this;
            synchronized (quantizedAccumulator) {
                quantizedM = (long[])this.quatizedMeasurements.clone();
                minMeasurementM = this.minMeasurement;
                maxMeasurementM = this.maxMeasurement;
                measurementCountM = this.measurementCount;
                measurementTotalM = this.measurementTotal;
            }
            QuantizedAccumulator otherClone = other.createClone();
            long[] lQuatizedMeas = otherClone.getQuatizedMeasurements();
            for (int i = 0; i < quantizedM.length; ++i) {
                int n = i;
                quantizedM[n] = quantizedM[n] + lQuatizedMeas[i];
            }
            return new QuantizedAccumulator(this.info, this.factor, this.lowerMagnitude, this.higherMagnitude, Math.min(minMeasurementM, otherClone.getMinMeasurement()), Math.max(maxMeasurementM, otherClone.getMaxMeasurement()), measurementCountM + otherClone.getMeasurementCount(), measurementTotalM + otherClone.getMeasurementTotal(), this.quantasPerMagnitude, this.bucketLimits, quantizedM);
        }
        throw new IllegalArgumentException("Cannot aggregate " + this + " with " + mSource);
    }

    @Override
    public synchronized QuantizedAccumulator createClone() {
        return new QuantizedAccumulator(this.info, this.factor, this.lowerMagnitude, this.higherMagnitude, this.minMeasurement, this.maxMeasurement, this.measurementCount, this.measurementTotal, this.quantasPerMagnitude, this.bucketLimits, (long[])this.quatizedMeasurements.clone());
    }

    @Override
    public synchronized QuantizedAccumulator reset() {
        if (this.measurementCount == 0L) {
            return null;
        }
        QuantizedAccumulator result = this.createClone();
        this.minMeasurement = Long.MAX_VALUE;
        this.maxMeasurement = Long.MIN_VALUE;
        this.measurementCount = 0L;
        this.measurementTotal = 0L;
        Arrays.fill(this.quatizedMeasurements, 0L);
        return result;
    }

    public synchronized String toString() {
        return "QuantizedRecorder{info=" + this.info + ", minMeasurement=" + this.minMeasurement + ", maxMeasurement=" + this.maxMeasurement + ", measurementCount=" + this.measurementCount + ", measurementTotal=" + this.measurementTotal + ", quantasPerMagnitude=" + this.quantasPerMagnitude + ", magnitudes=" + Arrays.toString(this.bucketLimits) + ", quatizedMeasurements=" + Arrays.toString(this.quatizedMeasurements) + '}';
    }

    public synchronized long getMaxMeasurement() {
        return this.maxMeasurement;
    }

    public synchronized long getMeasurementCount() {
        return this.measurementCount;
    }

    public synchronized long getMeasurementTotal() {
        return this.measurementTotal;
    }

    public synchronized long getMinMeasurement() {
        return this.minMeasurement;
    }

    public synchronized long[] getQuatizedMeasurements() {
        return (long[])this.quatizedMeasurements.clone();
    }

    @Override
    public synchronized MeasurementAccumulator createLike(Object entity) {
        return new QuantizedAccumulator(entity, this.info.getDescription(), this.getUnitOfMeasurement(), this.factor, this.lowerMagnitude, this.higherMagnitude, this.quantasPerMagnitude);
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public long[] getThenReset() {
        QuantizedAccumulator vals = this.reset();
        if (vals == null) {
            return null;
        }
        return vals.get();
    }
}

