/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.CharSequences;
import org.spf4j.io.Csv;
import org.spf4j.io.csv.CsvParseException;
import org.spf4j.perf.MeasurementRecorder;
import org.spf4j.perf.MeasurementRecorderSource;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MultiMeasurementRecorder;
import org.spf4j.perf.impl.CountingAccumulator;
import org.spf4j.perf.impl.DirectRecorderSource;
import org.spf4j.perf.impl.DirectStoreAccumulator;
import org.spf4j.perf.impl.DirectStoreMultiAccumulator;
import org.spf4j.perf.impl.MeasurementsInfoImpl;
import org.spf4j.perf.impl.MinMaxAvgAccumulator;
import org.spf4j.perf.impl.NopMeasurementStore;
import org.spf4j.perf.impl.QuantizedAccumulator;
import org.spf4j.perf.impl.ScalableMeasurementRecorder;
import org.spf4j.perf.impl.ScalableMeasurementRecorderSource;
import org.spf4j.perf.impl.ms.Flusher;
import org.spf4j.perf.impl.ms.MultiStore;
import org.spf4j.perf.impl.ms.StoreType;
import org.spf4j.perf.impl.ms.graphite.GraphiteTcpStore;
import org.spf4j.perf.impl.ms.graphite.GraphiteUdpStore;
import org.spf4j.perf.impl.ms.tsdb.TSDBMeasurementStore;
import org.spf4j.recyclable.ObjectCreationException;

public final class RecorderFactory {
    private static final Logger LOG;
    public static final MeasurementStore MEASUREMENT_STORE;

    private RecorderFactory() {
    }

    public static MeasurementStore getMeasurementStore() {
        return MEASUREMENT_STORE;
    }

    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    private static MeasurementStore buildStoreFromConfig(@Nullable String configuration) throws IOException, ObjectCreationException {
        List<String> stores;
        if (configuration == null || configuration.trim().isEmpty()) {
            return new TSDBMeasurementStore(new File(System.getProperty("spf4j.perf.ms.defaultTsdbFolderPath", System.getProperty("java.io.tmpdir")) + File.separator + CharSequences.validatedFileName(System.getProperty("spf4j.perf.ms.defaultTsdbFileNamePrefix", ManagementFactory.getRuntimeMXBean().getName() + ".tsdb2"))));
        }
        try {
            stores = Csv.readRow(new StringReader(configuration));
        }
        catch (CsvParseException ex) {
            throw new IllegalArgumentException("Invalid configuration " + configuration, ex);
        }
        int size = stores.size();
        if (size == 1) {
            return RecorderFactory.fromString(stores.get(0));
        }
        MeasurementStore[] mstores = new MeasurementStore[size];
        int i = 0;
        for (String config : stores) {
            mstores[i] = RecorderFactory.fromString(config);
            ++i;
        }
        return new MultiStore(mstores);
    }

    public static MeasurementStore fromString(String string) throws IOException, ObjectCreationException {
        int atIdx = string.indexOf(64);
        int length = string.length();
        if (atIdx < 0) {
            atIdx = length;
        }
        StoreType type = StoreType.valueOf(string.substring(0, atIdx));
        if (atIdx >= length) {
            return type.create("");
        }
        return type.create(string.substring(atIdx + 1));
    }

    public static MeasurementRecorder createScalableQuantizedRecorder(Object forWhat, String unitOfMeasurement, int sampleTimeMillis, int factor, int lowerMagnitude, int higherMagnitude, int quantasPerMagnitude) {
        ScalableMeasurementRecorder mr = new ScalableMeasurementRecorder(new QuantizedAccumulator(forWhat, "", unitOfMeasurement, factor, lowerMagnitude, higherMagnitude, quantasPerMagnitude), sampleTimeMillis, MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createScalableCountingRecorder(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        ScalableMeasurementRecorder mr = new ScalableMeasurementRecorder(new CountingAccumulator(forWhat, "", unitOfMeasurement), sampleTimeMillis, MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createScalableMinMaxAvgRecorder(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        ScalableMeasurementRecorder mr = new ScalableMeasurementRecorder(new MinMaxAvgAccumulator(forWhat, "", unitOfMeasurement), sampleTimeMillis, MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorderSource createScalableQuantizedRecorderSource(Object forWhat, String unitOfMeasurement, int sampleTimeMillis, int factor, int lowerMagnitude, int higherMagnitude, int quantasPerMagnitude) {
        ScalableMeasurementRecorderSource mrs = new ScalableMeasurementRecorderSource(new QuantizedAccumulator(forWhat, "", unitOfMeasurement, factor, lowerMagnitude, higherMagnitude, quantasPerMagnitude), sampleTimeMillis, MEASUREMENT_STORE);
        mrs.registerJmx();
        return mrs;
    }

    public static MeasurementRecorderSource createScalableCountingRecorderSource(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        ScalableMeasurementRecorderSource mrs = new ScalableMeasurementRecorderSource(new CountingAccumulator(forWhat, "", unitOfMeasurement), sampleTimeMillis, MEASUREMENT_STORE);
        mrs.registerJmx();
        return mrs;
    }

    public static MeasurementRecorderSource createScalableMinMaxAvgRecorderSource(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        ScalableMeasurementRecorderSource mrs = new ScalableMeasurementRecorderSource(new MinMaxAvgAccumulator(forWhat, "", unitOfMeasurement), sampleTimeMillis, MEASUREMENT_STORE);
        mrs.registerJmx();
        return mrs;
    }

    public static MultiMeasurementRecorder createDirectRecorder(Object measuredEntity, String description, String[] measurementNames, String[] measurementUnits) {
        DirectStoreMultiAccumulator mr = new DirectStoreMultiAccumulator(new MeasurementsInfoImpl(measuredEntity, description, measurementNames, measurementUnits), MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createDirectRecorder(Object forWhat, String unitOfMeasurement) {
        DirectStoreAccumulator mr = new DirectStoreAccumulator(forWhat, "", unitOfMeasurement, 0, MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createDirectRecorder(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        DirectStoreAccumulator mr = new DirectStoreAccumulator(forWhat, "", unitOfMeasurement, sampleTimeMillis, MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorderSource createDirectRecorderSource(Object forWhat, String unitOfMeasurement) {
        return new DirectRecorderSource(forWhat, "", unitOfMeasurement, 0, MEASUREMENT_STORE);
    }

    public static MeasurementRecorder createDirectGraphiteUdpRecorder(Object forWhat, String unitOfMeasurement, String graphiteHost, int graphitePort) throws ObjectCreationException {
        DirectStoreAccumulator mr = new DirectStoreAccumulator(forWhat, "", unitOfMeasurement, 0, new GraphiteUdpStore(graphiteHost, graphitePort));
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createDirectGraphiteTcpRecorder(Object forWhat, String unitOfMeasurement, String graphiteHost, int graphitePort) throws ObjectCreationException {
        DirectStoreAccumulator mr = new DirectStoreAccumulator(forWhat, "", unitOfMeasurement, 0, new GraphiteTcpStore(graphiteHost, graphitePort));
        mr.registerJmx();
        return mr;
    }

    static {
        MeasurementStore mStore;
        LOG = LoggerFactory.getLogger(RecorderFactory.class);
        try {
            mStore = RecorderFactory.buildStoreFromConfig(System.getProperty("spf4j.perf.ms.config", null));
        }
        catch (IOException | ObjectCreationException ex) {
            LOG.error("Cannot initialize measurement store, installing NOP store", (Throwable)ex);
            mStore = new NopMeasurementStore();
        }
        if (!(mStore instanceof NopMeasurementStore)) {
            Flusher.flushEvery(Integer.getInteger("spf4j.perf.ms.flushIntervalMillis", 60000), mStore);
        }
        MEASUREMENT_STORE = mStore;
    }
}

