/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.ms;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.spf4j.jmx.Registry;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.impl.NopMeasurementStore;
import org.spf4j.perf.impl.ms.StoreFactory;
import org.spf4j.perf.impl.ms.graphite.GraphiteTcpStore;
import org.spf4j.perf.impl.ms.graphite.GraphiteUdpStore;
import org.spf4j.perf.impl.ms.tsdb.TSDBMeasurementStore;
import org.spf4j.perf.impl.ms.tsdb.TSDBTxtMeasurementStore;
import org.spf4j.recyclable.ObjectCreationException;

public enum StoreType {
    TSDB(new StoreFactory(){

        @Override
        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
        public MeasurementStore create(String pconfig) throws IOException {
            String config = !pconfig.endsWith("tsdb2") ? pconfig + ".tsdb2" : pconfig;
            return new TSDBMeasurementStore(new File(config));
        }
    }),
    TSDB_TXT(new StoreFactory(){

        @Override
        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
        public MeasurementStore create(String config) throws IOException {
            return new TSDBTxtMeasurementStore(new File(config));
        }
    }),
    GRAPHITE_UDP(new StoreFactory(){

        @Override
        public MeasurementStore create(String config) throws ObjectCreationException {
            try {
                return new GraphiteUdpStore(config);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("Invalid configuration " + config, ex);
            }
        }
    }),
    GRAPHITE_TCP(new StoreFactory(){

        @Override
        public MeasurementStore create(String config) throws ObjectCreationException {
            try {
                return new GraphiteTcpStore(config);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("Invalid configuration " + config, ex);
            }
        }
    }),
    NOP_STORE(new StoreFactory(){

        @Override
        public MeasurementStore create(String config) {
            return new NopMeasurementStore();
        }
    });

    private final StoreFactory factory;

    private StoreType(StoreFactory factory) {
        this.factory = factory;
    }

    public MeasurementStore create(String configuration) throws IOException, ObjectCreationException {
        MeasurementStore store = this.factory.create(configuration);
        Registry.export(store.getClass().getName(), store.toString(), store);
        return store;
    }
}

