/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.ms.graphite;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.TimeoutException;
import org.spf4j.base.Handler;
import org.spf4j.base.Strings;
import org.spf4j.io.ByteArrayBuilder;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.impl.ms.Id2Info;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.Template;
import org.spf4j.recyclable.impl.RecyclingSupplierBuilder;

public final class GraphiteUdpStore
implements MeasurementStore {
    public static final int MAX_UDP_MSG_SIZE = 512;
    private final RecyclingSupplier<DatagramChannel> datagramChannelSupplier;
    private final InetSocketAddress address;

    public GraphiteUdpStore(String hostPort) throws ObjectCreationException, URISyntaxException {
        this(new URI("graphiteUdp://" + hostPort));
    }

    public GraphiteUdpStore(URI uri) throws ObjectCreationException {
        this(uri.getHost(), uri.getPort());
    }

    public GraphiteUdpStore(String hostName, int port) throws ObjectCreationException {
        this.address = new InetSocketAddress(hostName, port);
        this.datagramChannelSupplier = new RecyclingSupplierBuilder<DatagramChannel>(1, new DatagramChannelSupplierFactory(this.address)).build();
    }

    @Override
    public void flush() {
    }

    @Override
    public long alocateMeasurements(MeasurementsInfo measurement, int sampleTimeMillis) {
        return Id2Info.getId(measurement);
    }

    @Override
    @SuppressFBWarnings(value={"BED_BOGUS_EXCEPTION_DECLARATION"})
    public void saveMeasurements(long tableId, long timeStampMillis, long ... measurements) throws IOException {
        try {
            Template.doOnSupplied(new HandlerImpl(measurements, Id2Info.getInfo(tableId), timeStampMillis), this.datagramChannelSupplier, 3, 1000, 60000, IOException.class);
        }
        catch (TimeoutException ex) {
            throw new UncheckedTimeoutException((Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public static void writeMetric(MeasurementsInfo measurementInfo, String measurementName, long measurement, long timeStampMillis, Writer os) throws IOException {
        Strings.writeReplaceWhitespaces(measurementInfo.getMeasuredEntity().toString(), '-', os);
        os.append('/');
        Strings.writeReplaceWhitespaces(measurementName, '-', os);
        os.append(' ');
        os.append(Long.toString(measurement));
        os.append(' ');
        os.append(Long.toString(timeStampMillis));
        os.append('\n');
    }

    public String toString() {
        return "GraphiteUdpStore{address=" + this.address + '}';
    }

    @Override
    public void close() {
        try {
            this.datagramChannelSupplier.dispose();
        }
        catch (InterruptedException | ObjectDisposeException ex) {
            throw new UncheckedExecutionException((Throwable)ex);
        }
    }

    private static class HandlerImpl
    implements Handler<DatagramChannel, IOException> {
        private final long[] measurements;
        private final MeasurementsInfo measurementInfo;
        private final long timeStampMillis;

        HandlerImpl(long[] measurements, MeasurementsInfo measurementInfo, long timeStampMillis) {
            this.measurements = measurements;
            this.measurementInfo = measurementInfo;
            this.timeStampMillis = timeStampMillis;
        }

        @Override
        public void handle(DatagramChannel datagramChannel, long deadline) throws IOException {
            try (ByteArrayBuilder bos = new ByteArrayBuilder();
                 OutputStreamWriter os = new OutputStreamWriter((OutputStream)bos, Charsets.UTF_8);){
                int msgStart = 0;
                int msgEnd = 0;
                int prevEnd = 0;
                for (int i = 0; i < this.measurements.length; ++i) {
                    GraphiteUdpStore.writeMetric(this.measurementInfo, this.measurementInfo.getMeasurementName(i), this.measurements[i], this.timeStampMillis, os);
                    os.flush();
                    msgEnd = bos.size();
                    int length = msgEnd - msgStart;
                    if (length > 512) {
                        ByteBuffer byteBuffer = ByteBuffer.wrap(bos.getBuffer(), msgStart, prevEnd - msgStart);
                        datagramChannel.write(byteBuffer);
                        msgStart = prevEnd;
                    }
                    prevEnd = msgEnd;
                }
                if (msgEnd > msgStart) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(bos.getBuffer(), msgStart, msgEnd - msgStart);
                    datagramChannel.write(byteBuffer);
                }
            }
        }
    }

    private static class DatagramChannelSupplierFactory
    implements RecyclingSupplier.Factory<DatagramChannel> {
        private final InetSocketAddress address;

        DatagramChannelSupplierFactory(InetSocketAddress address) {
            this.address = address;
        }

        @Override
        public DatagramChannel create() throws ObjectCreationException {
            DatagramChannel datagramChannel;
            try {
                datagramChannel = DatagramChannel.open();
            }
            catch (IOException ex) {
                throw new ObjectCreationException(ex);
            }
            try {
                datagramChannel.connect(this.address);
                return datagramChannel;
            }
            catch (IOException ex) {
                try {
                    datagramChannel.close();
                }
                catch (IOException ex1) {
                    ex1.addSuppressed(ex);
                    throw new ObjectCreationException(ex1);
                }
                throw new ObjectCreationException(ex);
            }
        }

        @Override
        public void dispose(DatagramChannel object) throws ObjectDisposeException {
            try {
                object.close();
            }
            catch (IOException ex) {
                throw new ObjectDisposeException(ex);
            }
        }

        @Override
        public boolean validate(DatagramChannel object, Exception e) throws Exception {
            return e == null || !(Throwables.getRootCause((Throwable)e) instanceof IOException);
        }
    }
}

