/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.ms.tsdb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.jmx.JmxExport;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.tsdb2.TSDBQuery;
import org.spf4j.tsdb2.TSDBWriter;
import org.spf4j.tsdb2.avro.ColumnDef;
import org.spf4j.tsdb2.avro.TableDef;
import org.spf4j.tsdb2.avro.Type;

@ThreadSafe
public final class TSDBMeasurementStore
implements MeasurementStore {
    private final TSDBWriter database;

    public TSDBMeasurementStore(File databaseFile) throws IOException {
        this.database = new TSDBWriter(databaseFile, 1024, "", false);
    }

    @Override
    public long alocateMeasurements(MeasurementsInfo measurement, int sampleTimeMillis) throws IOException {
        TableDef td = TableDef.newBuilder().setName(measurement.getMeasuredEntity().toString()).setSampleTime(sampleTimeMillis).setId(-1L).build();
        int numberOfMeasurements = measurement.getNumberOfMeasurements();
        ArrayList<ColumnDef> columns = new ArrayList<ColumnDef>(numberOfMeasurements);
        for (int i = 0; i < numberOfMeasurements; ++i) {
            String mname = measurement.getMeasurementName(i);
            String unit = measurement.getMeasurementUnit(i);
            ColumnDef cd = new ColumnDef();
            cd.name = mname;
            cd.unitOfMeasurement = unit;
            cd.type = Type.LONG;
            cd.description = "";
            columns.add(cd);
        }
        td.columns = columns;
        return this.database.writeTableDef(td);
    }

    @Override
    public void saveMeasurements(long tableId, long timeStampMillis, long ... measurements) throws IOException {
        this.database.writeDataRow(tableId, timeStampMillis, measurements);
    }

    @Override
    public void close() throws IOException {
        this.database.close();
    }

    @Override
    @JmxExport(description="flush out buffers")
    public void flush() throws IOException {
        this.database.flush();
    }

    @JmxExport(description="list all tables")
    public String[] getTables() throws IOException {
        Set metrics = TSDBQuery.getAllTables(this.database.getFile()).keySet();
        return metrics.toArray(new String[metrics.size()]);
    }

    @JmxExport(description="getTable As Csv")
    public String getTableAsCsv(@JmxExport(value="tableName") String tableName) throws IOException {
        StringBuilder result = new StringBuilder(1024);
        TSDBQuery.writeAsCsv(result, this.database.getFile(), tableName);
        return result.toString();
    }

    public String toString() {
        return "TSDBMeasurementStore{database=" + this.database + '}';
    }

    public TSDBWriter getDBWriter() {
        return this.database;
    }
}

