/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Runtime;
import org.spf4j.base.SysExits;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.os.OperatingSystem;
import org.spf4j.perf.MeasurementRecorder;
import org.spf4j.perf.impl.RecorderFactory;
import org.spf4j.unix.Lsof;

public final class OpenFilesSampler {
    private static ScheduledFuture<?> samplingFuture;
    private static AccumulatorRunnable accumulator;
    private static final Logger LOG;
    private static volatile CharSequence lastWarnLsof;

    private OpenFilesSampler() {
    }

    public static void start(long sampleTimeMillis) {
        long maxFileDescriptorCount = OperatingSystem.getMaxFileDescriptorCount();
        OpenFilesSampler.start(sampleTimeMillis, maxFileDescriptorCount - maxFileDescriptorCount / 10L, maxFileDescriptorCount, true);
    }

    @JmxExport
    public static void start(@JmxExport(value="sampleTimeMillis") long sampleTimeMillis, @JmxExport(value="shutdownOnError") boolean shutdownOnError) {
        long maxFileDescriptorCount = OperatingSystem.getMaxFileDescriptorCount();
        OpenFilesSampler.start(sampleTimeMillis, maxFileDescriptorCount - maxFileDescriptorCount / 10L, maxFileDescriptorCount, shutdownOnError);
    }

    @JmxExport
    public static String getWarnLsofDetail() {
        return lastWarnLsof.toString();
    }

    public static void start(long sampleTimeMillis, long warnThreshold, long errorThreshold, boolean shutdownOnError) {
        OpenFilesSampler.start(sampleTimeMillis, warnThreshold, errorThreshold, shutdownOnError, (int)sampleTimeMillis * 10);
    }

    public static synchronized void start(long sampleTimeMillis, long warnThreshold, long errorThreshold, boolean shutdownOnError, int aggTimeMillis) {
        if (samplingFuture != null) {
            throw new IllegalStateException("Open file usage sampling already started " + samplingFuture);
        }
        accumulator = new AccumulatorRunnable(errorThreshold, shutdownOnError, warnThreshold, aggTimeMillis);
        samplingFuture = DefaultScheduler.INSTANCE.scheduleWithFixedDelay(accumulator, sampleTimeMillis, sampleTimeMillis, TimeUnit.MILLISECONDS);
    }

    @JmxExport
    public static synchronized void stop() throws IOException {
        if (samplingFuture != null) {
            samplingFuture.cancel(false);
            samplingFuture = null;
            try {
                accumulator.close();
            }
            finally {
                accumulator = null;
            }
        }
    }

    @JmxExport
    public static synchronized boolean isStarted() {
        return samplingFuture != null;
    }

    @JmxExport
    public static String getLsof() {
        CharSequence lsofOutput = Runtime.getLsofOutput();
        return lsofOutput == null ? "unable to obtain lsof" : lsofOutput.toString();
    }

    @Deprecated
    public static long getMaxNrOpenFiles() {
        return OperatingSystem.getMaxFileDescriptorCount();
    }

    @Deprecated
    public static long getNrOpenFiles() {
        return OperatingSystem.getOpenFileDescriptorCount();
    }

    @JmxExport
    public static long getWarnThreshold() {
        if (accumulator == null) {
            return -1L;
        }
        return accumulator.getWarnThreshold();
    }

    @JmxExport
    public static long getErrorThreshold() {
        if (accumulator == null) {
            return -1L;
        }
        return accumulator.getErrorThreshold();
    }

    static {
        LOG = LoggerFactory.getLogger(OpenFilesSampler.class);
        lastWarnLsof = "";
        Runtime.queueHook(2, new AbstractRunnable(true){

            @Override
            public void doRun() throws IOException {
                OpenFilesSampler.stop();
            }
        });
        Registry.export(OpenFilesSampler.class);
    }

    private static class AccumulatorRunnable
    extends AbstractRunnable
    implements Closeable {
        private final long errorThreshold;
        private final boolean shutdownOnError;
        private final long warnThreshold;
        private final MeasurementRecorder nrOpenFiles;

        AccumulatorRunnable(long errorThreshold, boolean shutdownOnError, long warnThreshold, int aggMillis) {
            this.errorThreshold = errorThreshold;
            this.shutdownOnError = shutdownOnError;
            this.warnThreshold = warnThreshold;
            this.nrOpenFiles = RecorderFactory.createScalableMinMaxAvgRecorder("nr-open-files", "count", aggMillis);
        }

        @Override
        @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
        public void doRun() {
            long time = System.currentTimeMillis();
            long nrOf = OperatingSystem.getOpenFileDescriptorCount();
            if (nrOf > this.errorThreshold) {
                lastWarnLsof = Lsof.getLsofOutput();
                LOG.error("Nr open files is {} and exceeds error threshold {}, detail:\n{}", new Object[]{nrOf, this.errorThreshold, lastWarnLsof});
                if (this.shutdownOnError) {
                    Runtime.goDownWithError(null, SysExits.EX_IOERR);
                }
            } else if (nrOf > this.warnThreshold) {
                lastWarnLsof = Lsof.getLsofOutput();
                LOG.warn("Nr open files is {} and exceeds warn threshold {}, detail:\n{} ", new Object[]{nrOf, this.warnThreshold, lastWarnLsof});
                if (!Runtime.gc(60000L)) {
                    LOG.warn("Unable to trigger GC although running low on file resources");
                } else {
                    LOG.warn("gc executed nr open files reduced by {} files", (Object)(nrOf - OperatingSystem.getOpenFileDescriptorCount()));
                }
            }
            this.nrOpenFiles.recordAt(time, nrOf);
        }

        @Override
        public void close() throws IOException {
            this.nrOpenFiles.close();
        }

        public long getErrorThreshold() {
            return this.errorThreshold;
        }

        public boolean isShutdownOnError() {
            return this.shutdownOnError;
        }

        public long getWarnThreshold() {
            return this.warnThreshold;
        }
    }
}

