/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.pool.jdbc;

import com.google.common.annotations.Beta;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;

@Beta
public final class JdbcConnectionFactory
implements RecyclingSupplier.Factory<Connection> {
    private final String url;
    private final String user;
    private final String password;
    private RecyclingSupplier<Connection> pool;

    public JdbcConnectionFactory(String driverName, String url, String user, String password) {
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Invalid driver " + driverName, ex);
        }
        this.url = url;
        this.password = password;
        this.user = user;
    }

    @Override
    public Connection create() throws ObjectCreationException {
        Connection conn;
        try {
            conn = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (SQLException ex) {
            throw new ObjectCreationException(ex);
        }
        return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Connection.class}, new InvocationHandler(){
            private Exception ex;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
                if ("close".equals(method.getName())) {
                    JdbcConnectionFactory.this.pool.recycle((Connection)proxy, this.ex);
                    this.ex = null;
                    return null;
                }
                try {
                    return method.invoke((Object)conn, args);
                }
                catch (IllegalAccessException | RuntimeException | InvocationTargetException e) {
                    this.ex = e;
                    throw e;
                }
            }
        });
    }

    @Override
    public void dispose(Connection object) throws ObjectDisposeException {
        try {
            object.unwrap(Connection.class).close();
        }
        catch (SQLException ex) {
            throw new ObjectDisposeException(ex);
        }
    }

    @Override
    public boolean validate(Connection object, Exception e) throws SQLException {
        return object.isValid(60);
    }

    void setPool(RecyclingSupplier<Connection> pool) {
        this.pool = pool;
    }

    public String toString() {
        return "JdbcConnectionFactory{url=" + this.url + ", user=" + this.user + '}';
    }
}

