/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.pool.jdbc;

import com.google.common.annotations.Beta;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.spf4j.pool.jdbc.JdbcConnectionFactory;
import org.spf4j.recyclable.ObjectBorrowException;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.impl.RecyclingSupplierBuilder;

@Beta
public final class PooledDataSource
implements DataSource,
AutoCloseable {
    private final RecyclingSupplier<Connection> pool;

    public PooledDataSource(int initialSize, int maxSize, String driverName, String url, String user, String password) throws ObjectCreationException {
        JdbcConnectionFactory jdbcConnectionFactory = new JdbcConnectionFactory(driverName, url, user, password);
        RecyclingSupplierBuilder<Connection> builder = new RecyclingSupplierBuilder<Connection>(maxSize, jdbcConnectionFactory);
        builder.withInitialSize(initialSize);
        this.pool = builder.build();
        jdbcConnectionFactory.setPool(this.pool);
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.pool.get();
        }
        catch (InterruptedException | ObjectBorrowException | ObjectCreationException ex) {
            throw new SQLException(ex);
        }
        catch (TimeoutException ex) {
            throw new SQLTimeoutException(ex);
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getLoginTimeout() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.equals(DataSource.class) || iface.equals(PooledDataSource.class)) {
            return (T)this;
        }
        throw new SQLException("Not a wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.equals(DataSource.class) || iface.equals(PooledDataSource.class);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public String toString() {
        return "PooledDataSource{pool=" + this.pool + '}';
    }

    @Override
    public void close() throws Exception {
        this.pool.dispose();
    }
}

