/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable;

import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.TimeoutException;
import org.spf4j.base.Callables;
import org.spf4j.base.Handler;
import org.spf4j.base.Throwables;
import org.spf4j.recyclable.ObjectBorrowException;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.RecyclingSupplier;

public final class Template<T, E extends Exception> {
    private final RecyclingSupplier<T> pool;
    private final int nrImmediateRetries;
    private final int retryWaitMillis;
    private final int timeout;
    private final Class<E> exClass;

    public Template(RecyclingSupplier<T> pool, int nrImmediateRetries, int retryWaitMillis, int timeoutMillis, Class<E> exClass) {
        this.pool = pool;
        this.nrImmediateRetries = nrImmediateRetries;
        this.retryWaitMillis = retryWaitMillis;
        this.timeout = timeoutMillis;
        this.exClass = exClass;
    }

    public void doOnSupplied(Handler<T, E> handler) throws InterruptedException, E, TimeoutException {
        Template.doOnSupplied(handler, this.pool, this.nrImmediateRetries, this.retryWaitMillis, this.timeout, this.exClass);
    }

    public static <T, E extends Exception> void doOnSupplied(final Handler<T, E> handler, final RecyclingSupplier<T> pool, int nrImmediateRetries, int retryWaitMillis, int timeoutMillis, final Class<E> exClass) throws E, InterruptedException, TimeoutException {
        Callables.executeWithRetry(new Callables.TimeoutCallable<Void, E>(timeoutMillis){

            @Override
            public Void call(long deadline) throws InterruptedException, TimeoutException, Exception {
                try {
                    Template.doOnSupplied(handler, pool, deadline, exClass);
                }
                catch (ObjectBorrowException | ObjectCreationException ex) {
                    throw new UncheckedExecutionException((Throwable)ex);
                }
                return null;
            }
        }, nrImmediateRetries, retryWaitMillis, exClass);
    }

    @SuppressFBWarnings(value={"LEST_LOST_EXCEPTION_STACK_TRACE"})
    private static <T, E extends Exception> void doOnSupplied(Handler<T, E> handler, RecyclingSupplier<T> pool, long deadline, Class<E> exClass) throws E, ObjectCreationException, ObjectBorrowException, InterruptedException, TimeoutException {
        T object = pool.get();
        try {
            handler.handle(object, deadline);
        }
        catch (RuntimeException e) {
            try {
                pool.recycle(object, e);
            }
            catch (RuntimeException ex) {
                throw Throwables.suppress(ex, e);
            }
            throw e;
        }
        catch (Exception e) {
            try {
                pool.recycle(object, e);
            }
            catch (RuntimeException ex) {
                throw Throwables.suppress(ex, e);
            }
            if (exClass.isAssignableFrom(e.getClass())) {
                throw e;
            }
            throw new UncheckedExecutionException((Throwable)e);
        }
        pool.recycle(object, null);
    }

    public String toString() {
        return "Template{pool=" + this.pool + ", nrImmediateRetries=" + this.nrImmediateRetries + ", retryWaitMillis=" + this.retryWaitMillis + ", timeout=" + this.timeout + '}';
    }
}

