/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.ds.UpdateablePriorityQueue;
import org.spf4j.recyclable.ObjectBorrowException;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;

public final class SharingObjectPool<T>
implements RecyclingSupplier<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SharingObjectPool.class);
    private static final Comparator<SharedObject<?>> SH_COMP = new Comparator<SharedObject<?>>(){

        @Override
        public int compare(SharedObject<?> o1, SharedObject<?> o2) {
            return ((SharedObject)o1).nrTimesShared - ((SharedObject)o2).nrTimesShared;
        }
    };
    private final RecyclingSupplier.Factory<T> factory;
    private final UpdateablePriorityQueue<SharedObject<T>> pooledObjects;
    private final Map<T, UpdateablePriorityQueue.ElementRef> o2QueueRefMap;
    private int nrObjects;
    private final int maxSize;
    private boolean closed;
    private final boolean asyncValidate;

    public SharingObjectPool(RecyclingSupplier.Factory<T> factory, int coreSize, int maxSize) throws ObjectCreationException {
        this(factory, coreSize, maxSize, false);
    }

    public SharingObjectPool(RecyclingSupplier.Factory<T> factory, int coreSize, int maxSize, boolean asyncValidate) throws ObjectCreationException {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("max size must be greater than zero and not " + maxSize);
        }
        if (maxSize < coreSize) {
            throw new IllegalArgumentException("max size must be greater than core size  and not " + maxSize + " < " + coreSize);
        }
        this.factory = factory;
        this.pooledObjects = new UpdateablePriorityQueue(maxSize, SH_COMP);
        this.nrObjects = 0;
        this.closed = false;
        this.asyncValidate = asyncValidate;
        this.o2QueueRefMap = new IdentityHashMap<T, UpdateablePriorityQueue.ElementRef>(maxSize);
        for (int i = 0; i < coreSize; ++i) {
            this.createObject(0);
        }
        this.maxSize = maxSize;
    }

    @Override
    public synchronized T get() throws ObjectBorrowException, ObjectCreationException {
        if (this.closed) {
            throw new ObjectBorrowException("Reclycler is closed " + this);
        }
        UpdateablePriorityQueue.ElementRef peekEntry = this.pooledObjects.peekEntry();
        if (peekEntry != null) {
            SharedObject elem = (SharedObject)peekEntry.getElem();
            if (elem.getNrTimesShared() == 0) {
                elem.inc();
                peekEntry.elementMutated();
                return elem.getObject();
            }
            if (this.nrObjects < this.maxSize) {
                return this.createObject(1);
            }
            return elem.getObject();
        }
        return this.createObject(1);
    }

    private synchronized T createObject(int nrTimesShared) throws ObjectCreationException {
        T obj = this.factory.create();
        this.o2QueueRefMap.put(obj, this.pooledObjects.add(new SharedObject<T>(obj, nrTimesShared)));
        ++this.nrObjects;
        return obj;
    }

    @Override
    public void recycle(final T object, final Exception e) {
        if (e != null) {
            if (this.asyncValidate) {
                DefaultExecutor.INSTANCE.execute(new AbstractRunnable(true){

                    @Override
                    public void doRun() {
                        SharingObjectPool.this.validate(object, e);
                    }
                });
            } else {
                this.validate(object, e);
            }
        } else {
            this.returnToQueue(object);
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private synchronized void validate(T object, Exception e) {
        if (this.o2QueueRefMap.containsKey(object)) {
            boolean isValid;
            try {
                isValid = this.factory.validate(object, e);
            }
            catch (Exception ex) {
                ex.addSuppressed(e);
                LOG.warn("Validation failed for {}", object, (Object)ex);
                isValid = false;
            }
            if (!isValid) {
                UpdateablePriorityQueue.ElementRef qref = this.o2QueueRefMap.remove(object);
                --this.nrObjects;
                qref.remove();
            } else {
                this.returnToQueue(object);
            }
        }
    }

    private synchronized void returnToQueue(T object) {
        UpdateablePriorityQueue.ElementRef ref = this.o2QueueRefMap.get(object);
        if (ref != null) {
            SharedObject elem = (SharedObject)ref.getElem();
            elem.dec();
            this.notifyAll();
            ref.elementMutated();
        }
    }

    @Override
    public void recycle(T object) {
        this.recycle(object, null);
    }

    @Override
    public synchronized boolean tryDispose(long timeoutMillis) throws ObjectDisposeException, InterruptedException {
        if (!this.closed) {
            long deadline = System.currentTimeMillis() + timeoutMillis;
            this.closed = true;
            ObjectDisposeException exres = null;
            Iterator<SharedObject<T>> iterator = this.pooledObjects.iterator();
            while (iterator.hasNext()) {
                SharedObject<T> so = iterator.next();
                try {
                    while (so.getNrTimesShared() > 0) {
                        long waitFor = deadline - System.currentTimeMillis();
                        if (waitFor > 0L) {
                            this.wait(waitFor);
                            continue;
                        }
                        return false;
                    }
                    T o = so.getObject();
                    this.o2QueueRefMap.remove(o);
                    iterator.remove();
                    --this.nrObjects;
                    this.factory.dispose(o);
                }
                catch (ObjectDisposeException ex) {
                    if (exres == null) {
                        exres = ex;
                        continue;
                    }
                    ex.addSuppressed(exres);
                    exres = ex;
                }
            }
            if (exres != null) {
                throw exres;
            }
        }
        return true;
    }

    public synchronized String toString() {
        return "SharingObjectPool{factory=" + this.factory + ", pooledObjects=" + this.pooledObjects + '}';
    }

    public static final class SharedObject<T> {
        private int nrTimesShared;
        private final T object;

        public SharedObject(T object) {
            this(object, 0);
        }

        public SharedObject(T object, int nrTimeShared) {
            this.object = object;
            this.nrTimesShared = nrTimeShared;
        }

        public T getObject() {
            return this.object;
        }

        private void inc() {
            ++this.nrTimesShared;
        }

        private void dec() {
            --this.nrTimesShared;
        }

        public int getNrTimesShared() {
            return this.nrTimesShared;
        }

        public String toString() {
            return "SharedObject{nrTimesShared=" + this.nrTimesShared + ", object=" + this.object + '}';
        }
    }
}

