/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.reflect;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.concurrent.UnboundedLoadingCache;
import org.spf4j.reflect.ByTypeSupplier;
import org.spf4j.reflect.TypeMap;

@ThreadSafe
public final class CachingTypeMapSupplierWrapper<H, E extends Exception>
implements ByTypeSupplier<H, E> {
    private final LoadingCache<Type, Set<H>> cache;
    @GuardedBy(value="syncObj")
    private final TypeMap<ByTypeSupplier<H, E>> wrapped;
    private final Object syncObj = new Object();
    private final Class<E> exClass;

    public CachingTypeMapSupplierWrapper(CacheBuilder<Type, Set<H>> cacheBuilder, TypeMap wrapped, Class<E> exClass) {
        this.wrapped = wrapped;
        this.exClass = exClass;
        this.cache = cacheBuilder.build((CacheLoader)new TypeMapedObjLoader());
    }

    public CachingTypeMapSupplierWrapper(TypeMap wrapped, Class<E> exClass) {
        this.wrapped = wrapped;
        this.exClass = exClass;
        this.cache = new UnboundedLoadingCache<Type, Set<H>>(16, new TypeMapedObjLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putIfNotPresent(Type type, ByTypeSupplier<H, E> appender) {
        Object object = this.syncObj;
        synchronized (object) {
            return this.wrapped.putIfNotPresent(type, appender);
        }
    }

    public void safePut(Type type, ByTypeSupplier<H, E> object) {
        if (!this.putIfNotPresent(type, object)) {
            throw new IllegalArgumentException("Cannot put " + type + ", " + object + " exiting mapping present");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Type type) {
        boolean remove;
        Object object = this.syncObj;
        synchronized (object) {
            remove = this.wrapped.remove(type);
        }
        if (remove) {
            this.cache.invalidateAll();
            return true;
        }
        return false;
    }

    public void clearCache() {
        this.cache.invalidateAll();
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE", "SPP_USE_ISEMPTY", "LEST_LOST_EXCEPTION_STACK_TRACE"})
    public H get(Type type) throws E {
        Set get;
        try {
            get = (Set)this.cache.get((Object)type);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause.getClass() == this.exClass) {
                throw (Exception)cause;
            }
            throw new UncheckedExecutionException((Throwable)ex);
        }
        int size = get.size();
        if (size == 1) {
            return (H)get.iterator().next();
        }
        if (size == 0) {
            return null;
        }
        throw new IllegalArgumentException("Ambiguous handlers " + get + " for " + type + " in  " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String wts;
        TypeMap<ByTypeSupplier<H, E>> typeMap = this.wrapped;
        synchronized (typeMap) {
            wts = this.wrapped.toString();
        }
        return "CachingTypeMapWrapper{cache=" + this.cache + ", wrapped=" + wts + '}';
    }

    private final class TypeMapedObjLoader
    extends CacheLoader<Type, Set<H>> {
        private TypeMapedObjLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<H> load(Type key) throws Exception {
            TypeMap typeMap = CachingTypeMapSupplierWrapper.this.wrapped;
            synchronized (typeMap) {
                Set all = CachingTypeMapSupplierWrapper.this.wrapped.getAll(key);
                HashSet result = new HashSet(all.size());
                for (ByTypeSupplier s : all) {
                    result.add(s.get(key));
                }
                return result;
            }
        }
    }
}

