/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ssdump2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.spf4j.base.Handler;
import org.spf4j.base.Method;
import org.spf4j.io.MemorizingBufferedInputStream;
import org.spf4j.ssdump2.avro.AMethod;
import org.spf4j.ssdump2.avro.ASample;
import org.spf4j.stackmonitor.SampleNode;

public final class Converter {
    private Converter() {
    }

    public static <E extends Exception> int convert(Method method, SampleNode node, int parentId, int id, Handler<ASample, E> handler) throws E {
        ArrayDeque<TraversalNode> dq = new ArrayDeque<TraversalNode>();
        dq.addLast(new TraversalNode(method, node, parentId));
        int nid = id;
        while (!dq.isEmpty()) {
            TraversalNode first = (TraversalNode)dq.removeFirst();
            Method m = first.getMethod();
            ASample sample = new ASample();
            sample.id = nid;
            SampleNode n = first.getNode();
            sample.count = n.getSampleCount();
            AMethod am = new AMethod();
            am.setName(m.getMethodName());
            am.setDeclaringClass(m.getDeclaringClass());
            sample.method = am;
            sample.parentId = first.getParentId();
            TMap<Method, SampleNode> subNodes = n.getSubNodes();
            int pid = nid;
            if (subNodes != null) {
                subNodes.forEachEntry((a, b) -> {
                    dq.addLast(new TraversalNode((Method)a, (SampleNode)b, pid));
                    return true;
                });
            }
            handler.handle(sample, parentId);
            ++nid;
        }
        return nid;
    }

    public static SampleNode convert(Iterator<ASample> samples) {
        TIntObjectHashMap index = new TIntObjectHashMap();
        while (samples.hasNext()) {
            ASample asmp = samples.next();
            SampleNode sn = new SampleNode(asmp.count, (TMap<Method, SampleNode>)new THashMap());
            SampleNode parent = (SampleNode)index.get(asmp.parentId);
            if (parent != null) {
                AMethod method = asmp.getMethod();
                Method m = Method.getMethod(method.declaringClass, method.getName());
                TMap<Method, SampleNode> subNodes = parent.getSubNodes();
                if (subNodes == null) {
                    throw new IllegalStateException("Bug, state " + index + "; at node " + (Object)((Object)asmp));
                }
                subNodes.put(m, sn);
            }
            index.put(asmp.id, (Object)sn);
        }
        return (SampleNode)index.get(0);
    }

    public static void save(File file, SampleNode collected) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            SpecificDatumWriter writer = new SpecificDatumWriter(ASample.SCHEMA$);
            BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)bos, null);
            Converter.convert(Method.ROOT, collected, -1, 0, (object, deadline) -> writer.write((Object)object, (Encoder)encoder));
            encoder.flush();
        }
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public static SampleNode load(File file) throws IOException {
        try (MemorizingBufferedInputStream bis = new MemorizingBufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            final PushbackInputStream pis = new PushbackInputStream(bis);
            final SpecificDatumReader reader = new SpecificDatumReader(ASample.SCHEMA$);
            final BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder((InputStream)pis, null);
            SampleNode sampleNode = Converter.convert(new Iterator<ASample>(){

                @Override
                public boolean hasNext() {
                    try {
                        int read = pis.read();
                        pis.unread(read);
                        return read >= 0;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }

                @Override
                @SuppressFBWarnings
                public ASample next() {
                    try {
                        return (ASample)((Object)reader.read(null, (Decoder)decoder));
                    }
                    catch (IOException ex) {
                        NoSuchElementException e = new NoSuchElementException();
                        e.addSuppressed(ex);
                        throw e;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            });
            return sampleNode;
        }
    }

    private static final class TraversalNode {
        private final Method method;
        private final SampleNode node;
        private final int parentId;

        TraversalNode(Method method, SampleNode node, int parentId) {
            this.method = method;
            this.node = node;
            this.parentId = parentId;
        }

        public Method getMethod() {
            return this.method;
        }

        public SampleNode getNode() {
            return this.node;
        }

        public int getParentId() {
            return this.parentId;
        }

        public String toString() {
            return "TraversalNode{method=" + this.method + ", node=" + this.node + ", parentId=" + this.parentId + '}';
        }
    }
}

