/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.spf4j.stackmonitor.AbstractStackCollector;

public final class MxStackCollector
extends AbstractStackCollector {
    private static final ThreadMXBean THREAD_MX = ManagementFactory.getThreadMXBean();

    @Override
    public void sample(Thread ignore) {
        ThreadInfo[] stackDump = THREAD_MX.dumpAllThreads(false, false);
        this.recordStackDump(stackDump, ignore);
    }

    private void recordStackDump(ThreadInfo[] stackDump, Thread ignore) {
        long id = ignore.getId();
        for (ThreadInfo entry : stackDump) {
            StackTraceElement[] stackTrace = entry.getStackTrace();
            if (stackTrace.length <= 0 || entry.getThreadId() == id) continue;
            this.addSample(stackTrace);
        }
    }
}

