/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.spf4j.stackmonitor.AbstractStackCollector;
import org.spf4j.stackmonitor.FastStackCollector;

@Beta
public final class ObservableStackCollector
extends AbstractStackCollector {
    private final Predicate<Thread> threadFilter;
    private final ConcurrentMap<Thread, Consumer<StackTraceElement[]>> stConsumers;
    private Thread[] requestFor = new Thread[0];

    public ObservableStackCollector(boolean collectForMain, String ... xtraIgnoredThreads) {
        this(FastStackCollector.createNameBasedFilter(false, collectForMain, xtraIgnoredThreads));
    }

    public ObservableStackCollector(Predicate<Thread> threadFilter) {
        this.threadFilter = threadFilter;
        this.stConsumers = new ConcurrentHashMap<Thread, Consumer<StackTraceElement[]>>();
    }

    @Nullable
    public Consumer<StackTraceElement[]> registerConsumer(Thread thread, Consumer<StackTraceElement[]> consumer) {
        return this.stConsumers.put(thread, consumer);
    }

    public Consumer<StackTraceElement[]> unregisterConsumer(Thread thread) {
        return (Consumer)this.stConsumers.remove(thread);
    }

    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
    public void sample(Thread ignore) {
        Thread[] threads = FastStackCollector.getThreads();
        int nrThreads = threads.length;
        if (this.requestFor.length < nrThreads) {
            this.requestFor = new Thread[nrThreads - 1];
        }
        int j = 0;
        for (int i = 0; i < nrThreads; ++i) {
            Thread th = threads[i];
            if (ignore == th || this.threadFilter.test(th)) continue;
            this.requestFor[j++] = th;
        }
        Arrays.fill(this.requestFor, j, this.requestFor.length, null);
        StackTraceElement[][] stackDump = FastStackCollector.getStackTraces(this.requestFor);
        for (int i = 0; i < j; ++i) {
            Thread t = this.requestFor[i];
            StackTraceElement[] stackTrace = stackDump[i];
            Consumer consumer = (Consumer)this.stConsumers.get(t);
            if (consumer != null) {
                consumer.accept(stackTrace);
            }
            if (stackTrace != null && stackTrace.length > 0) {
                this.addSample(stackTrace);
                continue;
            }
            this.addSample(new StackTraceElement[]{new StackTraceElement("Thread", t.getName(), "", 0)});
        }
    }
}

