/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.CharSequences;
import org.spf4j.base.IntMath;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.perf.memory.GCUsageSampler;
import org.spf4j.ssdump2.Converter;
import org.spf4j.stackmonitor.FastStackCollector;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.Spf4jProfilerException;
import org.spf4j.stackmonitor.StackCollector;

@ThreadSafe
public final class Sampler {
    private static final int STOP_FLAG_READ_MILLIS = Integer.getInteger("spf4j.perf.ms.stopFlagReadMIllis", 2000);
    public static final String DEFAULT_SS_DUMP_FOLDER = System.getProperty("spf4j.perf.ms.defaultSsdumpFolder", System.getProperty("java.io.tmpdir"));
    public static final String DEFAULT_SS_DUMP_FILE_NAME_PREFIX = CharSequences.validatedFileName(System.getProperty("spf4j.perf.ms.defaultSsdumpFilePrefix", ManagementFactory.getRuntimeMXBean().getName()));
    private static final StackTraceElement[] GC_FAKE_STACK = new StackTraceElement[]{new StackTraceElement("java.lang.System", "gc", "System.java", -1)};
    private static final DateTimeFormatter TS_FORMAT = ISODateTimeFormat.basicDateTimeNoMillis();
    private volatile boolean stopped;
    private volatile int sampleTimeMillis;
    private volatile int dumpTimeMillis;
    private final StackCollector stackCollector;
    private volatile long lastDumpTime = System.currentTimeMillis();
    @GuardedBy(value="this")
    private Future<?> samplerFuture;
    private final String filePrefix;
    private final IntMath.XorShift32 random = new IntMath.XorShift32();

    public String toString() {
        return "Sampler{stopped=" + this.stopped + ", sampleTimeMillis=" + this.sampleTimeMillis + ", dumpTimeMillis=" + this.dumpTimeMillis + ", lastDumpTime=" + this.lastDumpTime + ", filePrefix=" + this.filePrefix + '}';
    }

    public Sampler() {
        this(10, 3600000, new FastStackCollector(false, new String[0]));
    }

    public Sampler(int sampleTimeMillis) {
        this(sampleTimeMillis, 3600000, new FastStackCollector(false, new String[0]));
    }

    public Sampler(StackCollector collector) {
        this(10, 3600000, collector);
    }

    public Sampler(int sampleTimeMillis, int dumpTimeMillis, StackCollector collector) {
        this(sampleTimeMillis, dumpTimeMillis, collector, DEFAULT_SS_DUMP_FOLDER, DEFAULT_SS_DUMP_FILE_NAME_PREFIX);
    }

    public Sampler(int sampleTimeMillis, int dumpTimeMillis, StackCollector collector, String dumpFolder, String dumpFilePrefix) {
        CharSequences.validatedFileName(dumpFilePrefix);
        this.stopped = true;
        if (sampleTimeMillis < 1) {
            throw new IllegalArgumentException("Invalid sample time " + sampleTimeMillis);
        }
        this.sampleTimeMillis = sampleTimeMillis;
        this.dumpTimeMillis = dumpTimeMillis;
        this.stackCollector = collector;
        this.filePrefix = dumpFolder + File.separator + dumpFilePrefix;
    }

    public void registerJmx() {
        Registry.export(this);
    }

    @JmxExport(description="start stack sampling")
    public synchronized void start() {
        if (!this.stopped) {
            throw new IllegalStateException("Sampling can only be started once for " + this);
        }
        this.stopped = false;
        final int stMillis = this.sampleTimeMillis;
        final List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        this.samplerFuture = DefaultExecutor.INSTANCE.submit(new AbstractRunnable("SPF4J-Sampling-Thread"){

            @Override
            @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
            public void doRun() throws IOException, InterruptedException {
                Thread samplerThread = Thread.currentThread();
                int dumpCounterMs = 0;
                int coarseCounter = 0;
                int coarseCount = STOP_FLAG_READ_MILLIS / stMillis;
                boolean lstopped = Sampler.this.stopped;
                long prevGcTime = 0L;
                int sleepTime = 0;
                int halfStMillis = stMillis / 2;
                if (halfStMillis == 0) {
                    halfStMillis = 1;
                }
                while (!lstopped) {
                    Sampler.this.stackCollector.sample(samplerThread);
                    dumpCounterMs += sleepTime;
                    if (++coarseCounter >= coarseCount) {
                        coarseCounter = 0;
                        lstopped = Sampler.this.stopped;
                        long gcTime = GCUsageSampler.getGCTime(gcBeans);
                        if (gcTime > prevGcTime) {
                            int fakeSamples = (int)(gcTime - prevGcTime) / stMillis;
                            for (int i = 0; i < fakeSamples; ++i) {
                                Sampler.this.stackCollector.addSample(GC_FAKE_STACK);
                            }
                            prevGcTime = gcTime;
                        }
                    }
                    if (dumpCounterMs >= Sampler.this.dumpTimeMillis) {
                        long timeSinceLastDump = System.currentTimeMillis() - Sampler.this.lastDumpTime;
                        if (timeSinceLastDump >= (long)Sampler.this.dumpTimeMillis) {
                            dumpCounterMs = 0;
                            Sampler.this.dumpToFile();
                        } else {
                            dumpCounterMs = (int)((long)dumpCounterMs - ((long)Sampler.this.dumpTimeMillis - timeSinceLastDump));
                        }
                    }
                    sleepTime = stMillis + Sampler.this.random.nextInt() % halfStMillis;
                    Thread.sleep(sleepTime);
                }
            }
        });
    }

    @JmxExport(description="save stack samples to file")
    @Nullable
    public File dumpToFile() throws IOException {
        return this.dumpToFile((String)null);
    }

    @JmxExport(value="dumpToSpecificFile", description="save stack samples to file")
    @Nullable
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public synchronized File dumpToFile(@JmxExport(value="fileID", description="the ID that will be part of the file name") @Nullable String id) throws IOException {
        String fileName = this.filePrefix + CharSequences.validatedFileName((id == null ? "" : '_' + id) + '_' + TS_FORMAT.print(this.lastDumpTime) + '_' + TS_FORMAT.print(System.currentTimeMillis()) + ".ssdump2");
        File file = new File(fileName);
        return this.dumpToFile(file);
    }

    @Nullable
    public File dumpToFile(@Nonnull File file) throws IOException {
        Preconditions.checkArgument((boolean)file.getName().endsWith(".ssdump2"), (String)"File name must have ssdump2 extension not %s", (Object)file);
        SampleNode collected = this.stackCollector.clear();
        if (collected != null) {
            Converter.save(file, collected);
            this.lastDumpTime = System.currentTimeMillis();
            return file;
        }
        return null;
    }

    @JmxExport(description="stop stack sampling")
    public synchronized void stop() throws InterruptedException {
        if (!this.stopped) {
            this.stopped = true;
            try {
                this.samplerFuture.get(STOP_FLAG_READ_MILLIS << 2, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ex) {
                this.samplerFuture.cancel(true);
                throw new Spf4jProfilerException(ex);
            }
            catch (ExecutionException ex) {
                throw new Spf4jProfilerException(ex);
            }
        }
    }

    @JmxExport(description="stack sample time in milliseconds")
    public int getSampleTimeMillis() {
        return this.sampleTimeMillis;
    }

    @JmxExport
    public void setSampleTimeMillis(int sampleTimeMillis) {
        this.sampleTimeMillis = sampleTimeMillis;
    }

    @JmxExport(description="is the stack sampling stopped")
    public boolean isStopped() {
        return this.stopped;
    }

    @JmxExport(description="clear in memory collected stack samples")
    public void clear() {
        this.stackCollector.clear();
    }

    public StackCollector getStackCollector() {
        return this.stackCollector;
    }

    @PreDestroy
    public void dispose() throws InterruptedException {
        this.stop();
        Registry.unregister(this);
    }

    @JmxExport(description="interval in milliseconds to save stack stamples periodically")
    public int getDumpTimeMillis() {
        return this.dumpTimeMillis;
    }

    @JmxExport
    public void setDumpTimeMillis(int dumpTimeMillis) {
        this.dumpTimeMillis = dumpTimeMillis;
    }
}

