/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.unix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Arrays;
import org.spf4j.base.Runtime;

@Deprecated
@SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
public final class Ulimit {
    private static final String[] ULIMIT_CMD = Runtime.isWindows() ? null : Ulimit.findUlimitCmd();

    private Ulimit() {
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    private static String[] findUlimitCmd() {
        File bash = new File("/bin/bash");
        File sh = new File("/bin/sh");
        File uLimit = new File("/usr/bin/ulimit");
        if (uLimit.exists() && uLimit.canExecute()) {
            return new String[]{uLimit.getPath()};
        }
        if (bash.exists() && bash.canExecute()) {
            return new String[]{bash.getPath(), "-c", "ulimit"};
        }
        if (sh.exists() && sh.canExecute()) {
            return new String[]{sh.getPath(), "-c", "ulimit"};
        }
        return null;
    }

    public static int runUlimit(String ... options) {
        int mfiles;
        if (ULIMIT_CMD == null) {
            Lazy.LOG.warn("Ulimit not available, assuming no limits");
            return Integer.MAX_VALUE;
        }
        try {
            String[] cmd = Arrays.concat(ULIMIT_CMD, options);
            String result = Runtime.run(cmd, 10000L).toString();
            if (result.contains("unlimited")) {
                mfiles = Integer.MAX_VALUE;
            } else {
                try {
                    mfiles = Integer.parseInt(result.trim());
                }
                catch (NumberFormatException ex) {
                    Lazy.LOG.warn("Error while parsing ulimit output, assuming no limit", (Throwable)ex);
                    mfiles = Integer.MAX_VALUE;
                }
            }
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException ex) {
            Lazy.LOG.warn("Error while running ulimit, assuming no limit", (Throwable)ex);
            mfiles = Integer.MAX_VALUE;
        }
        return mfiles;
    }

    private static final class Lazy {
        private static final Logger LOG = LoggerFactory.getLogger(Lazy.class);

        private Lazy() {
        }
    }
}

