/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Callables;
import org.spf4j.base.TestException;
import org.spf4j.base.Throwables;
import org.spf4j.base.TimeSource;

@SuppressFBWarnings(value={"BED_BOGUS_EXCEPTION_DECLARATION"})
public final class CallablesTest {
    private static final Logger LOG = LoggerFactory.getLogger(CallablesTest.class);

    @Test(expected=TestException.class)
    public void testExceptionPropagation() throws Exception {
        Callables.executeWithRetry((Callables.TimeoutCallable)new Callables.TimeoutCallable<Integer, TestException>(60000){

            public Integer call(long deadline) throws TestException {
                throw new TestException();
            }
        }, (int)3, (int)10, TestException.class);
    }

    @Test(expected=TimeoutException.class)
    public void testExceptionPropagation2() throws InterruptedException, TimeoutException {
        Callables.executeWithRetry((Callables.TimeoutCallable)new Callables.TimeoutCallable<Integer, RuntimeException>(3000){

            public Integer call(long deadline) throws TimeoutException {
                throw new TimeoutException();
            }
        }, (int)3, (int)10, RuntimeException.class);
    }

    @Test
    public void testExecuteWithRetry4args1() throws Exception {
        Integer result = (Integer)Callables.executeWithRetry((Callables.TimeoutCallable)new Callables.TimeoutCallable<Integer, RuntimeException>(60000){

            public Integer call(long deadline) {
                return 1;
            }
        }, (int)3, (int)10, RuntimeException.class);
        Assert.assertEquals((long)1L, (long)result.longValue());
    }

    @Test
    public void testExecuteWithRetry4args2() throws Exception {
        long startTime = TimeSource.nanoTime();
        Integer result = (Integer)Callables.executeWithRetry((Callables.TimeoutCallable)new Callables.TimeoutCallable<Integer, IOException>(60000){
            private int count;

            public Integer call(long deadline) throws IOException {
                ++this.count;
                if (this.count < 20) {
                    throw new SocketException("Aaaaaaaaaaa" + this.count);
                }
                return 1;
            }
        }, (int)1, (int)10, IOException.class);
        long elapsedTime = TimeSource.nanoTime() - startTime;
        Assert.assertEquals((long)1L, (long)result.longValue());
        Assert.assertTrue((String)"Operation has to take at least 10 ms", (elapsedTime > TimeUnit.MILLISECONDS.toNanos(10L) ? 1 : 0) != 0);
    }

    @Test
    public void testExecuteWithRetryFailureTest() throws IOException, InterruptedException {
        try {
            Callables.executeWithRetry((Callables.TimeoutCallable)new Callables.TimeoutCallable<Integer, IOException>(100){

                public Integer call(long deadline) throws IOException {
                    throw new SocketException("Aaaaaaaaaaa " + System.currentTimeMillis());
                }
            }, (int)4, (int)100, IOException.class);
            Assert.fail((String)"Should not get here");
        }
        catch (IOException | TimeoutException e) {
            Assert.assertTrue((String)("must have supressed exceptions: " + com.google.common.base.Throwables.getStackTraceAsString((Throwable)e)), (Throwables.getSuppressed((Throwable)e).length >= 1 ? 1 : 0) != 0);
        }
    }

    @Test
    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
    public void testSuppression() throws InterruptedException, IOException, TimeoutException {
        long startTime = System.currentTimeMillis();
        Integer result = (Integer)Callables.executeWithRetry((Callables.TimeoutCallable)new Callables.TimeoutCallable<Integer, IOException>(60000){
            private int count;

            public Integer call(long deadline) throws IOException {
                ++this.count;
                if (this.count < 15) {
                    throw new SocketException("Aaaaaaaaaaa" + this.count);
                }
                return 1;
            }
        }, (int)1, (int)20, (Callables.AdvancedRetryPredicate)new Callables.AdvancedRetryPredicate<Exception>(){

            public Callables.AdvancedAction apply(Exception input) {
                Throwable[] suppressed = Throwables.getSuppressed((Throwable)input);
                if (suppressed.length > 0) {
                    throw new UnsupportedOperationException();
                }
                return Callables.AdvancedAction.RETRY;
            }
        }, IOException.class);
        long elapsedTime = System.currentTimeMillis() - startTime;
        Assert.assertEquals((long)1L, (long)result.longValue());
        Assert.assertTrue((String)("Operation has to take at least 10 ms and not " + elapsedTime), (elapsedTime > 10L ? 1 : 0) != 0);
    }

    @Test
    public void testExecuteWithRetryTimeout() {
        try {
            Callables.executeWithRetry((Callables.TimeoutCallable)new Callables.TimeoutCallable<Integer, IOException>(1000){
                private int count;

                @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
                public Integer call(long deadline) throws IOException, InterruptedException {
                    Thread.sleep(2000L);
                    ++this.count;
                    if (this.count < 5) {
                        throw new SocketException("Aaaaaaaaaaa" + this.count);
                    }
                    return 1;
                }
            }, (int)1, (int)10, IOException.class);
            Assert.fail();
        }
        catch (IOException | InterruptedException | TimeoutException ex) {
            Throwables.writeTo((Throwable)ex, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.NONE);
        }
    }

    @Test(expected=TimeoutException.class)
    public void testExecuteWithRetryTimeout2() throws InterruptedException, IOException, TimeoutException {
        Callables.executeWithRetry((Callables.TimeoutCallable)new Callables.TimeoutCallable<Integer, IOException>(1000){
            private int count;
            {
                this.count = 0;
            }

            public Integer call(long deadline) throws IOException {
                LOG.debug("Exec {}", (Object)this);
                ++this.count;
                if (this.count < 200) {
                    throw new SocketException("Aaaaaaaaaaa" + this.count);
                }
                return 1;
            }
        }, (int)0, (int)100, IOException.class);
        Assert.fail();
    }

    public void testExecuteWithRetry4args3() throws Exception {
        CallableImpl callableImpl = new CallableImpl(60000);
        try {
            Callables.executeWithRetry((Callables.TimeoutCallable)callableImpl, (int)3, (int)10, Exception.class);
            Assert.fail((String)"this should throw a exception");
        }
        catch (Exception e) {
            Assert.assertEquals((long)11L, (long)callableImpl.getCount());
        }
    }

    public void testExecuteWithRetry5args3() throws Exception {
        CallableImpl2 callableImpl = new CallableImpl2(60000);
        Callables.executeWithRetry((Callables.TimeoutCallable)callableImpl, (int)2, (int)10, (t, deadline, callable) -> t > 0 ? Callables.RetryDecision.retry((long)0L, (Callable)callable) : Callables.RetryDecision.abort(), (Callables.AdvancedRetryPredicate)Callables.DEFAULT_EXCEPTION_RETRY, Exception.class);
        Assert.assertEquals((long)4L, (long)callableImpl.getCount());
    }

    @Test
    public void testOverflow() {
        Assert.assertEquals((long)Long.MAX_VALUE, (long)Callables.overflowSafeAdd((long)Long.MAX_VALUE, (long)1L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)Callables.overflowSafeAdd((long)Long.MAX_VALUE, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)3L, (long)Callables.overflowSafeAdd((long)1L, (long)2L));
    }

    private static class CallableImpl2
    extends Callables.TimeoutCallable<Integer, Exception> {
        private int count;

        CallableImpl2(int timeoutMillis) {
            super(timeoutMillis);
        }

        public Integer call(long deadline) throws Exception {
            ++this.count;
            return this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class CallableImpl
    extends Callables.TimeoutCallable<Integer, Exception> {
        private int count;

        CallableImpl(int timeoutMillis) {
            super(timeoutMillis);
        }

        public Integer call(long deadline) throws Exception {
            ++this.count;
            throw new Exception("Aaaaaaaaaaa" + this.count);
        }

        public int getCount() {
            return this.count;
        }
    }
}

